/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.uol;

import IPMIView20.UOLMessage;
import java.util.ArrayList;

public class UOLStorage {
    private ArrayList packets = new ArrayList();
    private boolean allowGet = true;
    private byte currentPacketSequence = 0;

    private void traceAllowGet() {
        Thread th = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("allowGet =" + UOLStorage.this.allowGet);
                }
            }
        };
        th.start();
    }

    public synchronized UOLMessage get() {
        while (this.packets.size() == 0 || !this.allowGet) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        this.allowGet = false;
        UOLMessage message = (UOLMessage)this.packets.remove(0);
        this.currentPacketSequence = message.getPacketSequenceNumber();
        this.notify();
        return message;
    }

    public synchronized void put(UOLMessage message) {
        this.packets.add(message);
        this.notify();
    }

    public synchronized void clear() {
        this.packets.clear();
    }

    public synchronized void allowGet() {
        this.allowGet = true;
        this.notify();
    }

    public synchronized void disAllowGet() {
        this.allowGet = false;
    }

    public synchronized boolean isAllowGet() {
        return this.allowGet;
    }

    public synchronized byte getCurrentPacketSequence() {
        return this.currentPacketSequence;
    }

    public synchronized int size() {
        return this.packets.size();
    }
}

