/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.update;

import IPMIView20.BrowserControl;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.update.CheckingVersionDialog;
import IPMIView20.update.FTPConnection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

public class CheckUpdate {
    public static final int START_FROM_IPMIVIEW_START_UP = 1;
    public static final int START_FROM_MANUAL = 2;
    public static final int RUN_TYPE_JAR = 1;
    public static final int RUN_TYPE_INSTALLSHIELD = 2;
    public static final int OS_WINDOWS = 1;
    public static final int OS_LINUX = 2;
    CheckingVersionDialog checkingVersionDialog;
    public String ftpAddress = "ftp.supermicro.com";
    public String id = "anonymous";
    public String password = "IPMIViewUser@guest.com";
    public String folder = "update/IPMIView";
    public String versionFile = "v.txt";
    public String jarFile = "IPMIView20.jar";
    public String updaterFile = "Updater.jar";
    public int runType = 1;
    public int osType = BrowserControl.isWindowsPlatform() ? 1 : 2;

    public CheckUpdate() {
        File f = new File("_jvm");
        if (f.isDirectory()) {
            this.runType = 2;
        }
        this.checkingVersionDialog = new CheckingVersionDialog(IPMIView20.getInstance(), "", false);
    }

    public OnSiteVersion checkVersion() throws Exception {
        return null;
    }

    public void createUpdaterJar() throws Exception {
        int read;
        FileInputStream fin = new FileInputStream(this.jarFile);
        FileOutputStream fout = new FileOutputStream(this.updaterFile);
        byte[] buf = new byte[8096];
        while ((read = fin.read(buf)) > 0) {
            fout.write(buf, 0, read);
        }
        fin.close();
        fout.close();
    }

    public boolean downloadIPMIView(Observer o) throws Exception {
        boolean flag = false;
        FTPConnection connection = new FTPConnection();
        if (o != null) {
            connection.addObserver(o);
        }
        if (connection.connect(this.ftpAddress)) {
            if (connection.login(this.id, this.password)) {
                connection.changeDirectory(this.folder);
                connection.fileSize = connection.getFileSize(this.jarFile);
                connection.downloadFile(this.jarFile);
            }
            connection.disconnect();
            flag = true;
        }
        return flag;
    }

    public boolean downloadIPMIView2(Observer o) throws Exception {
        return false;
    }

    public String renameIPMIView() throws Exception {
        File f = new File("IPMIView20.jar");
        File f2 = new File("IPMIView20." + IPMIView20.BuildVersion + "." + IPMIView20.BuildSeq + ".jar");
        if (f2.isFile()) {
            f2.delete();
        }
        if (!f.isFile()) {
            throw new Exception("No such file");
        }
        f.renameTo(f2);
        if (f.isFile()) {
            throw new Exception("The IPMIView has been locked. Cannot update it");
        }
        return f2.getName();
    }

    public void restoreIPMIView(String backupedFilename) {
        File f = new File("IPMIView20.jar");
        File f2 = new File(backupedFilename);
        f2.renameTo(f);
    }

    private int loadCheckAtStartConfiguration() {
        File f = new File("update.properties");
        String timeoutString = "";
        if (f.exists()) {
            try {
                FileReader fin = new FileReader("update.properties");
                BufferedReader br = new BufferedReader(fin);
                timeoutString = br.readLine();
                fin.close();
                try {
                    int flag = timeoutString != null ? Integer.parseInt(timeoutString) : -1;
                    return flag;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {}
        } else {
            return 0;
        }
        return 0;
    }

    private void writeCheckAtStartProperties(int flag) {
        try {
            FileWriter outs = new FileWriter("update.properties", false);
            outs.write("" + flag + "\n");
            outs.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startCheck(int startType) {
        OnSiteVersion version = null;
        if (startType == 2) {
            this.checkingVersionDialog.setVisible(true);
        }
        this.checkingVersionDialog.jMessageLabel.setText(L.t("checkUpdate.Loading") + " ...");
        int flag = this.loadCheckAtStartConfiguration();
        if (flag == 0 && startType == 1) {
            return;
        }
        try {
            version = this.checkVersion();
        }
        catch (Exception ex) {
            if (startType == 2) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("checkUpdate.Exception") + ": " + ex.getMessage());
            }
            return;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (startType == 2) {
            this.checkingVersionDialog.setVisible(false);
        }
        if (version == null) {
            if (startType == 2) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("checkUpdate.There_is_no_new_update_for_IPMIView"));
            }
            return;
        }
        int onSiteVersion = 0;
        try {
            onSiteVersion = Integer.parseInt(version.build);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        IPMIView20.getInstance();
        if (onSiteVersion <= Integer.parseInt(IPMIView20.BuildSeq)) {
            if (startType == 2) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("checkUpdate.Your_IPMIView_is_up_to_date"));
            }
            return;
        }
        Object[] message = new Object[5];
        JCheckBox checkAtStartup = new JCheckBox(L.t("checkUpdate.Check_new_update_at_start_up"));
        message[0] = L.t("checkUpdate.A_new_IPMIView_available") + "\n\n";
        message[1] = "IPMIView " + version.version + " Build " + version.build + "\n\n";
        message[2] = L.t("checkUpdate.Detail") + ":\n" + version.updateList + "\n\n";
        message[3] = L.t("checkUpdate.Would_you_like_to_update_this_version") + " ? \n\n";
        message[4] = checkAtStartup;
        if (flag == 1) {
            checkAtStartup.setSelected(true);
        }
        int result = JOptionPane.showOptionDialog(IPMIView20.getInstance(), message, L.t("checkUpdate.Update") + " IPMIView", 0, 3, null, null, null);
        if (checkAtStartup.isSelected()) {
            this.writeCheckAtStartProperties(1);
        } else {
            this.writeCheckAtStartProperties(0);
        }
        if (result != 0) {
            return;
        }
        try {
            this.createUpdaterJar();
        }
        catch (Exception ex1) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("checkUpdate.Starting_update_process_failed"));
        }
        boolean alreadyRunUpdateProgram = false;
        try {
            switch (this.runType) {
                case 1: {
                    Runtime.getRuntime().exec("java -cp Updater.jar IPMIView20.update.Updater 1");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    alreadyRunUpdateProgram = true;
                    break;
                }
                case 2: {
                    if (this.osType == 1) {
                        Runtime.getRuntime().exec("Updater.exe 2");
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        alreadyRunUpdateProgram = true;
                        break;
                    }
                    if (this.osType != 2) break;
                    Process p = Runtime.getRuntime().exec("./Updater.bin 2");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    alreadyRunUpdateProgram = true;
                    break;
                }
                default: {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("checkUpdate.No_available_update_program"));
                    break;
                }
            }
        }
        catch (IOException ex2) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("checkUpdate.Starting_update_program_failed"));
        }
        if (alreadyRunUpdateProgram) {
            System.exit(0);
        }
    }

    public static void main(String[] args) throws Exception {
        CheckUpdate checker = new CheckUpdate();
        checker.renameIPMIView();
    }

    class OnSiteVersion {
        String version;
        String build;
        String updateList;

        OnSiteVersion() {
        }
    }
}

