/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.loc.TagLoc;
import com.supermicro.ipmi.loc.TagLocSDR;
import com.supermicro.ipmi.stunnel.StunnelUtility;

public class IPMIOEMLocCommand
extends IPMICommand {
    public IPMIOEMLocCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    private void CMD____________() {
    }

    private void API____________() {
    }

    public void addTagLocSDR(TagLocSDR tagLocSDR) throws IPMIException {
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.getIPMIInterface());
        ipmiSDRCommand.addSDR(tagLocSDR.toRaw());
    }

    public TagLocSDR getTagLocSDR() throws IPMIException {
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.getIPMIInterface());
        TagLocSDR tagLocSDR = ipmiSDRCommand.getTagLocSDR();
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(this.getIPMIInterface());
        String ip = ipmiLanCommand.getIP();
        try {
            tagLocSDR.tagLoc.setIP(ip);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tagLocSDR;
    }

    public TagLocSDR forceGetTagLocSDR() throws IPMIException {
        TagLocSDR tagLocSDR = this.getTagLocSDR();
        if (tagLocSDR == null) {
            tagLocSDR = new TagLocSDR();
            this.addTagLocSDR(tagLocSDR);
        }
        tagLocSDR = this.getTagLocSDR();
        return tagLocSDR;
    }

    public void updateTagLocSDR(TagLocSDR tagLocSDR) throws IPMIException {
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.getIPMIInterface());
        ipmiSDRCommand.deleteSDRRecord(tagLocSDR.recordID);
        ipmiSDRCommand.addSDR(tagLocSDR.toRaw());
    }

    public void removeTagLocSDR(TagLocSDR tagLocSDR) throws IPMIException {
        IPMISDRCommand ipmiSDRCOmmand = new IPMISDRCommand(this.getIPMIInterface());
        ipmiSDRCOmmand.deleteSDRRecord(tagLocSDR.recordID);
    }

    public void setTagLocDataCenter(int dataCenter) throws IPMIException {
        TagLocSDR tagLocSDR = this.forceGetTagLocSDR();
        tagLocSDR.tagLoc.dataCenter = dataCenter;
        this.updateTagLocSDR(tagLocSDR);
    }

    public void setTagLocRoom(int room) throws IPMIException {
        TagLocSDR tagLocSDR = this.forceGetTagLocSDR();
        tagLocSDR.tagLoc.room = room;
        this.updateTagLocSDR(tagLocSDR);
    }

    public void setTagLocRow(int row) throws IPMIException {
        TagLocSDR tagLocSDR = this.forceGetTagLocSDR();
        tagLocSDR.tagLoc.row = row;
        this.updateTagLocSDR(tagLocSDR);
    }

    public void setTagLocRack(int rack) throws IPMIException {
        TagLocSDR tagLocSDR = this.forceGetTagLocSDR();
        tagLocSDR.tagLoc.rack = rack;
        this.updateTagLocSDR(tagLocSDR);
    }

    public void setTagLocNumber(byte major, byte minor) throws IPMIException {
        TagLocSDR tagLocSDR = this.forceGetTagLocSDR();
        tagLocSDR.tagLoc.majorNumber = major;
        tagLocSDR.tagLoc.minorNumber = minor;
        this.updateTagLocSDR(tagLocSDR);
    }

    public void setTagLocMBType(byte mbType) throws IPMIException {
        TagLocSDR tagLocSDR = this.forceGetTagLocSDR();
        tagLocSDR.tagLoc.mbType = mbType;
        this.updateTagLocSDR(tagLocSDR);
    }

    public void setTagLocChassisType(byte chassisType) throws IPMIException {
        TagLocSDR tagLocSDR = this.forceGetTagLocSDR();
        tagLocSDR.tagLoc.chassisType = chassisType;
        this.updateTagLocSDR(tagLocSDR);
    }

    public void setTagLocPowerType(byte powerType) throws IPMIException {
        TagLocSDR tagLocSDR = this.forceGetTagLocSDR();
        tagLocSDR.tagLoc.powerType = powerType;
        this.updateTagLocSDR(tagLocSDR);
    }

    public void setTagLocOSType(byte osType) throws IPMIException {
        TagLocSDR tagLocSDR = this.forceGetTagLocSDR();
        tagLocSDR.tagLoc.osType = osType;
        this.updateTagLocSDR(tagLocSDR);
    }

    public void setTagLocOEMString(String oemString) throws IPMIException {
        TagLocSDR tagLocSDR = this.forceGetTagLocSDR();
        tagLocSDR.tagLoc.setOEMString(oemString);
        this.updateTagLocSDR(tagLocSDR);
    }

    public void setTagLoc(TagLoc tagLoc) throws IPMIException {
        this.setTagLoc(tagLoc.dataCenter, tagLoc.room, tagLoc.row, tagLoc.rack, tagLoc.majorNumber, tagLoc.minorNumber, tagLoc.mbType, tagLoc.chassisType, tagLoc.powerType);
    }

    public void setTagLoc(int dataCenter, int room, int row, int rack, byte majorNumber, byte minorNumber, byte mbType, byte chassisType, byte powerType) throws IPMIException {
        TagLocSDR tagLocSDR = this.forceGetTagLocSDR();
        tagLocSDR.tagLoc.dataCenter = dataCenter;
        tagLocSDR.tagLoc.room = room;
        tagLocSDR.tagLoc.row = row;
        tagLocSDR.tagLoc.rack = rack;
        tagLocSDR.tagLoc.majorNumber = majorNumber;
        tagLocSDR.tagLoc.minorNumber = minorNumber;
        tagLocSDR.tagLoc.mbType = mbType;
        tagLocSDR.tagLoc.chassisType = chassisType;
        tagLocSDR.tagLoc.powerType = powerType;
        this.updateTagLocSDR(tagLocSDR);
    }

    private void CLASS____________() {
    }

    private void MAIN____________() {
    }

    public static void main(String[] args) {
        IPMIOEMLocCommand.main_TagLocSDR(args);
    }

    public static void main_TagLocSDR(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.168.23.93");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        config.setPrivilege((byte)4);
        IPMIOEMLocCommand ipmiOEMLocCommand = new IPMIOEMLocCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiOEMLocCommand);
        if (sessionController == null) {
            return;
        }
        try {
            TagLocSDR tagLocSDR = ipmiOEMLocCommand.getTagLocSDR();
            tagLocSDR.tagLoc.dataCenter = 2012;
            tagLocSDR.tagLoc.room = 2013;
            tagLocSDR.tagLoc.row = 2014;
            tagLocSDR.tagLoc.rack = 2016;
            ipmiOEMLocCommand.updateTagLocSDR(tagLocSDR);
            System.out.println(tagLocSDR.toString());
        }
        catch (IPMIException ex) {
            ex.printStackTrace();
            System.out.println("completion code = " + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode));
        }
        sessionController.closeSession();
    }
}

