/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MDRRegionLockCommand;
import com.supermicro.ipmi.MDRRegionReadCommand;
import com.supermicro.ipmi.MDRRegionStatusCommand;
import com.supermicro.ipmi.MDRRegionUpdateCommand;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.text.MOut;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class MDRRegionWriteCommand
extends IPMICommand {
    final byte intelRSDSpec = (byte)4;
    final byte smbiosRegion = 1;
    final byte iSCSIRegion = (byte)4;
    byte completionCode;
    byte dataRegion;
    byte validData;
    byte lockStatus;
    byte[] maxRegionLength;
    byte[] sizeRegionUsed;
    boolean isDataRegion = false;
    boolean isValidData = false;
    boolean isLockStatus = false;
    boolean isMaxRegionLength = false;
    boolean isSizeRegionUsed = false;

    public MDRRegionWriteCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public String getDataRegion() {
        switch (this.dataRegion) {
            case 1: {
                return "SMBIOS";
            }
            case 4: {
                return "iSCSI Boot Options";
            }
        }
        return "Reserved";
    }

    public String getValidData() {
        switch (this.validData) {
            case 0: {
                return "Invalid";
            }
            case 1: {
                return "Valid";
            }
        }
        return "Reserved";
    }

    public String getLockStatus() {
        switch (this.lockStatus) {
            case 0: {
                return "Unlocked";
            }
            case 1: {
                return "Strict Lock";
            }
            case 2: {
                return "Pre-emptible Lock";
            }
        }
        return "Reserved";
    }

    public byte[] getMaxRegionLength() {
        return this.maxRegionLength;
    }

    public byte[] getSizeRegionUsed() {
        return this.sizeRegionUsed;
    }

    public MDRRegionWriteCommand setMDRRegionWrite(byte sessionLock, byte length, byte[] offset, byte[] written) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, sessionLock, 4, length};
        byte[] offsetData = ArrayUtils.addAll(data, offset);
        byte[] writtenDate = ArrayUtils.addAll(offsetData, written);
        ipmiMessage.setCommandAndData((byte)-80, (byte)35, writtenDate);
        IPMIMessage resMessage = this.getIPMIInterface().send(ipmiMessage);
        MDRRegionWriteCommand mdrRegionWrite = new MDRRegionWriteCommand(this.getIPMIInterface());
        if (resMessage != null) {
            mdrRegionWrite.completionCode = resMessage.completionCode;
            switch (this.completionCode) {
                case -127: {
                    MOut.G().print("Region is in use by another user (0x81)");
                    break;
                }
                case -57: {
                    MOut.G().print("Requested data extends beyond length of region (0xC7)");
                    break;
                }
                case -55: {
                    MOut.G().print("Invalid Region Specified (0xC9)");
                    break;
                }
                case -43: {
                    MOut.G().print("Data region not locked (0xD5)");
                    break;
                }
                case 0: {
                    try {
                        mdrRegionWrite.dataRegion = resMessage.data[1];
                        mdrRegionWrite.isDataRegion = true;
                    }
                    catch (Exception e) {
                        mdrRegionWrite.isDataRegion = false;
                    }
                    try {
                        mdrRegionWrite.validData = resMessage.data[2];
                        mdrRegionWrite.isValidData = true;
                    }
                    catch (Exception e) {
                        mdrRegionWrite.isValidData = false;
                    }
                    try {
                        mdrRegionWrite.lockStatus = resMessage.data[3];
                        mdrRegionWrite.isLockStatus = true;
                    }
                    catch (Exception e) {
                        mdrRegionWrite.isLockStatus = false;
                    }
                    try {
                        mdrRegionWrite.maxRegionLength = Arrays.copyOfRange(resMessage.data, 4, 6);
                        mdrRegionWrite.isMaxRegionLength = true;
                    }
                    catch (Exception e) {
                        mdrRegionWrite.isMaxRegionLength = false;
                    }
                    try {
                        mdrRegionWrite.sizeRegionUsed = Arrays.copyOfRange(resMessage.data, 6, 8);
                        mdrRegionWrite.isSizeRegionUsed = true;
                        break;
                    }
                    catch (Exception e) {
                        mdrRegionWrite.isSizeRegionUsed = false;
                    }
                }
            }
        }
        return mdrRegionWrite;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-20s | %20s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "----", "-----"));
        return header.toString();
    }

    public String toFormatedString() {
        String format = " %-20s | %20s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Data Region", this.isDataRegion ? this.getDataRegion() : "N/A"));
        fStr.append(String.format(format, "Valid Data", this.isValidData ? this.getValidData() : "N/A"));
        fStr.append(String.format(format, "Lock Status", this.isLockStatus ? this.getLockStatus() : "N/A"));
        fStr.append(String.format(format, "Max Region Length", this.isMaxRegionLength ? Integer.valueOf(ByteUtility.twoBytesToInt(this.getMaxRegionLength())) : "N/A"));
        fStr.append(String.format(format, "Size Region Used", this.isSizeRegionUsed ? Integer.valueOf(ByteUtility.twoBytesToInt(this.getSizeRegionUsed())) : "N/A"));
        return fStr.toString();
    }

    public static void main(String[] args) {
        byte length = 10;
        byte[] offset = new byte[2];
        byte[] written = "Supermicro".getBytes();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("2.2.2.2");
        config.setUserName(StunnelUtility.testADMIN());
        config.setPassword(StunnelUtility.testADMIN());
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        MDRRegionStatusCommand mdrStatus = new MDRRegionStatusCommand(rmcp);
        mdrStatus = mdrStatus.getMDRRegionStatus();
        MOut.G().println("\n ========== MDR Region Status ==========");
        MOut.G().print(mdrStatus.toFormatedHeader());
        MOut.G().print(mdrStatus.toFormatedString());
        MOut.G().println();
        MDRRegionLockCommand mdrRegionLock = new MDRRegionLockCommand(rmcp);
        mdrRegionLock = mdrRegionLock.getMDRRegionLock();
        MOut.G().println(" ========== MDR Region Lock ==========");
        MOut.G().print(mdrRegionLock.toFormatedHeader());
        MOut.G().print(mdrRegionLock.toFormatedString());
        MOut.G().println();
        MDRRegionWriteCommand mdrRegionWrite = new MDRRegionWriteCommand(rmcp);
        mdrRegionWrite = mdrRegionWrite.setMDRRegionWrite(mdrRegionLock.getSessionLock(), length, offset, written);
        MOut.G().println(" ========== MDR Region Write ==========");
        MOut.G().print(mdrRegionWrite.toFormatedHeader());
        MOut.G().print(mdrRegionWrite.toFormatedString());
        MOut.G().println();
        MDRRegionReadCommand mdrRegionRead = new MDRRegionReadCommand(rmcp);
        mdrRegionRead = mdrRegionRead.getMDRRegionRead(length, offset);
        MOut.G().println(" ========== MDR Region Read ==========");
        MOut.G().print(mdrRegionRead.toFormatedHeader());
        MOut.G().print(mdrRegionRead.toFormatedString());
        MOut.G().println();
        MDRRegionUpdateCommand mdrRegionUpdate = new MDRRegionUpdateCommand(rmcp);
        mdrRegionUpdate = mdrRegionUpdate.setMDRRegionUpdate(mdrRegionLock.getSessionLock());
        MOut.G().println(" ========== MDR Region Update ==========");
        MOut.G().print(mdrRegionUpdate.toFormatedHeader());
        MOut.G().print(mdrRegionUpdate.toFormatedString());
        MOut.G().println();
        mdrRegionRead = mdrRegionRead.getMDRRegionRead(length, offset);
        MOut.G().println("========== MDR Region Read ==========");
        MOut.G().print(mdrRegionRead.toFormatedHeader());
        MOut.G().print(mdrRegionRead.toFormatedString());
    }
}

