/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.ptr.IntByReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;

public class NativeKcsAPI {
    public static final int REQUEST_DATA_SIZE = 256;
    public static final int RESPONSE_DATA_SIZE = 1024;

    public static boolean loadIPMIDriver() throws Exception {
        if (Platform.isLinux()) {
            return NativeKcsAPI.loadLinuxIpmiDriver();
        }
        return true;
    }

    public static boolean isLinuxIpmiDriverLoaded() {
        boolean result = false;
        if (new File("/dev/ipmi0").exists() || new File("/dev/ipmi/0").exists() || new File("/dev/ipmidev/0").exists()) {
            result = true;
        }
        return result;
    }

    public static boolean loadLinuxIpmiDriver() throws Exception {
        if (NativeKcsAPI.isLinuxIpmiDriverLoaded()) {
            return true;
        }
        boolean result = false;
        NativeKcsAPI.cmd1();
        NativeKcsAPI.cmd2();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (NativeKcsAPI.isLinuxIpmiDriverLoaded()) {
            result = true;
        }
        return result;
    }

    public static void test() {
        try {
            Process pl = Runtime.getRuntime().exec("/bin/sh -c \"modprobe ipmi_si | modprobe ipmi_devintf\"");
            String line = "";
            BufferedReader p_in = new BufferedReader(new InputStreamReader(pl.getInputStream()));
            while ((line = p_in.readLine()) != null) {
                System.out.println(line);
            }
            p_in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void cmd1() {
        try {
            String line;
            Object[] cmd1 = new String[]{"/bin/sh", "-c", "modprobe ipmi_si"};
            Process process = new ProcessBuilder((String[])cmd1).start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            System.out.printf("Output of running %s is:", Arrays.toString(cmd1));
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            br.close();
            isr.close();
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void cmd2() {
        try {
            String line;
            Object[] cmd2 = new String[]{"/bin/sh", "-c", "modprobe ipmi_devintf"};
            Process process = new ProcessBuilder((String[])cmd2).start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            System.out.printf("Output of running %s is:", Arrays.toString(cmd2));
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            br.close();
            isr.close();
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        byte[] requestData = new byte[]{1, 3, 0, 0};
        byte[] result = new byte[1024];
        byte[] errMessage = new byte[1024];
        IntByReference len = new IntByReference();
        Wraper.INSTANCE.initIPMIInterface();
        int rc = Wraper.INSTANCE.executeCommand(12, 2, requestData.length, requestData, len, result, errMessage);
        String ip = "";
        ip = (result[1] & 0xFF) + "." + (result[2] & 0xFF) + "." + (result[3] & 0xFF) + "." + (result[4] & 0xFF);
        rc = Wraper.INSTANCE.executeCommand(6, 55, 0, new byte[0], len, result, errMessage);
        String guid = "";
        guid = (result[1] & 0xFF) + " " + (result[2] & 0xFF) + " " + (result[3] & 0xFF) + " " + (result[4] & 0xFF) + " " + (result[5] & 0xFF) + " " + (result[6] & 0xFF) + " " + (result[7] & 0xFF) + " " + (result[8] & 0xFF) + " " + (result[9] & 0xFF) + " " + (result[10] & 0xFF) + " " + (result[11] & 0xFF) + " " + (result[12] & 0xFF) + " " + (result[13] & 0xFF) + " " + (result[14] & 0xFF) + " " + (result[15] & 0xFF);
        System.out.println("IP = " + ip);
        System.out.println("GUID = " + guid);
    }

    public static interface Wraper
    extends Library {
        public static final Wraper INSTANCE = Native.loadLibrary(Platform.isWindows() ? (Platform.is64Bit() ? "KCSLib64" : "KCSLib") : (Platform.is64Bit() ? "ssmkcs_64" : "ssmkcs_32"), Wraper.class);

        public int initIPMIInterface();

        public int executeCommand(int var1, int var2, int var3, byte[] var4, IntByReference var5, byte[] var6, byte[] var7);
    }
}

