/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.FlashThread;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIRaritanOEMCommand;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class SimIPMIBatchFlasher {
    public static void main_seq(String[] args) {
        ArrayList<String> devices = new ArrayList<String>();
        ArrayList<String> result = new ArrayList<String>();
        boolean errorState = false;
        if (args.length != 4) {
            System.out.println("SIM IPMI Batch flash tool (Build:070328) 2007 SuperMicro Computer Inc.");
            System.out.println("Usage:");
            System.out.println("SimIPMIBatchFlasher FILENAME USERNAME PASSWORD FIRMWARE");
            System.out.println("  FILENAME: A devices list File");
            System.out.println("  USERNAME: username");
            System.out.println("  PASSWORD: password");
            System.out.println("  FIRMWARE: A SIM IPMI firmware (*.bin)");
            System.exit(1);
        }
        String devicesFilename = args[0];
        String id = args[1];
        String password = args[2];
        String firmware = args[3];
        BufferedReader bufferedReader = null;
        String line = null;
        MessageCenter.getInstance().deleteObservers();
        System.out.println("SIM IPMI Batch flash tool v1.0(Build:070328) 2007 SuperMicro Computer Inc.");
        try {
            FileInputStream fileInputStream = new FileInputStream(devicesFilename);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                devices.add(line);
                System.out.println("=== Flash frimware to " + line);
                IPMIInterfaceConfig config = new IPMIInterfaceConfig();
                config.setIp(line);
                config.setUserName(id);
                config.setPassword(password);
                config.setPrivilege((byte)4);
                IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
                SessionControllerFactory.createSessionController(config, ipmiRaritanOEMCommand);
                try {
                    ipmiRaritanOEMCommand.flashFirmware(firmware);
                    result.add("Done");
                }
                catch (Exception ex2) {
                    result.add("Failed");
                    System.out.println("Flash failed. " + ex2.getMessage());
                }
            }
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
        }
        catch (FileNotFoundException ex) {
            System.out.println("Read file error!");
            errorState = true;
        }
        catch (IOException ex1) {
            System.out.println("IO error!");
            errorState = true;
        }
        if (null != bufferedReader) {
            try {
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (errorState) {
            System.exit(1);
        }
        System.out.println("=== Result:");
        for (int i = 0; i < devices.size(); ++i) {
            System.out.println(devices.get(i) + " ....... " + result.get(i));
        }
    }

    public static void main(String[] args) {
        BufferedReader bufferedReader = null;
        String line = null;
        boolean errorState = false;
        if (args.length != 4) {
            System.out.println("SIM IPMI Batch flash tool (Build:070411 Thread Version) 2007 SuperMicro Computer Inc.");
            System.out.println("Usage:");
            System.out.println("SimIPMIBatchFlasher FILENAME USERNAME PASSWORD FIRMWARE");
            System.out.println("  FILENAME: A devices list File");
            System.out.println("  USERNAME: username");
            System.out.println("  PASSWORD: password");
            System.out.println("  FIRMWARE: A SIM IPMI firmware (*.bin)");
            System.exit(1);
        }
        String devicesFilename = args[0];
        String id = args[1];
        String password = args[2];
        String firmware = args[3];
        MessageCenter.getInstance().deleteObservers();
        System.out.println("SIM IPMI Batch flash tool v1.0(Build:070328) 2007 SuperMicro Computer Inc.");
        System.out.println("Read devices list ...");
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(devicesFilename)));
            while ((line = bufferedReader.readLine()) != null) {
                FlashThread flashThread = new FlashThread(line, id, password, firmware);
                flashThread.start();
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("Read file error!");
            errorState = true;
        }
        catch (IOException ex1) {
            System.out.println("IO error!");
            errorState = true;
        }
        if (null != bufferedReader) {
            try {
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (errorState) {
            System.exit(1);
        }
    }
}

