/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import java.util.Observable;

public class PowerSupplyEntity
extends Observable {
    private byte present;
    private byte temperature;
    private byte fan1Speed;
    private byte fan2Speed;
    private byte status;
    private byte temperatureHighLimit;
    private byte fan1SpeedLowLimit;
    private byte fan2SpeedLowLimit;
    private byte fan3Speed;
    private byte fan4Speed;
    private byte fan3SpeedLowLimit;
    private byte fan4SpeedLowLimit;
    private byte acRMSCurrent;
    private byte dcOuputCurrent;
    private byte firmwareVersion;
    private byte fruVersion;
    private byte acCurrentLimit;
    private byte dcCurrentLimit;
    private byte powerSupplyWattLSB;
    private byte powerSupplyWattMSB;
    private byte busNumber;
    private byte channel;
    private byte fanSpeed;
    private byte i2cError;
    private byte initialized;
    private byte pollCount;
    private byte psStatusCnt;
    private byte selReportError;
    private byte errors;
    private byte lastPwrOnState;
    private byte numOfFans;
    private byte pollFanCount;
    private byte i2cResetCount;
    private byte acInputVolt;
    private byte[] raw;
    private int moduleIndex;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\npresent =" + this.present);
        sb.append("\ntemperature =" + ByteUtility.byteToHex(this.temperature) + "h");
        sb.append("\nfan1Speed =" + this.fan1Speed + "( " + this.fanRPMFormula(this.fan1Speed) + " RPM)");
        sb.append("\nfan2Speed =" + this.fan2Speed + "( " + this.fanRPMFormula(this.fan2Speed) + " RPM)");
        sb.append("\nstatus =" + this.status);
        sb.append("\ntemperatureHighLimit =" + ByteUtility.byteToHex(this.temperatureHighLimit) + "h");
        sb.append("\nfan1SpeedLowLimit =" + this.fan1SpeedLowLimit + "( " + this.fanRPMFormula(this.fan1SpeedLowLimit) + " RPM)");
        sb.append("\nfan2SpeedLowLimit =" + this.fan2SpeedLowLimit + "( " + this.fanRPMFormula(this.fan2SpeedLowLimit) + " RPM)");
        sb.append("\nfan3Speed =" + this.fan3Speed + "( " + this.fanRPMFormula(this.fan3Speed) + " RPM)");
        sb.append("\nfan4Speed =" + this.fan4Speed + "( " + this.fanRPMFormula(this.fan4Speed) + " RPM)");
        sb.append("\nfan3SpeedLowLimit =" + this.fan3SpeedLowLimit + "( " + this.fanRPMFormula(this.fan3SpeedLowLimit) + " RPM)");
        sb.append("\nfan4SpeedLowLimit =" + this.fan4SpeedLowLimit + "( " + this.fanRPMFormula(this.fan4SpeedLowLimit) + " RPM)");
        sb.append("\nacRMSCurrent =" + this.acRMSCurrent + "( " + this.getAcRMSCurrentFormula() + " A)");
        sb.append("\ndcOuputCurrent =" + this.dcOuputCurrent + "( " + this.getDcOuputCurrentFormula() + " A)");
        sb.append("\nfirmwareVersion =" + ByteUtility.byteToHex(this.firmwareVersion) + "h");
        sb.append("\nfruVersion =" + ByteUtility.byteToHex(this.fruVersion) + "h");
        sb.append("\nacCurrentLimit =" + this.acCurrentLimit + "( " + this.acRMSCurrentFormula(this.acCurrentLimit) + " A)");
        sb.append("\ndcCurrentLimit =" + this.dcCurrentLimit + "( " + this.dcOuptutCurrentFormula(this.dcCurrentLimit) + " A)");
        sb.append("\npowerSupplyWattLSB =" + ByteUtility.byteToHex(this.powerSupplyWattLSB) + "h");
        sb.append("\npowerSupplyWattMSB =" + ByteUtility.byteToHex(this.powerSupplyWattMSB) + "h");
        sb.append("\nbusNumber =" + this.busNumber);
        sb.append("\nchannel =" + this.channel);
        sb.append("\nfanSpeed =" + this.fanSpeed);
        sb.append("\ni2cError =" + this.i2cError);
        sb.append("\ninitialized =" + this.initialized);
        sb.append("\npollCount =" + this.pollCount);
        sb.append("\npsStatusCnt =" + this.psStatusCnt);
        sb.append("\nselReportError =" + this.selReportError);
        sb.append("\nerrors =" + this.errors);
        sb.append("\nlastPwrOnState =" + this.lastPwrOnState);
        sb.append("\nnumOfFans =" + this.numOfFans);
        sb.append("\npollFanCount =" + this.pollFanCount);
        sb.append("\ni2cResetCount =" + this.i2cResetCount);
        sb.append("\nacInputVolt; =" + this.acInputVolt);
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        return sb.toString();
    }

    public boolean fromRaw(byte[] raw) {
        if (raw.length != BladeSystemEntity.POWER_SUPPLY_MODULE_DATA_SIZE) {
            return false;
        }
        try {
            this.present = raw[0];
            this.temperature = raw[1];
            this.fan1Speed = raw[2];
            this.fan2Speed = raw[3];
            this.status = raw[4];
            this.temperatureHighLimit = raw[5];
            this.fan1SpeedLowLimit = raw[6];
            this.fan2SpeedLowLimit = raw[7];
            this.fan3Speed = raw[8];
            this.fan4Speed = raw[9];
            this.fan3SpeedLowLimit = raw[10];
            this.fan4SpeedLowLimit = raw[11];
            this.acRMSCurrent = raw[12];
            this.dcOuputCurrent = raw[13];
            this.firmwareVersion = raw[14];
            this.fruVersion = raw[15];
            this.acCurrentLimit = raw[16];
            this.dcCurrentLimit = raw[17];
            this.powerSupplyWattLSB = raw[18];
            this.powerSupplyWattMSB = raw[19];
            this.busNumber = raw[20];
            this.channel = raw[21];
            this.fanSpeed = raw[22];
            this.i2cError = raw[23];
            this.initialized = raw[24];
            this.pollCount = raw[25];
            this.psStatusCnt = raw[26];
            this.selReportError = raw[27];
            this.errors = raw[28];
            this.lastPwrOnState = raw[29];
            this.numOfFans = raw[30];
            this.pollFanCount = raw[31];
            this.i2cResetCount = raw[32];
            this.acInputVolt = raw[33];
            this.raw = raw;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
        return true;
    }

    public double fanRPMFormula(byte fanPluseCount) {
        if (fanPluseCount == -1) {
            return 0.0;
        }
        double rpm = 3.8167938931297707 * (double)((0xFF & fanPluseCount) * 60 / 2);
        return rpm;
    }

    public double acRMSCurrentFormula(byte value) {
        if (value == -1) {
            return 0.0;
        }
        double result = value / 16;
        return result;
    }

    public double dcOuptutCurrentFormula(byte value) {
        if (value == -1) {
            return 0.0;
        }
        double result = value / 2;
        return result;
    }

    public double getWatt() {
        byte[] b = new byte[]{this.getPowerSupplyWattLSB(), this.getPowerSupplyWattMSB()};
        return ByteUtility.twoBytesToIntLSB(b);
    }

    public String d2s(double value) {
        int temp = (int)(value * 100.0);
        double d = (double)temp / 100.0;
        return "" + d;
    }

    public int d2i(double value) {
        int i = (int)value;
        return i;
    }

    public void setPresent(byte present) {
        this.present = present;
    }

    public void setTemperature(byte temperature) {
        this.temperature = temperature;
    }

    public void setFan1Speed(byte fan1Speed) {
        this.fan1Speed = fan1Speed;
    }

    public void setFan2Speed(byte fan2Speed) {
        this.fan2Speed = fan2Speed;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public void setTemperatureHighLimit(byte temperatureHighLimit) {
        this.temperatureHighLimit = temperatureHighLimit;
    }

    public void setFan1SpeedLowLimit(byte fan1SpeedLowLimit) {
        this.fan1SpeedLowLimit = fan1SpeedLowLimit;
    }

    public void setFan2SpeedLowLimit(byte fan2SpeedLowLimit) {
        this.fan2SpeedLowLimit = fan2SpeedLowLimit;
    }

    public void setFan3Speed(byte fan3Speed) {
        this.fan3Speed = fan3Speed;
    }

    public void setFan4Speed(byte fan4Speed) {
        this.fan4Speed = fan4Speed;
    }

    public void setFan3SpeedLowLimit(byte fan3SpeedLowLimit) {
        this.fan3SpeedLowLimit = fan3SpeedLowLimit;
    }

    public void setFan4SpeedLowLimit(byte fan4SpeedLowLimit) {
        this.fan4SpeedLowLimit = fan4SpeedLowLimit;
    }

    public void setAcRMSCurrent(byte acRMSCurrent) {
        this.acRMSCurrent = acRMSCurrent;
    }

    public void setDcOuputCurrent(byte dcOuputCurrent) {
        this.dcOuputCurrent = dcOuputCurrent;
    }

    public void setFirmwareVersion(byte firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public void setFruVersion(byte fruVersion) {
        this.fruVersion = fruVersion;
    }

    public void setAcCurrentLimit(byte acCurrentLimit) {
        this.acCurrentLimit = acCurrentLimit;
    }

    public void setDcCurrentLimit(byte dcCurrentLimit) {
        this.dcCurrentLimit = dcCurrentLimit;
    }

    public void setPowerSupplyWattLSB(byte powerSupplyWattLSB) {
        this.powerSupplyWattLSB = powerSupplyWattLSB;
    }

    public void setPowerSupplyWattMSB(byte powerSupplyWattMSB) {
        this.powerSupplyWattMSB = powerSupplyWattMSB;
    }

    public void setBusNumber(byte busNumber) {
        this.busNumber = busNumber;
    }

    public void setChannel(byte channel) {
        this.channel = channel;
    }

    public void setFanSpeed(byte fanSpeed) {
        this.fanSpeed = fanSpeed;
    }

    public void setI2cError(byte i2cError) {
        this.i2cError = i2cError;
    }

    public void setInitialized(byte initialized) {
        this.initialized = initialized;
    }

    public void setPollCount(byte pollCount) {
        this.pollCount = pollCount;
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
    }

    public void setPollFanCount(byte pollFanCount) {
        this.pollFanCount = pollFanCount;
    }

    public void setI2cResetCount(byte i2cResetCount) {
        this.i2cResetCount = i2cResetCount;
    }

    public void setAcInputVolt(byte acInputVolt) {
        this.acInputVolt = acInputVolt;
    }

    public void setModuleIndex(int moduleIndex) {
        this.moduleIndex = moduleIndex;
    }

    public void setErrors(byte errors) {
        this.errors = errors;
    }

    public void setLastPwrOnState(byte lastPwrOnState) {
        this.lastPwrOnState = lastPwrOnState;
    }

    public void setNumOfFans(byte numOfFans) {
        this.numOfFans = numOfFans;
    }

    public void setPsStatusCnt(byte psStatusCnt) {
        this.psStatusCnt = psStatusCnt;
    }

    public void setSelReportError(byte selReportError) {
        this.selReportError = selReportError;
    }

    public byte getPresent() {
        return this.present;
    }

    public byte getTemperature() {
        return this.temperature;
    }

    public byte getFan1Speed() {
        return this.fan1Speed;
    }

    public byte getFan2Speed() {
        return this.fan2Speed;
    }

    public byte getStatus() {
        return this.status;
    }

    public byte getTemperatureHighLimit() {
        return this.temperatureHighLimit;
    }

    public byte getFan1SpeedLowLimit() {
        return this.fan1SpeedLowLimit;
    }

    public byte getFan2SpeedLowLimit() {
        return this.fan2SpeedLowLimit;
    }

    public byte getFan3Speed() {
        return this.fan3Speed;
    }

    public byte getFan4Speed() {
        return this.fan4Speed;
    }

    public byte getFan3SpeedLowLimit() {
        return this.fan3SpeedLowLimit;
    }

    public byte getFan4SpeedLowLimit() {
        return this.fan4SpeedLowLimit;
    }

    public byte getAcRMSCurrent() {
        return this.acRMSCurrent;
    }

    public double getAcRMSCurrentFormula() {
        return (double)(this.acRMSCurrent & 0xFF) / 8.0;
    }

    public byte getDcOuputCurrent() {
        return this.dcOuputCurrent;
    }

    public int getDcOuputCurrentFormula() {
        if (this.getWatt() == 2000.0) {
            return (0xFF & this.dcOuputCurrent) / 2;
        }
        return 0xFF & this.dcOuputCurrent;
    }

    public byte getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public byte getFruVersion() {
        return this.fruVersion;
    }

    public byte getAcCurrentLimit() {
        return this.acCurrentLimit;
    }

    public double getAcCurrentLimitFormula() {
        return (double)(this.acCurrentLimit & 0xFF) / 8.0;
    }

    public byte getDcCurrentLimit() {
        return this.dcCurrentLimit;
    }

    public double getDcCurrentLimitFormula() {
        return this.dcCurrentLimit & 0xFF;
    }

    public byte getPowerSupplyWattLSB() {
        return this.powerSupplyWattLSB;
    }

    public byte getPowerSupplyWattMSB() {
        return this.powerSupplyWattMSB;
    }

    public byte getBusNumber() {
        return this.busNumber;
    }

    public byte getChannel() {
        return this.channel;
    }

    public byte getFanSpeed() {
        return this.fanSpeed;
    }

    public byte getI2cError() {
        return this.i2cError;
    }

    public byte getInitialized() {
        return this.initialized;
    }

    public byte getPollCount() {
        return this.pollCount;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public int getModuleIndex() {
        return this.moduleIndex;
    }

    public byte getErrors() {
        return this.errors;
    }

    public byte getLastPwrOnState() {
        return this.lastPwrOnState;
    }

    public byte getNumOfFans() {
        return this.numOfFans;
    }

    public byte getPsStatusCnt() {
        return this.psStatusCnt;
    }

    public byte getSelReportError() {
        return this.selReportError;
    }

    public byte getPollFanCount() {
        return this.pollFanCount;
    }

    public byte getI2cResetCount() {
        return this.i2cResetCount;
    }

    public double getAcInputVolt() {
        return (double)(this.acInputVolt & 0xFF) * 1.3662 + 4.1428;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-4s | %-5s | %5s | %5s | %5s | %5s | %-8s | %5s | %6s | %6s | %3s | %3s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "PS", "Power", "Fan 1", "Fan 2", "Fan 3", "Fan 4", "Temp.", "Watts", "DC", "AC", "F/W", "FRU"));
        header.append(String.format(formatTemplate, "--", "-----", "-----", "-----", "-----", "-----", "-----", "-----", "--", "--", "---", "---"));
        return header.toString();
    }

    public String toFormatedString() {
        if (this.getPresent() == 0) {
            return "";
        }
        String formatTemplate = " %-4s | %-5s | %5s | %5s | %5s | %5s | %-8s | %5s | %6s | %6s | %3s | %3s\n";
        String index = "PS " + this.moduleIndex;
        StringBuffer formatedString = new StringBuffer();
        String power = "";
        switch (this.getStatus()) {
            case 0: {
                power = "Off";
                break;
            }
            case 1: {
                power = "On";
                break;
            }
            case 2: {
                power = "Failure";
            }
        }
        String fan1 = "" + (int)this.fanRPMFormula(this.getFan1Speed());
        String fan2 = "" + (int)this.fanRPMFormula(this.getFan2Speed());
        String fan3 = "N/A";
        String fan4 = "N/A";
        if (this.getNumOfFans() >= 3) {
            fan3 = "" + (int)this.fanRPMFormula(this.getFan3Speed());
        }
        if (this.getNumOfFans() >= 4) {
            fan4 = "" + (int)this.fanRPMFormula(this.getFan4Speed());
        }
        String dc = null;
        dc = this.getAcCurrentLimit() != 0 ? this.d2StrA(this.getDcOuputCurrentFormula()) : "N/A";
        String ac = null;
        ac = this.getAcCurrentLimit() != 0 ? this.d2StrA(this.getAcRMSCurrentFormula()) : "N/A";
        String watts = "";
        watts = "" + (int)this.getWatt();
        String temp = this.showCandF(this.getTemperature());
        String v = ByteUtility.byteToHex(this.getFirmwareVersion());
        String fVersion = v.substring(0, 1) + "." + v.substring(1, 2);
        String fru = ByteUtility.byteToHex(this.getFruVersion());
        formatedString.append(String.format(formatTemplate, index, power, fan1, fan2, fan3, fan4, temp, watts, dc, ac, fVersion, fru));
        return formatedString.toString();
    }

    protected String showCandF(byte c) {
        if (c == -127) {
            return "N/A";
        }
        long f = Math.round(1.8 * (double)c + 32.0);
        return c + "C/" + (f < 100L ? " " : "") + f + "F";
    }

    public String d2StrA(double value) {
        int temp = (int)(value * 100.0);
        double d = (double)temp / 100.0;
        return "" + d + "A";
    }

    public static void main(String[] args) {
        System.out.println("243");
        System.out.println("243");
        System.out.println("243");
        System.out.println("true");
    }
}

