/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;

public class CommandForSetSubnetMask
extends Command {
    @Override
    public Result execute(Host host) {
        String subnetMask = null;
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        Result result = new Result(this, host);
        if (!(this.option instanceof String)) {
            result.booleanResult = false;
            result.description = "Parameter error";
            return result;
        }
        subnetMask = (String)this.option;
        if (!IPMILanCommand.isIPAddress(subnetMask)) {
            result.booleanResult = false;
            result.description = L.t("group.Subnet_Mask_format_error");
            return result;
        }
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_login_to") + host.getIp();
            return result;
        }
        ipmiLanCommand.setIPMIInterface(rmcp);
        boolean r1 = ipmiLanCommand.setSubnetMask(subnetMask);
        if (r1) {
            result.booleanResult = true;
            result.description = "Set Subnet Mask OK";
        } else {
            result.booleanResult = false;
            result.description = L.t("group.Set_Subnet_Mask_failed");
        }
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Set Subnet Mask";
    }
}

