/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.kvm.authentication;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.kvm.authentication.KVMInterfaceMode;
import com.supermicro.ipmi.kvm.authentication.KVMRedfishState;
import com.supermicro.ipmi.kvm.authentication.KVMState;
import com.supermicro.ipmi.kvm.authentication.KVMUser;
import com.supermicro.ipmi.kvm.authentication.TLSConnection;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.redfish.BasicAuthClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class KVMSessionConnection {
    private HttpURLConnection conn;
    private String bmcIP;
    private String username;
    private String password;
    private final String USER_AGENT = "Mozilla/5.0";
    private boolean checkBlowFish = false;
    private boolean isDebug = false;
    private boolean isLogToFile = false;
    private boolean isWarning = true;
    private String html5CMM = null;
    private String httpPort = "80";
    private String httpsPort = "443";
    private String warningMessage = "";
    byte[] guid = null;
    private KVMRedfishState kvmRedfishState = null;
    FileWriter debugFileWriter = null;
    BufferedWriter debugBufferedWriter = null;

    public KVMSessionConnection(String bmcIP, String username, String password, String httpPort, String httpsPort) {
        this(bmcIP, username, password, httpPort, httpsPort, null);
    }

    public KVMSessionConnection(String bmcIP, String username, String password, String httpPort, String httpsPort, byte[] guid) {
        this.bmcIP = bmcIP;
        this.username = username;
        this.password = password;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.guid = guid;
        try {
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
            TLSConnection.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            System.out.println("TLS connect fail.");
        }
    }

    public KVMSessionConnection(String bmcIP, String username, String password) {
        this(bmcIP, username, password, null);
    }

    public KVMSessionConnection(String bmcIP, String username, String password, byte[] guid) {
        this.bmcIP = bmcIP;
        this.username = username;
        this.password = password;
        this.guid = guid;
        ConfigAccessor ca = new ConfigAccessor(".", "ikvm.properties");
        if (ca.getProperty("http_port") == null) {
            ca.setProperty("http_port", "80");
            this.httpPort = "80";
        } else {
            this.httpPort = ca.getProperty("http_port");
        }
        if (ca.getProperty("https_port") == null) {
            ca.setProperty("https_port", "443");
            this.httpsPort = "443";
        } else {
            this.httpsPort = ca.getProperty("https_port");
        }
        try {
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
            TLSConnection.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            System.out.println("TLS connect fail.");
        }
    }

    public KVMSessionConnection(String bmcIP, String username, String password, boolean checkBlowFish) {
        this.bmcIP = bmcIP;
        this.username = username;
        this.password = password;
        this.checkBlowFish = checkBlowFish;
    }

    @Deprecated
    public boolean isJavaPlugIn(String bmcIP, String username, String password) {
        boolean isIPv6 = StunnelUtility.isIPv6(bmcIP);
        String root = "https://" + bmcIP;
        if (isIPv6) {
            root = "https://[" + bmcIP + "]";
        }
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(bmcIP.trim());
        config.setUserName(username.trim());
        config.setPassword(password.trim());
        try {
            String manager = "/redfish/v1/Managers/1";
            this.printDebugMessage("get: " + manager);
            BasicAuthClient bc = new BasicAuthClient(config);
            int managerResult = bc.send_https_get(root + manager);
            if (managerResult < 200 || managerResult > 210) {
                this.printDebugMessage(managerResult + "");
                System.out.println("Get Managers API fail");
                return true;
            }
            this.printDebugMessage("Send " + root + manager);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode oem = node.path("Oem");
            JsonNode supermicro = oem.path("Supermicro");
            JsonNode ikvm = supermicro.path("IKVM");
            JsonNode ikvmOdataId = ikvm.path("@odata.id");
            this.printDebugMessage(oem.toString());
            if (ikvmOdataId.textValue() == null) {
                return true;
            }
            bc = new BasicAuthClient(config);
            this.printDebugMessage("Send " + root + ikvmOdataId.textValue());
            int KVMResult = bc.send_https_get(root + ikvmOdataId.textValue());
            node = mapper.readTree(bc.getResponseString());
            if (KVMResult < 200 || KVMResult > 210) {
                this.printDebugMessage(KVMResult + "");
                JsonNode error = node.path("error");
                if (error != null) {
                    String warningMessage = "";
                    String warningMessageArgs = "";
                    JsonNode messageExtendedInfo = error.path("@Message.ExtendedInfo");
                    if (messageExtendedInfo != null) {
                        if (messageExtendedInfo.isArray()) {
                            for (JsonNode l : messageExtendedInfo) {
                                JsonNode messageArgs;
                                JsonNode message = l.path("Message");
                                if (message != null) {
                                    warningMessage = message.toString();
                                }
                                if ((messageArgs = l.path("MessageArgs")) == null) continue;
                                warningMessageArgs = messageArgs.toString();
                            }
                            this.warningMessage = warningMessage + " " + warningMessageArgs;
                        } else {
                            JsonNode message = messageExtendedInfo.path("Message");
                            if (message != null) {
                                this.warningMessage = warningMessage;
                                if (this.isWarning) {
                                    System.out.println(message.toString());
                                }
                            }
                        }
                    }
                }
                return true;
            }
            JsonNode odataType = node.path("@odata.type");
            if (odataType != null && !odataType.isNull()) {
                this.printDebugMessage(odataType.asText());
            }
            if (odataType != null && odataType.textValue() != null && odataType.textValue().indexOf("v1_0_1") > -1) {
                JsonNode currentInterface = node.path("Current interface");
                this.printDebugMessage(currentInterface.asText());
                if (currentInterface.textValue().indexOf("HTML 5") > -1) {
                    if (this.isWarning) {
                        System.out.println("KVM Current interface is HTML 5, switching to JAVA plug-in...");
                    }
                    String url = root + ikvmOdataId.textValue();
                    String body = "{\"Current interface\":\"JAVA plug-in\"}";
                    int result = 0;
                    try {
                        result = bc.send_https_patch(url, body);
                    }
                    catch (ClientProtocolException e) {
                        if (this.isWarning) {
                            System.out.println("This device does not support switching KVM interface via redfish.");
                        }
                        return false;
                    }
                    if (result >= 200 && result <= 210) {
                        return true;
                    }
                    if (this.isWarning) {
                        System.out.println("Switching to JAVA plug-in fail, please close HTML 5 KVM connection before running the command.");
                    }
                    return false;
                }
                return true;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public float convertVersion(String input) {
        String version = input.split("\\.")[1];
        version = version.replaceAll("\\D", "");
        int major = Integer.parseInt(version.substring(0, 1));
        int minor = Integer.parseInt(version.substring(1, 3));
        float result = (float)major + (float)((double)minor * 0.01);
        return result;
    }

    public void printFailMessage(int result, String responseString) {
        if (result == 404) {
            System.out.println("404...Failed to execute command.");
        }
        if (result < 200 || result > 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = null;
            try {
                node = mapper.readTree(responseString);
            }
            catch (JsonProcessingException e) {
                System.out.println("...Failed to execute command, completion code " + result);
                return;
            }
            this.printDebugMessage(result + "");
            JsonNode error = node.path("error");
            if (error != null) {
                String warningMessage = "";
                String warningMessageArgs = "";
                JsonNode messageExtendedInfo = error.path("@Message.ExtendedInfo");
                if (messageExtendedInfo != null) {
                    if (messageExtendedInfo.isArray()) {
                        for (JsonNode l : messageExtendedInfo) {
                            JsonNode messageArgs;
                            JsonNode message = l.path("Message");
                            if (message != null) {
                                warningMessage = message.asText();
                            }
                            if ((messageArgs = l.path("MessageArgs")) == null) continue;
                            warningMessageArgs = messageArgs.asText();
                        }
                        System.out.println(warningMessage);
                        this.warningMessage = warningMessage + " " + warningMessageArgs;
                    } else {
                        JsonNode message = messageExtendedInfo.path("Message");
                        if (message != null) {
                            this.warningMessage = warningMessage;
                            if (this.isWarning) {
                                System.out.println(message.toString());
                            }
                        }
                    }
                }
            }
        } else {
            System.out.println("...Failed to execute command, completion code " + result);
        }
    }

    public KVMUser getLoginUser() throws Exception {
        return this.getLoginUser(false);
    }

    public KVMUser getLoginUser(boolean isSaveJnlp) throws Exception {
        return this.getLoginUser(isSaveJnlp, null);
    }

    public KVMUser getLoginUser(String jnlpPath) throws Exception {
        return this.getLoginUser(false, jnlpPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KVMUser getLoginUser(boolean isSaveJnlp, String jnlpPath) throws Exception {
        boolean isIPv6 = StunnelUtility.isIPv6(this.bmcIP);
        String root = "https://" + this.bmcIP;
        if (isIPv6) {
            root = "https://[" + this.bmcIP + "]";
        }
        if (!"443".equalsIgnoreCase(this.httpsPort)) {
            root = root + ":" + this.httpsPort;
        }
        boolean isHttps = true;
        int retry = 0;
        do {
            isHttps = root.contains("https");
            String url = root + "/cgi/login.cgi";
            String jnlpHTM = root + "/cgi/url_redirect.cgi?url_name=ikvm&url_type=jwsk";
            jnlpHTM = jnlpPath != null ? root + jnlpPath : root + "/cgi/url_redirect.cgi?url_name=ikvm&url_type=jwsk";
            String postParams = "name=" + this.username + "&pwd=" + this.password;
            this.sendPost(url, postParams, isHttps);
            try {
                this.switchKVMInterfaceViaCGI(root, isHttps, KVMInterfaceMode.JavaPlugIn, this.guid);
            }
            catch (ConnectException ce) {
                if (this.isWarning) {
                    System.out.println(ce.getMessage());
                }
                KVMUser user = new KVMUser();
                user.setKVMSessionConnected(true);
                return user;
            }
            catch (Exception e) {
                this.printDebugMessage("Exception: " + e.getMessage());
            }
            String jnlp = "";
            try {
                Object writer;
                jnlp = this.GetPageContent(jnlpHTM, isHttps);
                this.printDebugMessage(jnlp);
                if (isSaveJnlp || this.isDebug) {
                    writer = new PrintWriter("launch" + this.bmcIP + ".jnlp", "UTF-8");
                    ((PrintWriter)writer).write(jnlp);
                    ((PrintWriter)writer).close();
                }
                writer = this.getLoginValue(jnlp);
                return writer;
            }
            catch (FileNotFoundException e) {
                System.out.println("The KVM interface should be JAVA plug-in for this operation");
            }
            finally {
                this.printDebugMessage("Log to file done");
                if (this.debugBufferedWriter != null) {
                    this.debugBufferedWriter.close();
                }
            }
            ++retry;
            root = "http://" + this.bmcIP;
            if (isIPv6) {
                root = "http://[" + this.bmcIP + "]";
            }
            if ("80".equalsIgnoreCase(this.httpPort)) continue;
            root = root + ":" + this.httpPort;
        } while (retry < 2);
        if (this.debugBufferedWriter != null) {
            this.debugBufferedWriter.close();
        }
        return null;
    }

    private void sendPost(String url, String postParams, boolean isHttps) throws Exception {
        String inputLine;
        this.printDebugMessage("sendPost " + url);
        if (postParams.contains("name") && postParams.contains("pwd")) {
            this.printDebugMessage("postParams: hide sensitve account.");
        } else {
            this.printDebugMessage("postParams: " + postParams);
        }
        URL obj = new URL(url);
        this.conn = isHttps ? (HttpsURLConnection)obj.openConnection() : (HttpURLConnection)obj.openConnection();
        if (this.conn == null) {
            throw new Exception("unable to open connection");
        }
        this.conn.setConnectTimeout(30000);
        this.conn.setReadTimeout(60000);
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        this.conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        this.conn.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        this.conn.setRequestProperty("Connection", "keep-alive");
        this.conn.setRequestProperty("Referer", url);
        this.conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.conn.setRequestProperty("Content-Length", Integer.toString(postParams.length()));
        this.conn.setDoOutput(true);
        this.conn.setDoInput(true);
        DataOutputStream wr = new DataOutputStream(this.conn.getOutputStream());
        wr.writeBytes(postParams);
        wr.flush();
        wr.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        if (this.conn != null) {
            this.printDebugMessage("close connection");
            this.conn.disconnect();
        }
    }

    private String sendPost(String url, String postParams, boolean isHttps, String CSRF) throws Exception {
        String inputLine;
        this.printDebugMessage("sendPost " + url);
        this.printDebugMessage("postParams " + postParams);
        URL obj = new URL(url);
        this.conn = isHttps ? (HttpsURLConnection)obj.openConnection() : (HttpURLConnection)obj.openConnection();
        if (this.conn == null) {
            throw new Exception("unable to open connection");
        }
        this.conn.setConnectTimeout(30000);
        this.conn.setReadTimeout(60000);
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        this.conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        this.conn.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        this.conn.setRequestProperty("Connection", "keep-alive");
        this.conn.setRequestProperty("Referer", url);
        this.conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.conn.setRequestProperty("Content-Length", Integer.toString(postParams.length()));
        this.conn.setRequestProperty("CSRF_TOKEN", CSRF);
        this.conn.setDoOutput(true);
        this.conn.setDoInput(true);
        DataOutputStream wr = new DataOutputStream(this.conn.getOutputStream());
        wr.writeBytes(postParams);
        wr.flush();
        wr.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        if (this.conn != null) {
            this.printDebugMessage("close connection");
            this.conn.disconnect();
        }
        return response.toString();
    }

    public boolean switchKVMInterface(int mode) {
        boolean isIPv6 = StunnelUtility.isIPv6(this.bmcIP);
        String root = "https://" + this.bmcIP;
        if (isIPv6) {
            root = "https://[" + this.bmcIP + "]";
        }
        if (!"443".equalsIgnoreCase(this.httpsPort)) {
            root = root + ":" + this.httpsPort;
        }
        boolean isHttps = true;
        String url = root + "/cgi/login.cgi";
        int retry = 0;
        do {
            isHttps = root.contains("https");
            url = root + "/cgi/login.cgi";
            try {
                int kvminterface = this.getKVMInterfaceViaCGI(root, isHttps);
                if (kvminterface == mode) {
                    return true;
                }
                String postParams = "name=" + this.username + "&pwd=" + this.password;
                this.sendPost(url, postParams, isHttps);
                this.printDebugMessage("sendPost done");
                try {
                    boolean isGetToken = this.switchKVMInterfaceViaCGI(root, isHttps, KVMInterfaceMode.getModeNameValue(mode), this.guid);
                    this.printDebugMessage("isGetToken " + isGetToken);
                    if (isGetToken) {
                        return true;
                    }
                }
                catch (ConnectException ce) {
                    if (this.isWarning) {
                        System.out.println(ce.getMessage());
                    }
                    return false;
                }
                catch (Exception e) {
                    this.printDebugMessage("Exception: " + e.getMessage());
                }
                root = "http://" + this.bmcIP;
                if (isIPv6) {
                    root = "http://[" + this.bmcIP + "]";
                }
                if ("80".equalsIgnoreCase(this.httpPort)) continue;
                root = root + ":" + this.httpPort;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } while (++retry < 2);
        return true;
    }

    KVMState getKVMState(String root, boolean isHttps, String token) {
        String ikvmStatus;
        String kvmInterface;
        block13: {
            int endIndex;
            String ikvmStatusURL;
            kvmInterface = "";
            ikvmStatus = "";
            String postParams = "";
            try {
                int startIndex;
                ikvmStatusURL = root + "/cgi/xml_dispatcher.cgi";
                postParams = "op=GET_IKVM_STATUS.XML&r=(0,0)";
                this.printDebugMessage("ikvmStatusURL: " + ikvmStatusURL);
                this.printDebugMessage("postParams: " + postParams);
                ikvmStatus = this.sendPost(ikvmStatusURL, postParams, isHttps, token);
                this.printDebugMessage("post result: " + ikvmStatus + "\n");
                if (ikvmStatus.indexOf("WEBIKVMSTATUS") > -1) {
                    ikvmStatus = ikvmStatus.substring(ikvmStatus.indexOf("WEBIKVMSTATUS"));
                    startIndex = ikvmStatus.indexOf("\"") + 1;
                    endIndex = ikvmStatus.indexOf("\"", ikvmStatus.indexOf("\"") + 1);
                    ikvmStatus = ikvmStatus.substring(startIndex, endIndex);
                    this.printDebugMessage("ikvmStatus: " + ikvmStatus + "\n");
                }
                postParams = "op=GET_IKVM_INTERFACE.XML&r=(0,0)";
                this.printDebugMessage("ikvmStatusURL: " + ikvmStatusURL);
                this.printDebugMessage("postParams: " + postParams);
                kvmInterface = this.sendPost(ikvmStatusURL, postParams, isHttps, token);
                this.printDebugMessage("post result:  " + kvmInterface + "\n");
                if (kvmInterface.indexOf("ikvm_interface") > -1) {
                    kvmInterface = kvmInterface.substring(kvmInterface.indexOf("ikvm_interface"));
                    startIndex = kvmInterface.indexOf("\"") + 1;
                    endIndex = kvmInterface.indexOf("\"", kvmInterface.indexOf("\"") + 1);
                    kvmInterface = kvmInterface.substring(startIndex, endIndex);
                    this.printDebugMessage("kvmInterface: " + kvmInterface + "\n");
                }
            }
            catch (Exception e) {
                try {
                    int endIndex2;
                    int startIndex;
                    String ikvmStatusURL2 = root + "/cgi/ipmi.cgi";
                    postParams = "op=GET_IKVM_STATUS.XML&r=(0,0)";
                    this.printDebugMessage("ikvmStatusURL: " + ikvmStatusURL2);
                    this.printDebugMessage("postParams: " + postParams);
                    ikvmStatus = this.sendPost(ikvmStatusURL2, postParams, isHttps, token);
                    this.printDebugMessage("post result:  " + ikvmStatus);
                    if (ikvmStatus.indexOf("WEBIKVMSTATUS") > -1) {
                        ikvmStatus = ikvmStatus.substring(ikvmStatus.indexOf("WEBIKVMSTATUS"));
                        startIndex = ikvmStatus.indexOf("\"") + 1;
                        endIndex2 = ikvmStatus.indexOf("\"", ikvmStatus.indexOf("\"") + 1);
                        ikvmStatus = ikvmStatus.substring(startIndex, endIndex2);
                        this.printDebugMessage("ikvmStatus: " + ikvmStatus + "\n");
                    }
                    postParams = "op=GET_IKVM_INTERFACE.XML&r=(0,0)";
                    this.printDebugMessage("ikvmStatusURL: " + ikvmStatusURL2);
                    this.printDebugMessage("postParams: " + postParams);
                    kvmInterface = this.sendPost(ikvmStatusURL2, postParams, isHttps, token);
                    this.printDebugMessage("post result:  " + kvmInterface);
                    if (kvmInterface.indexOf("ikvm_interface") > -1) {
                        kvmInterface = kvmInterface.substring(kvmInterface.indexOf("ikvm_interface"));
                        startIndex = kvmInterface.indexOf("\"") + 1;
                        endIndex2 = kvmInterface.indexOf("\"", kvmInterface.indexOf("\"") + 1);
                        kvmInterface = kvmInterface.substring(startIndex, endIndex2);
                        this.printDebugMessage("kvmInterface: " + kvmInterface + "\n");
                    }
                }
                catch (Exception ikvmStatusURL2) {
                    // empty catch block
                }
            }
            if (!"".equals(kvmInterface) && !StringUtils.isNumeric(kvmInterface)) {
                try {
                    ikvmStatusURL = root + "/cgi/ipmi.cgi";
                    postParams = "GET_IKVM_STATUS.XML=(0,0)";
                    this.printDebugMessage("ikvmStatusURL: " + ikvmStatusURL);
                    this.printDebugMessage("postParams: " + postParams);
                    ikvmStatus = this.sendPost(ikvmStatusURL, postParams, isHttps, token);
                    this.printDebugMessage("post result:  " + ikvmStatus);
                    kvmInterface = ikvmStatus;
                    if (ikvmStatus.indexOf("WEBIKVMSTATUS") > -1) {
                        ikvmStatus = ikvmStatus.substring(ikvmStatus.indexOf("WEBIKVMSTATUS"));
                        int startIndex = ikvmStatus.indexOf("\"") + 1;
                        endIndex = ikvmStatus.indexOf("\"", ikvmStatus.indexOf("\"") + 1);
                        ikvmStatus = ikvmStatus.substring(startIndex, endIndex);
                        this.printDebugMessage("ikvmStatus: " + ikvmStatus);
                    }
                    if (kvmInterface.indexOf("IKVMINTERFACE") > -1) {
                        kvmInterface = kvmInterface.substring(kvmInterface.indexOf("IKVMINTERFACE"));
                        int startIndex = kvmInterface.indexOf("\"") + 1;
                        endIndex = kvmInterface.indexOf("\"", kvmInterface.indexOf("\"") + 1);
                        kvmInterface = kvmInterface.substring(startIndex, endIndex);
                        this.printDebugMessage("kvmInterface: " + kvmInterface);
                    }
                }
                catch (Exception e1) {
                    if ("".equals(ikvmStatus) || StringUtils.isNumeric(ikvmStatus)) break block13;
                    return null;
                }
            }
        }
        this.printDebugMessage("Final ikvmStatus: " + ikvmStatus);
        this.printDebugMessage("Final kvmInterface: " + kvmInterface);
        return new KVMState(ikvmStatus, kvmInterface);
    }

    boolean switchKVMInterfaceViaCGI(String root, boolean isHttps, KVMInterfaceMode kvmInterfaceMode, byte[] guid) throws Exception {
        boolean isGetToken = false;
        String redirectURL = root + "/cgi/url_redirect.cgi?url_name=topmenu";
        String page = this.GetPageContent(redirectURL, isHttps);
        String token = "";
        this.printDebugMessage("switchKVMInterfaceViaCGI redirectURL: " + redirectURL);
        if (page.indexOf("SmcCsrfInsert") != -1 && (page = page.substring(page.indexOf("SmcCsrfInsert"))).indexOf("CSRF_TOKEN") != -1) {
            page = page.substring(page.indexOf("CSRF_TOKEN") + "CSRF_TOKEN".length() + 1);
            int startIndex = page.indexOf("\"") + 1;
            int endIndex = page.indexOf("\"", page.indexOf("\"") + 1);
            token = page.substring(startIndex, endIndex);
        }
        this.printDebugMessage("token " + token);
        if ("".equals(token.trim())) {
            throw new Exception("Can't get valid token");
        }
        isGetToken = true;
        KVMState kvmState = this.getKVMState(root, isHttps, token);
        if (kvmState == null) {
            return isGetToken;
        }
        String kvmInterface = kvmState.getIkvmInterface();
        String ikvmStatus = kvmState.getIkvmStatus();
        String postParams = "";
        if (guid == null || IPMIMessagingCommand.isBeforeX12(guid)) {
            if (!"".equals(kvmInterface) && StringUtils.isNumeric(kvmInterface)) {
                if (!(kvmInterfaceMode.getValue() + "").equals(kvmInterface)) {
                    if (StringUtils.isNumeric(ikvmStatus) && Integer.parseInt(ikvmStatus) > 0) {
                        throw new ConnectException("Once a remote console session is connected, switching between JAVA and HTML5 is not allowed.");
                    }
                    if (this.isWarning) {
                        System.out.println("KVM Current interface is " + (Object)((Object)KVMInterfaceMode.getModeNameValue((kvmInterfaceMode.getValue() + 1) % 2)) + ", switching to " + (Object)((Object)kvmInterfaceMode) + "...");
                    }
                    String postRemoteConsoleUrl = root + "/cgi/op.cgi";
                    postParams = "op=remote_console&ikvm_setting=" + kvmInterfaceMode.getValue();
                    this.printDebugMessage("postRemoteConsoleUrl: " + postRemoteConsoleUrl);
                    this.printDebugMessage("postParams: " + postParams);
                    String result = this.sendPost(postRemoteConsoleUrl, postParams, isHttps, token);
                    if (!"ok".equals(result.trim())) {
                        throw new ConnectException("Switching to " + (Object)((Object)kvmInterfaceMode) + " fail, please close KVM session before running the command.");
                    }
                    this.printDebugMessage("result: " + result);
                }
            } else if (!isGetToken) {
                throw new Exception("No need to switch the KVM interface, you can ignore this warning message if you run the command for X10 platforms.");
            }
        } else {
            KVMRedfishState kvmRedfishState = this.getKVMInterfaceViaRedfish(root);
            if (kvmRedfishState != null && kvmRedfishState.getOdataType() > 1.01f) {
                this.switchKVMInterfaceViaRedfish(root, isHttps, kvmInterfaceMode, ikvmStatus, kvmRedfishState);
            } else if (!"".equals(kvmInterface) && StringUtils.isNumeric(kvmInterface)) {
                if (!(kvmInterfaceMode.getValue() + "").equals(kvmInterface)) {
                    if (StringUtils.isNumeric(ikvmStatus) && Integer.parseInt(ikvmStatus) > 0) {
                        throw new ConnectException("Once a remote console session is connected, switching between JAVA and HTML5 is not allowed.");
                    }
                    if (this.isWarning) {
                        System.out.println("KVM Current interface is " + (Object)((Object)KVMInterfaceMode.getModeNameValue((kvmInterfaceMode.getValue() + 1) % 2)) + ", switching to " + (Object)((Object)kvmInterfaceMode) + "...");
                    }
                    String postRemoteConsoleUrl = root + "/cgi/op.cgi";
                    postParams = "op=remote_console&ikvm_setting=" + kvmInterfaceMode.getValue();
                    this.printDebugMessage("postRemoteConsoleUrl: " + postRemoteConsoleUrl);
                    this.printDebugMessage("postParams: " + postParams);
                    String result = this.sendPost(postRemoteConsoleUrl, postParams, isHttps, token);
                    if (!"ok".equals(result.trim())) {
                        throw new ConnectException("Switching to " + (Object)((Object)kvmInterfaceMode) + " fail, please close KVM session before running the command.");
                    }
                    this.printDebugMessage("result: " + result);
                }
            } else if (!isGetToken) {
                throw new Exception("No need to switch the KVM interface, you can ignore this warning message if you run the command for X10 platforms.");
            }
        }
        return isGetToken;
    }

    public int getKVMInterface() {
        boolean isIPv6 = StunnelUtility.isIPv6(this.bmcIP);
        String root = "https://" + this.bmcIP;
        if (isIPv6) {
            root = "https://[" + this.bmcIP + "]";
        }
        if (!"443".equalsIgnoreCase(this.httpsPort)) {
            root = root + ":" + this.httpsPort;
        }
        boolean isHttps = true;
        int retry = 0;
        do {
            isHttps = root.contains("https");
            try {
                try {
                    int kvminterface = this.getKVMInterfaceViaCGI(root, isHttps);
                    if (kvminterface == 0 || kvminterface == 1) {
                        return kvminterface;
                    }
                }
                catch (ConnectException ce) {
                    return -1;
                }
                catch (Exception ce) {
                    // empty catch block
                }
                root = "http://" + this.bmcIP;
                if (isIPv6) {
                    root = "http://[" + this.bmcIP + "]";
                }
                if ("80".equalsIgnoreCase(this.httpPort)) continue;
                root = root + ":" + this.httpPort;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } while (++retry < 2);
        return -1;
    }

    int getKVMInterfaceViaCGI(String root, boolean isHttps) throws Exception {
        int kvmInterfaceStatus = -1;
        String redirectURL = root + "/cgi/url_redirect.cgi?url_name=topmenu";
        String url = root + "/cgi/login.cgi";
        if (this.guid == null || IPMIMessagingCommand.isBeforeX12(this.guid)) {
            this.printDebugMessage("guid == null || IPMIMessagingCommand.isBeforeX12(guid)");
            String postParams = "name=" + this.username + "&pwd=" + this.password;
            this.sendPost(url, postParams, isHttps);
            this.printDebugMessage("sendPost done");
            String page = this.GetPageContent(redirectURL, isHttps);
            String token = "";
            if (page.indexOf("SmcCsrfInsert") != -1 && (page = page.substring(page.indexOf("SmcCsrfInsert"))).indexOf("CSRF_TOKEN") != -1) {
                page = page.substring(page.indexOf("CSRF_TOKEN") + "CSRF_TOKEN".length() + 1);
                int startIndex = page.indexOf("\"") + 1;
                int endIndex = page.indexOf("\"", page.indexOf("\"") + 1);
                token = page.substring(startIndex, endIndex);
            }
            this.printDebugMessage("token " + token);
            if ("".equals(token.trim())) {
                throw new Exception("Can't get valid token");
            }
            kvmInterfaceStatus = 99;
            KVMState kvmState = this.getKVMState(root, isHttps, token);
            if (kvmState == null) {
                throw new Exception("Can't get kvm state");
            }
            String kvmInterface = kvmState.getIkvmInterface();
            String ikvmStatus = kvmState.getIkvmStatus();
            this.printDebugMessage("ikvmStatus " + ikvmStatus);
            this.printDebugMessage("kvmInterface " + kvmInterface);
            if (!"".equals(kvmInterface) && StringUtils.isNumeric(kvmInterface)) {
                kvmInterfaceStatus = Integer.parseInt(kvmInterface);
            }
        } else {
            this.printDebugMessage("getKVMInterfaceViaCGI ");
            KVMRedfishState kvmRedfishState = this.getKVMInterfaceViaRedfish(root);
            if (kvmRedfishState != null && kvmRedfishState.getOdataType() > 1.01f) {
                this.printDebugMessage("@odata.type >= 1.02 ");
                return kvmRedfishState.getCurrentInterface();
            }
            String postParams = "name=" + this.username + "&pwd=" + this.password;
            this.sendPost(url, postParams, isHttps);
            this.printDebugMessage("sendPost done");
            String page = this.GetPageContent(redirectURL, isHttps);
            String token = "";
            if (page.indexOf("SmcCsrfInsert") != -1 && (page = page.substring(page.indexOf("SmcCsrfInsert"))).indexOf("CSRF_TOKEN") != -1) {
                page = page.substring(page.indexOf("CSRF_TOKEN") + "CSRF_TOKEN".length() + 1);
                int startIndex = page.indexOf("\"") + 1;
                int endIndex = page.indexOf("\"", page.indexOf("\"") + 1);
                token = page.substring(startIndex, endIndex);
            }
            this.printDebugMessage("token " + token);
            if ("".equals(token.trim())) {
                throw new Exception("Can't get valid token");
            }
            kvmInterfaceStatus = 99;
            KVMState kvmState = this.getKVMState(root, isHttps, token);
            if (kvmState == null) {
                throw new Exception("Can't get kvm state");
            }
            String kvmInterface = kvmState.getIkvmInterface();
            String ikvmStatus = kvmState.getIkvmStatus();
            this.printDebugMessage("ikvmStatus " + ikvmStatus);
            this.printDebugMessage("kvmInterface " + kvmInterface);
            if (!"".equals(kvmInterface) && StringUtils.isNumeric(kvmInterface)) {
                kvmInterfaceStatus = Integer.parseInt(kvmInterface);
            }
        }
        return kvmInterfaceStatus;
    }

    public KVMRedfishState getKVMInterfaceViaRedfish(String root) throws Exception {
        String url = root + "/redfish/v1/Managers/1/";
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.bmcIP.trim());
        config.setUserName(this.username.trim());
        config.setPassword(this.password.trim());
        BasicAuthClient bc = new BasicAuthClient(config);
        int result = bc.send_https_get(url);
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode oem = node.path("Oem");
            JsonNode supermicro = oem.path("Supermicro");
            JsonNode ikvm = supermicro.path("IKVM");
            JsonNode ikvmOdataId = ikvm.path("@odata.id");
            String ikvmOdataIdValue = ikvmOdataId.textValue();
            int KVMResult = bc.send_https_get(root + ikvmOdataIdValue);
            if (KVMResult >= 200 && KVMResult <= 210) {
                JsonNode currentInterface;
                node = mapper.readTree(bc.getResponseString());
                JsonNode odataType = node.path("@odata.type");
                if (odataType != null && !odataType.isNull()) {
                    this.printDebugMessage("odataType.textValue() " + odataType.textValue());
                }
                if ((currentInterface = node.path("Current interface")) != null && !currentInterface.isNull()) {
                    this.printDebugMessage("currentInterface: " + currentInterface.textValue());
                }
                if (currentInterface.textValue().indexOf("HTML 5") > -1) {
                    String kvmURI = node.path("URI").textValue();
                    this.kvmRedfishState = new KVMRedfishState(ikvmOdataIdValue, this.convertVersion(odataType.textValue()), 1, kvmURI);
                    return this.kvmRedfishState;
                }
                if (currentInterface.textValue().indexOf("JAVA plug-in") > -1) {
                    return new KVMRedfishState(ikvmOdataIdValue, this.convertVersion(odataType.textValue()), 0);
                }
                return null;
            }
            this.printFailMessage(KVMResult, bc.getResponseString());
        } else {
            this.printFailMessage(result, bc.getResponseString());
        }
        return null;
    }

    public boolean switchKVMInterfaceViaRedfish(String root, boolean isHttps, KVMInterfaceMode kvmInterfaceMode, String ikvmStatus, KVMRedfishState kvmRedishState) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.bmcIP.trim());
        config.setUserName(this.username.trim());
        config.setPassword(this.password.trim());
        BasicAuthClient bc = new BasicAuthClient(config);
        int currentInterface = kvmRedishState.getCurrentInterface();
        int result = 0;
        String url = root + kvmRedishState.getKvmRedishPath();
        this.printDebugMessage("switchKVMInterfaceViaRedfish: " + url);
        this.printDebugMessage("currentInterface: " + currentInterface);
        if (currentInterface == 1 && kvmInterfaceMode.getValue() == 0) {
            if (StringUtils.isNumeric(ikvmStatus) && Integer.parseInt(ikvmStatus) > 0) {
                throw new ConnectException("Once a remote console session is connected, switching between JAVA and HTML5 is not allowed.");
            }
            System.out.println("KVM Current interface is HTML 5, switching to JAVA plug-in...");
            String body = "{\"Current interface\":\"JAVA plug-in\"}";
            try {
                result = bc.send_https_patch(url, body);
            }
            catch (ClientProtocolException e) {
                System.out.println("This device does not support switching KVM interface via redfish.");
                return false;
            }
            if (result >= 200 && result <= 210) {
                return true;
            }
            this.printFailMessage(result, bc.getResponseString());
            return false;
        }
        if (currentInterface == 0 && kvmInterfaceMode.getValue() == 1) {
            if (StringUtils.isNumeric(ikvmStatus) && Integer.parseInt(ikvmStatus) > 0) {
                throw new ConnectException("Once a remote console session is connected, switching between JAVA and HTML5 is not allowed.");
            }
            System.out.println("KVM Current interface is JAVA plug-in, switching to HTML 5...");
            String body = "{\"Current interface\":\"HTML 5\"}";
            result = 0;
            try {
                result = bc.send_https_patch(url, body);
            }
            catch (ClientProtocolException e) {
                System.out.println("This device does not support switching KVM interface via redfish.");
                return false;
            }
            if (result >= 200 && result <= 210) {
                return true;
            }
            this.printFailMessage(result, bc.getResponseString());
            return false;
        }
        return true;
    }

    private String GetPageContent(String url, boolean isHttps) throws Exception {
        String inputLine;
        URL obj = new URL(url);
        this.conn = isHttps ? (HttpsURLConnection)obj.openConnection() : (HttpURLConnection)obj.openConnection();
        if (this.conn == null) {
            throw new Exception("unable to open connection");
        }
        this.conn.setRequestMethod("GET");
        this.conn.setConnectTimeout(30000);
        this.conn.setReadTimeout(60000);
        this.conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        this.conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        this.conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.conn.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        this.conn.getRequestProperties();
        int responseCode = this.conn.getResponseCode();
        this.printDebugMessage("\nSending 'GET' request to URL : " + url);
        this.printDebugMessage("headers fields are :" + this.conn.getHeaderFields());
        this.printDebugMessage("Response Code : " + responseCode);
        BufferedReader in = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
            String newLine = System.getProperty("line.separator");
            if (newLine == null) {
                response.append("\n");
                continue;
            }
            response.append(newLine);
        }
        in.close();
        if (this.conn != null) {
            this.printDebugMessage("close connection");
            this.conn.disconnect();
        }
        return response.toString();
    }

    private KVMUser getLoginValue(String html) throws UnsupportedEncodingException {
        Document doc = Jsoup.parse(html);
        doc.outputSettings().prettyPrint(false);
        Elements sessionElement = doc.getElementsByTag("argument");
        int index = -1;
        KVMUser kvmUser = new KVMUser();
        int isaIP = -1;
        for (Element inputElement : sessionElement) {
            if (index >= 0) {
                ++index;
            }
            if ((isaIP = StunnelUtility.isaIP(inputElement.text().trim())) >= 0) {
                if (isaIP == 1) {
                    if (KVMSessionConnection.StandardIPv6Converter(inputElement.text().trim()).equalsIgnoreCase(KVMSessionConnection.StandardIPv6Converter(this.bmcIP))) {
                        index = 0;
                    }
                } else if (inputElement.text().trim().equals(this.bmcIP)) {
                    index = 0;
                }
            }
            if (index == 1) {
                kvmUser.setUsername(inputElement.text());
            } else if (index == 2) {
                kvmUser.setPassword(inputElement.text());
            } else if (index == 10 && this.checkBlowFish && "1".equals(inputElement.text())) {
                kvmUser.setBlowFish(true);
            }
            if (inputElement.text().indexOf("BEGIN CERTIFICATE") <= -1) continue;
            String certificate = inputElement.html();
            if (certificate.indexOf("-----END CERTIFICATE-----") > 0) {
                int endCertificate = certificate.indexOf("-----END CERTIFICATE-----") + "-----END CERTIFICATE-----".length();
                certificate = certificate.substring(0, endCertificate);
            }
            kvmUser.setServerCertificate(certificate);
        }
        if ("".equals(kvmUser.getUsername()) && "".equals(kvmUser.getPassword())) {
            HashMap<Integer, String> tempMap = new HashMap<Integer, String>();
            index = 0;
            for (Element inputElement : sessionElement) {
                String tempElement = inputElement.text();
                tempMap.put(index, tempElement);
                if ("5900".equals(tempElement) && ((String)tempMap.get(index - 7)).contains("=") & index - 8 > 0) {
                    kvmUser.setPassword((String)tempMap.get(index - 7));
                    kvmUser.setUsername((String)tempMap.get(index - 8));
                }
                ++index;
            }
        }
        return kvmUser;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void setLogToFile(boolean isLogToFile) {
        this.isLogToFile = isLogToFile;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public void setWarning(boolean isWarning) {
        this.isWarning = isWarning;
    }

    public KVMRedfishState getKvmRedfishState() {
        return this.kvmRedfishState;
    }

    public void setKvmRedfishState(KVMRedfishState kvmRedfishState) {
        this.kvmRedfishState = kvmRedfishState;
    }

    public static String getTmpDir() {
        String tempDIR = System.getProperty("java.io.tmpdir");
        if (!File.separator.equals(tempDIR.substring(tempDIR.length() - 1, tempDIR.length()))) {
            tempDIR = tempDIR + File.separator;
        }
        return tempDIR;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public static String StandardIPv6Converter(String address) {
        int i;
        int j;
        int tempCompressLocation = address.indexOf("::");
        int componentNumberPrePart = 0;
        if (tempCompressLocation != -1) {
            String prePart = address.substring(0, tempCompressLocation);
            componentNumberPrePart = prePart.split(":").length;
            address = address.replace("::", ":");
        }
        String[] addressComponents = address.toString().split(":");
        for (int i2 = 0; i2 < addressComponents.length; ++i2) {
            StringBuilder uncompressedComponent = new StringBuilder("");
            for (j = 0; j < 4 - addressComponents[i2].length(); ++j) {
                uncompressedComponent.append("0");
            }
            uncompressedComponent.append(addressComponents[i2]);
            addressComponents[i2] = uncompressedComponent.toString();
        }
        LinkedList<String> uncompressedAddressComponents = new LinkedList<String>();
        for (i = 0; i < addressComponents.length; ++i) {
            if (i == componentNumberPrePart) {
                for (j = 0; j < 8 - addressComponents.length; ++j) {
                    uncompressedAddressComponents.add("0000");
                }
            }
            uncompressedAddressComponents.add(addressComponents[i]);
        }
        if (uncompressedAddressComponents.size() < 8) {
            for (i = uncompressedAddressComponents.size(); i < 8; ++i) {
                uncompressedAddressComponents.add("0000");
            }
        }
        StringBuilder uncompressedAddress = new StringBuilder("");
        for (int i3 = 0; i3 < uncompressedAddressComponents.size(); ++i3) {
            uncompressedAddress.append((String)uncompressedAddressComponents.get(i3));
            uncompressedAddress.append(":");
        }
        uncompressedAddress.replace(uncompressedAddress.length() - 1, uncompressedAddress.length(), "");
        return uncompressedAddress.toString();
    }

    void printDebugMessage(String content) {
        if (this.isLogToFile) {
            if (this.debugFileWriter == null) {
                try {
                    this.debugFileWriter = new FileWriter(this.bmcIP + ".log", true);
                    this.debugBufferedWriter = new BufferedWriter(this.debugFileWriter);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                this.debugBufferedWriter.write(content);
                this.debugBufferedWriter.newLine();
                this.debugBufferedWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        KVMSessionConnection http = new KVMSessionConnection("2.2.2.2", StunnelUtility.testADMIN(), StunnelUtility.testADMIN(), "80", "443", null);
        http.setDebug(true);
        http.getLoginUser(true);
    }
}

