/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractSBEntity;
import com.supermicro.ipmi.microblade.Sensor;
import com.supermicro.ipmi.text.MOut;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class SB_B10DRE
extends AbstractSBEntity {
    public Sensor cpu1Temp = new Sensor();
    public Sensor cpu2Temp = new Sensor();
    public Sensor pchTemp = new Sensor();
    public Sensor cpu1vrmTemp = new Sensor();
    public Sensor cpu2vrmTemp = new Sensor();
    public Sensor dimmABvrmTemp = new Sensor();
    public Sensor dimmCDvrmTemp = new Sensor();
    public Sensor dimmEFvrmTemp = new Sensor();
    public Sensor dimmGHvrmTemp = new Sensor();
    public Sensor system1Temp = new Sensor();
    public Sensor system2Temp = new Sensor();
    public Sensor inletTemp = new Sensor();
    public Sensor AOC_IBHTTemp = new Sensor();
    public Sensor dimmA1Temp = new Sensor();
    public Sensor dimmA2Temp = new Sensor();
    public Sensor dimmB1Temp = new Sensor();
    public Sensor dimmB2Temp = new Sensor();
    public Sensor dimmC1Temp = new Sensor();
    public Sensor dimmC2Temp = new Sensor();
    public Sensor dimmD1Temp = new Sensor();
    public Sensor dimmD2Temp = new Sensor();
    public Sensor dimmE1Temp = new Sensor();
    public Sensor dimmE2Temp = new Sensor();
    public Sensor dimmF1Temp = new Sensor();
    public Sensor dimmF2Temp = new Sensor();
    public Sensor dimmG1Temp = new Sensor();
    public Sensor dimmG2Temp = new Sensor();
    public Sensor dimmH1Temp = new Sensor();
    public Sensor dimmH2Temp = new Sensor();
    public Sensor v12 = new Sensor();
    public Sensor v5SB = new Sensor();
    public Sensor v3P3 = new Sensor();
    public Sensor vBAT = new Sensor();
    public Sensor vCCP0 = new Sensor();
    public Sensor vDDQAB = new Sensor();
    public Sensor vCCP1 = new Sensor();
    public Sensor vDDQCD = new Sensor();
    public Sensor v5 = new Sensor();
    public Sensor v3P3SB = new Sensor();
    public Sensor vDDQEF = new Sensor();
    public Sensor vDDQGH = new Sensor();
    public Sensor p1V5_PCH = new Sensor();
    public Sensor p1V2_AUX_BMC = new Sensor();
    public Sensor p1V05_PCH = new Sensor();
    public Sensor AOC_OPHTemp = new Sensor();
    public Sensor watchdog = new Sensor();
    public Sensor pwr = new Sensor();
    public Sensor AOM_B_4MTemp = new Sensor();
    public Sensor AOC_B25GTemp = new Sensor();
    public Sensor nvme1_SSDTemp = new Sensor();
    public Sensor storageTemp = new Sensor();

    @Override
    public void fromRaw(byte[] raw) {
        Field[] fields;
        super.fromRaw(raw);
        int index = 0;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            try {
                ((Sensor)field.get(this)).fromRaw(ByteUtility.getBytes(raw, index, 12));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            index += 12;
        }
    }

    @Override
    public String toFormatedString() {
        StringBuffer formatedString = new StringBuffer();
        LinkedHashMap<Sensor, String[]> map = new LinkedHashMap<Sensor, String[]>();
        map.put(this.cpu1Temp, new String[]{"CPU1 Temp", "T"});
        map.put(this.cpu2Temp, new String[]{"CPU2 Temp", "T"});
        map.put(this.system1Temp, new String[]{"System Temp", "T"});
        map.put(this.system2Temp, new String[]{"Peripheral Temp", "T"});
        map.put(this.inletTemp, new String[]{"Inlet Temp", "T"});
        map.put(this.AOC_IBHTTemp, new String[]{"AOC-IBH Temp", "T"});
        map.put(this.AOC_OPHTemp, new String[]{"AOC-OPH Temp", "T"});
        map.put(this.AOM_B_4MTemp, new String[]{"AOM-B-4M Temp", "T"});
        map.put(this.AOC_B25GTemp, new String[]{"AOC-B25G Temp", "T"});
        map.put(this.pchTemp, new String[]{"PCH Temp", "T"});
        map.put(this.cpu1vrmTemp, new String[]{"CPU1VRM Temp", "T"});
        map.put(this.cpu2vrmTemp, new String[]{"CPU2VRM Temp", "T"});
        map.put(this.dimmABvrmTemp, new String[]{"VDIMMABVRM Temp", "T"});
        map.put(this.dimmCDvrmTemp, new String[]{"VDIMMCDVRM Temp", "T"});
        map.put(this.dimmEFvrmTemp, new String[]{"VDIMMEFVRM Temp", "T"});
        map.put(this.dimmGHvrmTemp, new String[]{"VDIMMGHVRM Temp", "T"});
        map.put(this.dimmA1Temp, new String[]{"P1-DIMMA1 Temp", "T"});
        map.put(this.dimmA2Temp, new String[]{"P1-DIMMA2 Temp", "T"});
        map.put(this.dimmB1Temp, new String[]{"P1-DIMMB1 Temp", "T"});
        map.put(this.dimmB2Temp, new String[]{"P1-DIMMB2 Temp", "T"});
        map.put(this.dimmC1Temp, new String[]{"P1-DIMMC1 Temp", "T"});
        map.put(this.dimmC2Temp, new String[]{"P1-DIMMC2 Temp", "T"});
        map.put(this.dimmD1Temp, new String[]{"P1-DIMMD1 Temp", "T"});
        map.put(this.dimmD2Temp, new String[]{"P1-DIMMD2 Temp", "T"});
        map.put(this.dimmE1Temp, new String[]{"P2-DIMME1 Temp", "T"});
        map.put(this.dimmE2Temp, new String[]{"P2-DIMME2 Temp", "T"});
        map.put(this.dimmF1Temp, new String[]{"P2-DIMMF1 Temp", "T"});
        map.put(this.dimmF2Temp, new String[]{"P2-DIMMF2 Temp", "T"});
        map.put(this.dimmG1Temp, new String[]{"P2-DIMMG1 Temp", "T"});
        map.put(this.dimmG2Temp, new String[]{"P2-DIMMG2 Temp", "T"});
        map.put(this.dimmH1Temp, new String[]{"P2-DIMMH1 Temp", "T"});
        map.put(this.dimmH2Temp, new String[]{"P2-DIMMH2 Temp", "T"});
        map.put(this.vCCP0, new String[]{"Vcpu1", "V"});
        map.put(this.vCCP1, new String[]{"Vcpu2", "V"});
        map.put(this.vDDQAB, new String[]{"VDIMMAB", "V"});
        map.put(this.vDDQCD, new String[]{"VDIMMCD", "V"});
        map.put(this.vDDQEF, new String[]{"VDIMMEF", "V"});
        map.put(this.vDDQGH, new String[]{"VDIMMGH", "V"});
        map.put(this.v12, new String[]{"12V", "V"});
        map.put(this.v5, new String[]{"5VCC", "V"});
        map.put(this.v3P3, new String[]{"3.3VCC", "V"});
        map.put(this.v5SB, new String[]{"5VSB", "V"});
        map.put(this.v3P3SB, new String[]{"3.3VSB", "V"});
        map.put(this.p1V2_AUX_BMC, new String[]{"1.2V BMC", "V"});
        map.put(this.p1V5_PCH, new String[]{"1.5V PCH", "V"});
        map.put(this.p1V05_PCH, new String[]{"1.05V PCH", "V"});
        map.put(this.vBAT, new String[]{"VBAT", "B"});
        map.put(this.watchdog, new String[]{"Watchdog", "W"});
        map.put(this.pwr, new String[]{"PW Consumption", "P"});
        map.put(this.nvme1_SSDTemp, new String[]{"NVMe1_SSD Temp", "T"});
        map.put(this.storageTemp, new String[]{"Storage Temp", "T"});
        for (Map.Entry entry : map.entrySet()) {
            try {
                Sensor sensor = (Sensor)entry.getKey();
                String name = ((String[])entry.getValue())[0];
                String type = ((String[])entry.getValue())[1];
                if (sensor.reading == 0) {
                    formatedString.append(String.format(this.formatTemplate, "N/A", name, "N/A", "N/A", "N/A"));
                    continue;
                }
                if ("T".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, sensor.getStatusString(true), name, sensor.getHumanReading(sensor.reading) + "\u00b0C", sensor.getHumanReadingWithSign(sensor.min) + "\u00b0C", sensor.getHumanReadingWithSign(sensor.max) + "\u00b0C"));
                    continue;
                }
                if ("V".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, sensor.getStatusString(false), name, sensor.getHumanReading(sensor.reading) + " V", sensor.getHumanReading(sensor.min) + " V", sensor.getHumanReading(sensor.max) + " V"));
                    continue;
                }
                if ("B".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, this.vBAT.getStatusString(false).contains("Lower") ? this.vBAT.getStatusString(false) : "Normal", "VBAT", this.vBAT.getHumanReading(this.vBAT.reading) + " V", this.vBAT.getHumanReading(this.vBAT.min) + " V", "N/A"));
                    continue;
                }
                if ("W".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, "Normal", "Watchdog", this.getWatchDogStatus(this.watchdog.reading), "N/A", "N/A"));
                    continue;
                }
                if ("P".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, "Normal", "PW Consumption", this.pwr.getHumanReading(this.pwr.reading) + " W", "N/A", "N/A"));
                    continue;
                }
                MOut.G().println("Sensor Type Not Found.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return formatedString.toString();
    }

    @Override
    public int getSensorDisplayNumber() {
        return 51;
    }
}

