/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade.kvm;

import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.kvm.authentication.KVMSessionConnection;
import com.supermicro.ipmi.kvm.authentication.KVMUser;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.MicroBladeInfoManager;
import com.supermicro.ipmi.microblade.NodeRemoteInfo;
import com.supermicro.ipmi.microblade.kvm.MicroBladeKVMMediator;
import com.supermicro.ipmi.stunnel.StunnelParameterBuilder;
import com.supermicro.ipmi.stunnel.StunnelParameters;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MicroBladeKVMButtons
extends JPanel
implements ActionListener,
MouseListener,
Observer {
    int nodeSize;
    int bladeIndex;
    JButton[] kvmButtons;
    JLabel bladeModelNamelabel;
    MicroBladeInfoManager infoManager;
    MicroBladeKVMMediator mediator;
    String bmcIP = "";
    String id = StunnelUtility.testADMIN();
    String password = StunnelUtility.testADMIN();
    ISessionController sessionController;

    public MicroBladeKVMButtons(MicroBladeKVMMediator mediator, String bladeLabel, int bladeIndex, int nodeSize, int width, int height, MicroBladeInfoManager infoManager) {
        int i;
        this.infoManager = infoManager;
        this.mediator = mediator;
        this.bladeIndex = bladeIndex;
        this.nodeSize = nodeSize;
        BladeRemoteInfo bladeRemoteInfo = infoManager.getBladeRemoteInfo(bladeIndex);
        if (bladeRemoteInfo.isPresent()) {
            nodeSize = bladeRemoteInfo.nodeCount;
        }
        this.setLayout(new GridLayout(0, 1, 0, 0));
        this.bladeModelNamelabel = new JLabel(bladeLabel);
        this.bladeModelNamelabel.setVerticalAlignment(1);
        this.bladeModelNamelabel.setHorizontalAlignment(0);
        this.bladeModelNamelabel.addMouseListener(this);
        this.add(this.bladeModelNamelabel);
        this.kvmButtons = new JButton[nodeSize];
        for (i = 0; i < nodeSize; ++i) {
            this.kvmButtons[i] = new JButton("" + (i + 1));
            this.kvmButtons[i].setMargin(new Insets(0, 0, 0, 0));
            this.kvmButtons[i].addActionListener(this);
            this.kvmButtons[i].addMouseListener(this);
            this.add(this.kvmButtons[i]);
        }
        for (i = nodeSize; i < 4; ++i) {
            this.add(new JLabel());
        }
        this.setButtonsEnabled(bladeRemoteInfo.nodeCount, bladeRemoteInfo.isPresent());
        this.setPreferredSize(new Dimension(width, height));
    }

    private int getKVMButtonIndex(JButton button) {
        for (int i = 0; i < this.nodeSize; ++i) {
            if (!this.kvmButtons[i].equals(button)) continue;
            return i;
        }
        return -1;
    }

    public JButton getKVMButton(int index) {
        return this.kvmButtons[index];
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.infoManager.getBladeRemoteInfo(this.bladeIndex).isPresent()) {
            return;
        }
        try {
            int nodeIndex = this.getKVMButtonIndex((JButton)e.getSource());
            NodeRemoteInfo nodeRemoteInfo = this.infoManager.getBladeRemoteInfo(this.bladeIndex).getNodeRemoteInfo(nodeIndex);
            String text = " " + this.bladeModelNamelabel.getText() + "-" + (nodeIndex + 1) + "-" + nodeRemoteInfo.getBMCPIP() + "-" + nodeRemoteInfo.getDecryptedUsername() + "-" + nodeRemoteInfo.getDecryptedPassword();
            this.bmcIP = nodeRemoteInfo.getBMCPIP();
            this.id = nodeRemoteInfo.getDecryptedUsername();
            this.password = nodeRemoteInfo.getDecryptedPassword();
            this.startKVMFnction();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.infoManager.getBladeRemoteInfo(this.bladeIndex).isPresent()) {
            return;
        }
        BladeRemoteInfo bladeRemoteInfo = this.infoManager.getBladeRemoteInfo(this.bladeIndex);
        if (e.getSource() instanceof JLabel) {
            String text = "";
            for (int i = 0; i < bladeRemoteInfo.nodeCount; ++i) {
                NodeRemoteInfo nodeRemoteInfo = bladeRemoteInfo.getNodeRemoteInfo(i);
                String t1 = " " + this.bladeModelNamelabel.getText() + "-" + (i + 1) + ":" + nodeRemoteInfo.getBMCPIP() + "    ";
                text = text + t1;
            }
            this.mediator.showSelectedInfo(text);
        } else if (e.getSource() instanceof JButton) {
            int nodeIndex = this.getKVMButtonIndex((JButton)e.getSource());
            if (nodeIndex >= bladeRemoteInfo.nodeCount) {
                return;
            }
            NodeRemoteInfo nodeRemoteInfo = bladeRemoteInfo.getNodeRemoteInfo(nodeIndex);
            String text = " " + this.bladeModelNamelabel.getText() + "-" + (nodeIndex + 1) + " IP:" + nodeRemoteInfo.getBMCPIP();
            this.mediator.showSelectedInfo(text);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.infoManager.getBladeRemoteInfo(this.bladeIndex).isPresent()) {
            return;
        }
        this.mediator.showSelectedInfo("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int nodeIndex = this.getKVMButtonIndex((JButton)e.getSource());
        NodeRemoteInfo nodeRemoteInfo = this.infoManager.getBladeRemoteInfo(this.bladeIndex).getNodeRemoteInfo(nodeIndex);
        String text = " " + this.bladeModelNamelabel.getText() + "-" + (nodeIndex + 1);
    }

    @Override
    public void update(Observable o, Object arg) {
        BladeRemoteInfo bladeRemoteInfo = this.infoManager.getBladeRemoteInfo(this.bladeIndex);
        this.setButtonsEnabled(bladeRemoteInfo.nodeCount, bladeRemoteInfo.isPresent());
    }

    private void setButtonsEnabled(int nodeSize, boolean isEnable) {
        if (isEnable) {
            for (int i = 0; i < this.kvmButtons.length; ++i) {
                if (i < nodeSize) {
                    this.kvmButtons[i].setEnabled(isEnable);
                    continue;
                }
                this.kvmButtons[i].setEnabled(!isEnable);
            }
        } else {
            for (int i = 0; i < this.kvmButtons.length; ++i) {
                this.kvmButtons[i].setEnabled(isEnable);
            }
        }
    }

    private void startKVMFnction() {
        int vmType = 0;
        int port = 5900;
        IPMIInterfaceConfig config = this.initIPMIInterfaceConfig();
        this.createSessionController(config);
        IPMIInterface rmcp = this.startSessionConnect(config);
        if (null == rmcp) {
            System.out.println("Session create fail, rmcp == null");
            return;
        }
        IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(null);
        ipmiOEMPortServiceCommand.setIPMIInterface(rmcp);
        try {
            port = ipmiOEMPortServiceCommand.getPort((byte)2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(config.getIp());
        int stunnelVer = 0;
        try {
            stunnelVer = ipmiOEMPortServiceCommand.getPort((byte)15);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConfigAccessor ca = new ConfigAccessor(".", "stunnel.properties");
        if (ca.getProperty("vm_security") == null) {
            ca.setProperty("vm_security", "off");
        }
        String isVMStunnel = ca.getProperty("vm_security");
        boolean isForceStunnelVer11 = false;
        if (isVMStunnel.equalsIgnoreCase("on")) {
            isForceStunnelVer11 = true;
        }
        if (stunnelVer > 0) {
            if (isForceStunnelVer11) {
                stunnelVer = 11;
            } else if (stunnelVer == 13) {
                stunnelVer = 11;
            }
            try {
                StunnelParameters parameters = StunnelParameterBuilder.run(stunnelVer, this.bmcIP, ipmiOEMPortServiceCommand, guid, config.getUserName(), config.getPassword());
                if (parameters.getUser() != null && parameters.getUser().isKVMSessionConnected()) {
                    return;
                }
                if (stunnelVer == 5) {
                    StunnelUtility.configAndStartStunnel(parameters, ipmiOEMPortServiceCommand.getIPMIInterface(), parameters.getCAMode());
                    if (!StunnelUtility.preCheck(parameters, config, stunnelVer)) {
                        StunnelUtility.stopStunnel(parameters.getStunnelFolder());
                        stunnelVer = 11;
                        parameters = StunnelParameterBuilder.run(stunnelVer, this.bmcIP, ipmiOEMPortServiceCommand, guid, config.getUserName(), config.getPassword());
                        StunnelUtility.configAndStartStunnel(parameters, ipmiOEMPortServiceCommand.getIPMIInterface(), parameters.getCAMode());
                    }
                } else {
                    StunnelUtility.configAndStartStunnel(parameters, ipmiOEMPortServiceCommand.getIPMIInterface(), parameters.getCAMode());
                }
                MicroBladeKVMButtons.lunchKVMFromJRE(parameters.getStunnelIP(), this.id, this.password, parameters.getSturnnlPortList(), vmType, this.bmcIP, parameters.getStunnelFolder(), stunnelVer, ipmiOEMPortServiceCommand, guid);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage());
            }
        } else {
            MicroBladeKVMButtons.lunchKVMFromJRE(this.bmcIP, this.id, this.password, port, vmType);
        }
        this.sessionController.closeSession();
    }

    private static void lunchKVMFromJRE(String ip, String id, String pw, int port, int vmType) {
        File jre = new File("jre");
        try {
            if (System.getProperty("os.name").indexOf("Windows") < 0) {
                String tmpPath = StunnelUtility.getTmpDir();
                FileWriter fw = new FileWriter(tmpPath + ip + ".temp");
                fw.write("ID: " + id + "\n");
                fw.write("Password: " + pw + "\n");
                fw.write("Port: " + port + "\n");
                fw.write("Vm: " + vmType + "\n");
                fw.close();
            }
        }
        catch (IOException tmpPath) {
            // empty catch block
        }
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar iKVM.jar " + ip + " " + id + " " + pw + " null " + port + " 623 " + vmType + " 0" : (System.getProperty("os.name").indexOf("Mac") >= 0 ? "./jre/Contents/Home/bin/java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR" : "./jre/bin/java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR")) : (System.getProperty("os.name").indexOf("Windows") >= 0 ? "java -Djava.library.path=. -jar iKVM.jar " + ip + " " + id + " " + pw + " null " + port + " 623 " + vmType + " 0" : "java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR");
        try {
            Runtime.getRuntime().exec(execString);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage());
        }
    }

    private static void lunchKVMFromJRE(String ip, String id, String pw, List<Integer> portList, int vmType, String BMCIP, String stunnleFolder, int stunnelVer, IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand, byte[] guid) {
        File f;
        String kvmJar = "iKVM.jar";
        if (stunnelVer == 9 || stunnelVer == 11) {
            kvmJar = "iKVM_ssl.jar";
            if (stunnelVer == 11) {
                String httpPort = "80";
                String httpsPort = "443";
                try {
                    httpPort = String.valueOf(ipmiOEMPortServiceCommand.getPort((byte)0));
                    httpsPort = String.valueOf(ipmiOEMPortServiceCommand.getPort((byte)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                KVMSessionConnection connection = new KVMSessionConnection(BMCIP, id, pw, httpPort, httpsPort, guid);
                try {
                    KVMUser user = connection.getLoginUser();
                    if (user == null) {
                        System.out.print("Could not establish KVM connction");
                        return;
                    }
                    id = user.getUsername();
                    pw = user.getPassword();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (!(f = new File(kvmJar)).exists()) {
            System.out.println("Cannot find " + kvmJar);
            return;
        }
        File jre = new File("jre");
        int vmPort = 623;
        if (portList.size() > 1) {
            vmPort = portList.get(1);
        }
        try {
            if (System.getProperty("os.name").indexOf("Windows") < 0) {
                String tmpPath = StunnelUtility.getTmpDir();
                FileWriter fw = new FileWriter(tmpPath + BMCIP + ".temp");
                fw.write("ID: " + id + "\n");
                fw.write("Password: " + pw + "\n");
                fw.write("Port: " + portList.get(0) + "\n");
                fw.write("Vm: " + vmType + "\n");
                fw.write("Vm_port: " + vmPort + "\n");
                fw.write("Version: " + stunnelVer + "\n");
                fw.close();
            }
        }
        catch (IOException tmpPath) {
            // empty catch block
        }
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar " + kvmJar + " " + ip + " " + id + " " + pw + " null " + portList.get(0) + " " + vmPort + " " + vmType + "   0 --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer : (System.getProperty("os.name").indexOf("Mac") >= 0 ? "./jre/Contents/Home/bin/java -Djava.library.path=. -jar " + kvmJar + " " + ip + " 0 0 --FR --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder : "./jre/bin/java -Djava.library.path=. -jar " + kvmJar + " " + ip + " 0 0 --FR --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder)) : (System.getProperty("os.name").indexOf("Windows") >= 0 ? "java -Djava.library.path=. -jar " + kvmJar + " " + ip + " " + id + " " + pw + " null " + portList.get(0) + " " + vmPort + " " + vmType + " 0 --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer : "java -Djava.library.path=. -jar  " + kvmJar + " " + ip + " 0 0 --FR --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder);
        try {
            Runtime.getRuntime().exec(execString);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage());
        }
    }

    ISessionController createSessionController(IPMIInterfaceConfig ipmiInterfaceConfig) {
        this.sessionController = IPMIVersion.getSessionController(ipmiInterfaceConfig);
        if (this.sessionController == null) {
            System.out.println("divice didn't exist");
            return null;
        }
        return this.sessionController;
    }

    IPMIInterface startSessionConnect(IPMIInterfaceConfig ipmiInterfaceConfig) {
        IPMINetworkInterface rmcp = this.sessionController.startup(ipmiInterfaceConfig);
        if (rmcp == null) {
            System.out.println("Network error");
            MessageCenter.getInstance().put("Network error");
            return null;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        return rmcp;
    }

    private IPMIInterfaceConfig initIPMIInterfaceConfig() {
        IPMIInterfaceConfig ipmiInterfaceConfig = new IPMIInterfaceConfig();
        ipmiInterfaceConfig.setIp(this.bmcIP);
        ipmiInterfaceConfig.setUserName(this.id);
        ipmiInterfaceConfig.setPassword(this.password);
        ipmiInterfaceConfig.setRetry(2);
        ipmiInterfaceConfig.setTimeout(5);
        ipmiInterfaceConfig.setCipherSuiteID((byte)3);
        return ipmiInterfaceConfig;
    }
}

