/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.dcmi;

import com.supermicro.ipmi.IPMIDCMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.nm.dcmi.PowerLimit;
import java.util.HashMap;
import java.util.Map;

public class GetPowerLimit {
    private static final Map<String, String> completionCodeToString = new HashMap<String, String>();
    private IPMIDCMICommand dcmi;

    public GetPowerLimit(IPMIDCMICommand dcmi) {
        this.dcmi = dcmi;
    }

    public PowerLimit execute() throws IPMIException {
        IPMIMessage resMessage = this.dcmi.getPowerLimitCommand((byte)0, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return new PowerLimit(resMessage.data);
            }
            throw Common.cCodeToException(completionCodeToString, resMessage);
        }
        throw new IPMIException("Call GetPowerLimit failed");
    }

    static {
        completionCodeToString.put("80", "No Set Power Limit.");
        completionCodeToString.put("C1", "Returned if DCMI mode is not present.");
    }
}

