/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.sensor;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.nm.sensor.CUPSSensor;
import com.supermicro.ipmi.nm.sensor.DiscreteSensor;
import com.supermicro.ipmi.nm.sensor.DiscreteSensorFactory;
import com.supermicro.ipmi.nm.sensor.Sensor;
import com.supermicro.ipmi.nm.sensor.SensorDefine;
import com.supermicro.ipmi.nm.sensor.SensorThreshold;
import com.supermicro.ipmi.nm.sensor.ThresholdSensor;
import com.supermicro.ipmi.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class GetSensor {
    private IPMINM20Command ipmiCommand;
    private IPMISDRCommand sdrCommand;
    private List<ThresholdSensor> tsensors = new ArrayList<ThresholdSensor>();
    private List<DiscreteSensor> dsensors = new ArrayList<DiscreteSensor>();

    public GetSensor(IPMINM20Command ipmiCommand, IPMISDRCommand sdrCommand) {
        this.ipmiCommand = ipmiCommand;
        this.sdrCommand = sdrCommand;
    }

    public void execute() {
        int i = 1;
        for (SensorDefine s : Common.SENSOR_DEFINES.values()) {
            byte[] reading;
            System.out.print("Get Sensors... (" + i + "/" + Common.SENSOR_DEFINES.size() + ")\r");
            ++i;
            if (s.isEventOnly() || (reading = this.getSensorReading(s.getId())) == null) continue;
            if ((s.getEventType() & 0xFF) == 1) {
                SensorThreshold th = this.getThreshold(s.getId());
                if (this.isCUPSSenor(s.getId())) {
                    this.tsensors.add(new CUPSSensor(s, reading, th));
                } else {
                    this.tsensors.add(new ThresholdSensor(s, reading, th));
                }
            } else {
                this.dsensors.add(DiscreteSensorFactory.getSensor(s, reading));
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.print();
    }

    private boolean isCUPSSenor(int id) {
        return id == 190 || id == 191 || id == 192;
    }

    private byte[] getSensorReading(int id) {
        IPMIMessage resMessage = this.ipmiCommand.getSensorReadingCommand((byte)id);
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data;
        }
        return null;
    }

    private SensorThreshold getThreshold(int id) {
        IPMIMessage resMessage = this.sdrCommand.getSensorThresholdCommand((byte)id);
        if (resMessage != null && resMessage.completionCode == 0) {
            return new SensorThreshold(resMessage.data);
        }
        return new SensorThreshold();
    }

    private void print() {
        this.printThresholdSensor();
        this.printDiscreteSensor();
    }

    private void printThresholdSensor() {
        String formatThreshold = "  %-6s | %-48s | %12s | %10s | %10s | \n";
        System.out.print(String.format(formatThreshold, "Id", "Sensor", "Reading", "Low Limit", "High Limit"));
        System.out.print(String.format(formatThreshold, "------", "---------", "-------", "---------", "----------"));
        for (ThresholdSensor ts : this.tsensors) {
            String reading = "N/A";
            String lowLimit = "N/A";
            String hiLimit = "N/A";
            if (ts.getStatus() == Sensor.STATUS.NORMAL) {
                reading = this.getReadingUnitFormat(ts.getUnit(), ts.getReading());
                lowLimit = this.getReadingUnitFormat(ts.getUnit(), ts.getLowLimit());
                hiLimit = this.getReadingUnitFormat(ts.getUnit(), ts.getHighLimit());
            }
            System.out.print(String.format(formatThreshold, ts.getId(), ts.getName(), reading, lowLimit, hiLimit));
        }
        System.out.print(String.format(formatThreshold, "------", "---------", "-------", "---------", "----------"));
    }

    private void printDiscreteSensor() {
        String formatDiscrete = "  %-6s | %-48s | %38s | \n";
        for (DiscreteSensor ds : this.dsensors) {
            System.out.print(String.format(formatDiscrete, ds.getId(), ds.getName(), StringUtil.center(ds.getSensorStateDesc(), 38)));
        }
    }

    private void printReadingRaw() {
        String formatThreshold = "  %-6s | %-48s | %12s | %10s | %10s | %20s |\n";
        String formatDiscrete = "  %-6s | %-48s | %38s | %20s |\n";
        System.out.print(String.format(formatThreshold, "Id", "Sensor", "Reading", "Low Limit", "High Limit", "Reading Raw"));
        System.out.print(String.format(formatThreshold, "------", "---------", "-------", "---------", "----------", "----------"));
        for (ThresholdSensor ts : this.tsensors) {
            String reading = "N/A";
            String lowLimit = "N/A";
            String hiLimit = "N/A";
            if (ts.getStatus() == Sensor.STATUS.NORMAL) {
                reading = this.getReadingUnitFormat(ts.getUnit(), ts.getReading());
                lowLimit = this.getReadingUnitFormat(ts.getUnit(), ts.getLowLimit());
                hiLimit = this.getReadingUnitFormat(ts.getUnit(), ts.getHighLimit());
            }
            System.out.print(String.format(formatThreshold, ts.getId(), ts.getName(), reading, lowLimit, hiLimit, ts.getReadingDataString()));
        }
        System.out.print(String.format(formatThreshold, "------", "---------", "-------", "---------", "----------", "----------"));
        for (DiscreteSensor ds : this.dsensors) {
            System.out.print(String.format(formatDiscrete, ds.getId(), ds.getName(), ds.getSensorStateDesc(), ds.getReadingDataString()));
        }
    }

    private String getReadingUnitFormat(String unit, int reading) {
        if ("C".equals(unit)) {
            return this.showCandF(reading);
        }
        if (reading == -1) {
            return "N/A";
        }
        if (unit == null || unit.isEmpty()) {
            return Integer.toString(reading);
        }
        return reading + " " + unit;
    }

    private String showCandF(int c) {
        long f = Math.round(1.8 * (double)c + 32.0);
        if (GlobalDefine.THERMAL_TEAM_SCRIPT) {
            return "" + c;
        }
        return c + "C/" + f + "F";
    }
}

