/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbios;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.text.MOut;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;

public abstract class TypeStruct {
    int BYTE = 1;
    int WORD = 2;
    int DWORD = 4;
    int QWORD = 8;
    int type;
    int length;
    byte[] handle;
    byte[] dataByte;
    int totalLength;
    String[] strField;
    boolean debug;
    byte[] rawData;
    int debugLength;
    int strFieldCount;
    int totalCount;
    int availableCount;
    int position = 4;
    byte[] byteArray = new byte[0];

    public TypeStruct(byte[] dataByte) {
        this.dataByte = dataByte;
        this.type = dataByte[0] & 0xFF;
        this.length = dataByte[1] & 0xFF;
        this.totalLength = dataByte[1] & 0xFF;
        this.handle = Arrays.copyOfRange(dataByte, 2, 4);
        ArrayUtils.reverse(this.handle);
    }

    String getType() {
        return ByteUtility.byteToHex((byte)this.type);
    }

    String getLength() {
        return ByteUtility.byteToHex((byte)this.length);
    }

    String getHandle() {
        return ByteUtility.bytesToHexNoSpace(this.handle);
    }

    byte[] getTypeLength(int typeLength) {
        if (this.position < this.length) {
            switch (typeLength) {
                case 1: {
                    this.byteArray = new byte[]{this.dataByte[this.position]};
                    ++this.position;
                    return this.byteArray;
                }
            }
            this.byteArray = Arrays.copyOfRange(this.dataByte, this.position, this.position + typeLength);
            this.position += typeLength;
            return this.byteArray;
        }
        return this.byteArray;
    }

    public byte[] remainBytes() {
        return Arrays.copyOfRange(this.dataByte, this.totalLength, this.dataByte.length);
    }

    public void stringFieldParser() {
        if (this.strFieldCount == 0) {
            return;
        }
        this.rawData = this.dataByte;
        this.debugLength = this.totalLength;
        this.dataByte = Arrays.copyOfRange(this.dataByte, this.totalLength, this.dataByte.length);
        this.strField = new String[this.strFieldCount];
        StringBuilder sb = new StringBuilder();
        int strCount = 0;
        int zeroCount = 0;
        this.totalLength = 0;
        for (byte singleByte : this.dataByte) {
            if (singleByte == 0) {
                this.strField[strCount] = sb.toString().trim();
                sb.setLength(0);
                ++strCount;
                ++zeroCount;
            } else {
                sb.append(new String(new byte[]{singleByte}));
                zeroCount = 0;
            }
            ++this.totalLength;
            ++this.debugLength;
            if (zeroCount == 2) break;
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        if (debug) {
            this.rawData = Arrays.copyOfRange(this.rawData, 0, this.debugLength);
            MOut.G().print(" ");
            for (int i = 0; i < this.rawData.length; ++i) {
                MOut.G().print(ByteUtility.byteToHex(this.rawData[i]) + " ");
                if (i % 20 != 0) continue;
                MOut.G().print("\n ");
            }
            MOut.G().print("\n");
        }
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-30s | %30s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format("\n", new Object[0]));
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "-------------------------", "-------------------------"));
        return header.toString();
    }

    public abstract String toFormatedString();

    static int bitsToInt(BitSet bits) {
        int value = 0;
        for (int i = 0; i < bits.length(); ++i) {
            value += bits.get(i) ? 1 << i : 0;
        }
        return value;
    }

    static String intTo4Hex(int digital) {
        return Integer.toHexString(digital & 0xFFFF | 0xFFFF0000).substring(4);
    }
}

