/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.stunnel;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.kvm.authentication.KVMSessionConnection;
import com.supermicro.ipmi.kvm.authentication.KVMUser;
import com.supermicro.ipmi.stunnel.StunnelParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class StunnelParameterBuilder {
    public static void main(String[] args) {
    }

    @Deprecated
    public static StunnelParameters run(int stunnelVer, String IP, IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand, byte[] guid, String id, String password, boolean isShowDialog) throws Exception {
        StunnelParameters parameters = null;
        return parameters;
    }

    public static StunnelParameters run(int stunnelVer, String IP, IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand, byte[] guid, String id, String password) throws Exception {
        StunnelParameters parameters = null;
        String kvmPort = StunnelParameterBuilder.getKVMPort(ipmiOEMPortServiceCommand);
        String vmPort = StunnelParameterBuilder.getVMPort(ipmiOEMPortServiceCommand, guid);
        switch (stunnelVer) {
            case 1: {
                parameters = new StunnelParameters.Builder(IP, "3520").command("iKVM").build();
                break;
            }
            case 3: {
                parameters = new StunnelParameters.Builder(IP, kvmPort).command("iKVM").build();
                break;
            }
            case 5: {
                parameters = new StunnelParameters.Builder(IP, kvmPort).command("iKVM").build();
                break;
            }
            case 7: {
                parameters = new StunnelParameters.Builder(IP, kvmPort).command("iKVM").build();
                break;
            }
            case 9: {
                parameters = new StunnelParameters.Builder(IP, Arrays.asList(kvmPort, vmPort)).commands(Arrays.asList("iKVM", "VirtualMedia")).build();
                break;
            }
            case 11: 
            case 13: {
                parameters = new StunnelParameters.Builder(IP, Arrays.asList(kvmPort, vmPort)).commands(Arrays.asList("iKVM", "VirtualMedia")).build();
                break;
            }
            case 15: {
                parameters = new StunnelParameters.Builder(IP, Arrays.asList(kvmPort, vmPort)).commands(Arrays.asList("iKVM", "VirtualMedia")).stunnelVer(stunnelVer).build();
                break;
            }
            default: {
                parameters = new StunnelParameters.Builder(IP, kvmPort).command("iKVM").build();
            }
        }
        if (stunnelVer >= 11) {
            KVMUser user = StunnelParameterBuilder.getKVMUser(IP, id, password, ipmiOEMPortServiceCommand, guid);
            parameters.setUser(user);
        }
        int CAMode = StunnelParameterBuilder.getCAMode(stunnelVer);
        parameters.setCAMode(CAMode);
        parameters.setStunnelVer(stunnelVer);
        return parameters;
    }

    public static StunnelParameters run(int stunnelVer, String IP, IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand, byte[] guid) throws Exception {
        return StunnelParameterBuilder.run(stunnelVer, IP, ipmiOEMPortServiceCommand, guid, null, null);
    }

    public static KVMUser getKVMUser(String IP, String id, String password, IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand, byte[] guid) throws Exception {
        String httpPort = "80";
        try {
            httpPort = String.valueOf(ipmiOEMPortServiceCommand.getPort((byte)0));
        }
        catch (Exception e) {
            httpPort = "5900";
        }
        String httpsPort = "443";
        try {
            httpsPort = String.valueOf(ipmiOEMPortServiceCommand.getPort((byte)1));
        }
        catch (Exception e) {
            httpsPort = "443";
        }
        KVMSessionConnection connection = new KVMSessionConnection(IP, id, password, httpPort, httpsPort, guid);
        KVMUser user = connection.getLoginUser();
        if (user != null) {
            return user;
        }
        return null;
    }

    public static StunnelParameters runByFunction(int stunnelVer, String IP, String id, String password, IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand, byte[] guid, String ... args) throws Exception {
        if (args == null) {
            System.out.println("Unknow method");
            return null;
        }
        ArrayList<String> portList = new ArrayList<String>();
        ArrayList<String> commandList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if ("iKVM".equalsIgnoreCase(args[i]) || "ko".equalsIgnoreCase(args[i]) || "sc".equalsIgnoreCase(args[i])) {
                portList.add(StunnelParameterBuilder.getKVMPort(ipmiOEMPortServiceCommand));
                commandList.add(args[i]);
                continue;
            }
            if ("VirtualMedia".equalsIgnoreCase(args[i])) {
                portList.add(StunnelParameterBuilder.getVMPort(ipmiOEMPortServiceCommand, guid));
                commandList.add(args[i]);
                continue;
            }
            try {
                int value = Integer.parseInt(args[i]);
                if (value < 0) {
                    System.out.println("Port should be a positve number");
                    continue;
                }
                portList.add(args[i]);
                commandList.add("Unknow");
                continue;
            }
            catch (Exception e) {
                System.out.println("Not defiend type or valid Port");
            }
        }
        StunnelParameters parameters = new StunnelParameters.Builder(IP, portList).commands(commandList).build();
        if (stunnelVer >= 11) {
            KVMUser user = StunnelParameterBuilder.getKVMUser(IP, id, password, ipmiOEMPortServiceCommand, guid);
            parameters.setUser(user);
        }
        int CAMode = StunnelParameterBuilder.getCAMode(stunnelVer);
        parameters.setCAMode(CAMode);
        parameters.setStunnelVer(stunnelVer);
        return parameters;
    }

    public static StunnelParameters runByFunction(int stunnelVer, String IP, IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand, byte[] guid, String ... args) throws Exception {
        return StunnelParameterBuilder.runByFunction(stunnelVer, IP, null, null, ipmiOEMPortServiceCommand, guid, args);
    }

    public static int getCAMode(int stunnelVer) {
        int CAMode = 1;
        switch (stunnelVer) {
            case 1: 
            case 3: {
                CAMode = 0;
                break;
            }
            case 5: {
                CAMode = 1;
                break;
            }
            case 7: {
                CAMode = 2;
                break;
            }
            case 9: {
                CAMode = 2;
                break;
            }
            case 11: 
            case 13: {
                CAMode = 1;
                break;
            }
            case 15: {
                CAMode = 3;
                break;
            }
            default: {
                CAMode = 1;
            }
        }
        return CAMode;
    }

    private static String getKVMPort(IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand) {
        String kvmPort = "5900";
        try {
            kvmPort = String.valueOf(ipmiOEMPortServiceCommand.getPort((byte)2));
        }
        catch (Exception e) {
            kvmPort = "5900";
        }
        return kvmPort;
    }

    private static String getVMPort(IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand, byte[] guid) {
        String vmPort = "623";
        int vmPortIndex = 3;
        if (IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid)) {
            vmPortIndex = 18;
        }
        try {
            vmPort = String.valueOf(ipmiOEMPortServiceCommand.getPort((byte)vmPortIndex));
        }
        catch (Exception e) {
            vmPort = "623";
        }
        return vmPort;
    }

    static enum DefaultPort {
        KVM(5900),
        SC(5900),
        KO(5900),
        VM(623);

        private int value;
        private static final Map<Integer, DefaultPort> portMap;

        private DefaultPort(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static DefaultPort getMCUNameBytValue(int value) {
            return portMap.get(value);
        }

        static {
            portMap = new HashMap<Integer, DefaultPort>();
            for (DefaultPort myEnum : DefaultPort.values()) {
                portMap.put(myEnum.getValue(), myEnum);
            }
        }
    }
}

