/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.stunnel;

import com.supermicro.ipmi.kvm.authentication.KVMUser;
import java.util.ArrayList;
import java.util.List;

public class StunnelParameters {
    private String BMCIP;
    private List<String> portList;
    private List<String> commandList;
    private String command = "unKnow";
    private int CAMode = 1;
    private String stunnelFolder = "";
    private String stunnelIP = "127.0.0.1";
    private String sturnnlPort;
    private List<Integer> sturnnlPortList = new ArrayList<Integer>();
    private KVMUser user = null;
    private int stunnelVer = 0;

    public String toString() {
        return "StunnelParameters [BMCIP=" + this.BMCIP + ", portList=" + this.portList + ", commandList=" + this.commandList + ", command=" + this.command + ", CAMode=" + this.CAMode + ", stunnelFolder=" + this.stunnelFolder + ", stunnelIP=" + this.stunnelIP + ", sturnnlPort=" + this.sturnnlPort + ", sturnnlPortList=" + this.sturnnlPortList + "]";
    }

    private StunnelParameters(Builder builder) {
        this.BMCIP = builder.BMCIP;
        this.portList = builder.portList;
        this.commandList = builder.commandList;
        this.CAMode = builder.CAMode;
        this.stunnelVer = builder.stunnelVer;
    }

    public String getStunnelIP() {
        return this.stunnelIP;
    }

    public void setStunnelIP(String stunnelIP) {
        this.stunnelIP = stunnelIP;
    }

    public String getSturnnlPort() {
        return this.sturnnlPort;
    }

    public void setSturnnlPort(String sturnnlPort) {
        this.sturnnlPort = sturnnlPort;
        this.sturnnlPortList.add(Integer.parseInt(sturnnlPort));
    }

    public String getStunnelFolder() {
        return this.stunnelFolder;
    }

    public void setStunnelFolder(String stunnelFolder) {
        this.stunnelFolder = stunnelFolder;
    }

    public int getCAMode() {
        return this.CAMode;
    }

    public void setCAMode(int CAMode) {
        this.CAMode = CAMode;
    }

    public String getBMCIP() {
        return this.BMCIP;
    }

    public List<String> getportList() {
        return this.portList;
    }

    public List<Integer> getSturnnlPortList() {
        return this.sturnnlPortList;
    }

    public void setPortToSturnnlList(int sturnnlPortList) {
        this.sturnnlPortList.add(sturnnlPortList);
    }

    public List<String> getCommandList() {
        return this.commandList;
    }

    public KVMUser getUser() {
        return this.user;
    }

    public void setUser(KVMUser user) {
        this.user = user;
    }

    public int getStunnelVer() {
        return this.stunnelVer;
    }

    public void setStunnelVer(int stunnelVer) {
        this.stunnelVer = stunnelVer;
    }

    public static class Builder {
        private String BMCIP;
        private List<String> portList = new ArrayList<String>();
        private List<String> commandList = new ArrayList<String>();
        private int CAMode;
        private int stunnelVer;

        public Builder(String BMCIP, String BMCPort) {
            this.BMCIP = BMCIP;
            this.portList.add(BMCPort);
        }

        public Builder(String BMCIP, List<String> portList) {
            this.BMCIP = BMCIP;
            this.portList = portList;
        }

        public Builder command(String command) {
            this.commandList.add(command);
            return this;
        }

        public Builder commands(List<String> commandList) {
            this.commandList = commandList;
            return this;
        }

        public Builder CAMode(int CAMode) {
            this.CAMode = CAMode;
            return this;
        }

        public Builder stunnelVer(int stunnelVer) {
            this.stunnelVer = stunnelVer;
            return this;
        }

        public StunnelParameters build() {
            return new StunnelParameters(this);
        }
    }
}

