/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.stunnel;

import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.kvm.authentication.KVMUser;
import com.supermicro.ipmi.stunnel.BaseStunnel;
import com.supermicro.ipmi.stunnel.CAModeInterface;
import com.supermicro.ipmi.stunnel.CAModeOne;
import com.supermicro.ipmi.stunnel.CAModeTwo;
import com.supermicro.ipmi.stunnel.StunnelFacotry;
import com.supermicro.ipmi.stunnel.StunnelParameters;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeTool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.CodeSource;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class StunnelUtility {
    public static boolean isSingleStunnelInstance = false;
    public static boolean showProgress = false;
    private static final boolean buildForCMM = false;
    private static final String KVMJAR = "iKVM.jar";
    private static final String KVMSSLJAR = "iKVM_ssl.jar";
    private static final String SCJAR = "sc.jar";
    private static final String KOJAR = "ko.jar";
    public static final String KVM = "iKVM";
    public static final String SC = "sc";
    public static final String KO = "ko";
    public static final String VM = "VirtualMedia";
    public static final String UN = "Unknow";
    private static StunnelUtility instance = null;

    public static synchronized StunnelUtility getInstance() {
        if (instance == null) {
            String isMultiInstance;
            ConfigAccessor ca = new ConfigAccessor(".", "CMServerP.properties");
            if (ca.getProperty("multidvo") == null) {
                ca.setProperty("multidvo", "true");
            }
            if ("true".equals(isMultiInstance = ca.getProperty("multidvo"))) {
                isSingleStunnelInstance = false;
            }
            instance = new StunnelUtility();
        }
        return instance;
    }

    public static StunnelParameters configAndStartStunnel(StunnelParameters parameters, IPMIInterface IPMIInterface2, int CAMode) throws Exception {
        long endTime;
        String localIP;
        String OS = StunnelUtility.checkOS();
        boolean isIPv6 = false;
        try {
            isIPv6 = StunnelUtility.isIPv6(parameters.getBMCIP());
        }
        catch (Exception e1) {
            isIPv6 = false;
        }
        String string = localIP = isIPv6 ? "::1" : "127.0.0.1";
        if (OS.indexOf("Windows") == -1) {
            ConfigAccessor ca = new ConfigAccessor(".", "stunnel.properties");
            boolean isUseProxyIP = false;
            if (ca.getProperty("proxy_ip") != null) {
                String proxyIP = ca.getProperty("proxy_ip");
                switch (StunnelUtility.isaIP(proxyIP)) {
                    case 0: 
                    case 1: {
                        localIP = proxyIP;
                        isUseProxyIP = true;
                        break;
                    }
                    default: {
                        MOut.G().println("The proxy_ip in stunnel.properties is not a valid IP, tool will use default method setup Stunnel.");
                    }
                }
            }
            if (!isUseProxyIP) {
                block21: {
                    String version = "";
                    try {
                        version = StunnelUtility.getEtcRelease();
                        if (version != null && version.toLowerCase().contains("ubuntu")) {
                            localIP = isIPv6 ? "::1" : "127.0.0.1";
                        } else {
                            String string2 = isIPv6 ? "::1" : (localIP = StunnelUtility.getFirstNonLoopbackAddress(!isIPv6, isIPv6).getHostAddress());
                        }
                        if (localIP == null) {
                            localIP = isIPv6 ? "::1" : "127.0.0.1";
                        }
                    }
                    catch (Exception e) {
                        String string3 = isIPv6 ? "::1" : (localIP = StunnelUtility.getFirstNonLoopbackAddress(!isIPv6, isIPv6).getHostAddress());
                        if (localIP != null) break block21;
                        String string4 = localIP = isIPv6 ? "::1" : "127.0.0.1";
                    }
                }
                if (isIPv6 && localIP.contains("%")) {
                    localIP = localIP.substring(0, localIP.indexOf("%"));
                }
            }
        }
        if (showProgress) {
            System.out.print(".");
        }
        parameters.setStunnelIP(localIP);
        if (showProgress) {
            System.out.print(".");
        }
        BaseStunnel stunnel = StunnelFacotry.createStunnel(OS, CAMode);
        CAModeInterface caInterface = stunnel.getCaInterface();
        String tempDIR = StunnelUtility.getTmpDir();
        String stunnelDir = caInterface.getStunnelDir();
        parameters.setStunnelFolder(stunnelDir);
        stunnelDir = tempDIR + stunnelDir;
        String localStunnelPort = StunnelUtility.getRandomConnectPort() + "";
        parameters.setSturnnlPort(localStunnelPort);
        if ("49999".equals(localStunnelPort)) {
            MOut.G().println("Can not find an unused port for stunnel");
            return parameters;
        }
        if (!isSingleStunnelInstance) {
            StunnelUtility.multiStunnelFlow(stunnel, IPMIInterface2, parameters, CAMode);
        } else {
            StunnelUtility.singleStunnelFlow(stunnel, IPMIInterface2, parameters, CAMode);
        }
        long startTime = System.currentTimeMillis();
        while (!StunnelUtility.isPortUsed(Integer.parseInt(localStunnelPort)) && ((endTime = System.currentTimeMillis()) - startTime) / 1000L <= 4L) {
            if (showProgress) {
                System.out.print(".");
            }
            StunnelUtility.startStunnel(stunnelDir, stunnel);
            Thread.sleep(500L);
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void singleStunnelFlow(BaseStunnel stunnel, IPMIInterface IPMIInterface2, StunnelParameters parameters, int CAMode) {
        CAModeInterface caInterface = stunnel.getCaInterface();
        String tempDIR = StunnelUtility.getTmpDir();
        String stunnelDir = tempDIR + caInterface.getStunnelDir();
        StunnelUtility.CopyStunnelConfigToTemp(stunnel, IPMIInterface2, parameters);
        FileLock lock = null;
        AbstractInterruptibleChannel channel = null;
        try {
            String lockFilePath = stunnelDir + "lockKey.txt";
            channel = new RandomAccessFile(new File(lockFilePath), "rw").getChannel();
            lock = ((FileChannel)channel).lock();
            Thread.sleep(500L);
            StunnelUtility.removeClosedHostFromConfig(stunnelDir, CAMode);
            StunnelUtility.addHostTolConfig(parameters, stunnelDir, CAMode, stunnel);
            Thread.sleep(500L);
            StunnelUtility.startStunnel(stunnelDir, stunnel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void multiStunnelFlow(BaseStunnel stunnel, IPMIInterface IPMIInterface2, StunnelParameters parameters, int CAMode) {
        String stunnelDir = parameters.getStunnelFolder();
        stunnelDir = StunnelUtility.getTmpDir() + stunnelDir;
        if (showProgress) {
            System.out.print(".");
        }
        StunnelUtility.multiStunnelSetup(stunnel, IPMIInterface2, parameters);
        try {
            Thread.sleep(500L);
            if (showProgress) {
                System.out.print(".");
            }
            StunnelUtility.addHostTolConfig(parameters, stunnelDir, CAMode, stunnel);
            if (showProgress) {
                System.out.print(".");
            }
            Thread.sleep(500L);
            StunnelUtility.startStunnel(stunnelDir, stunnel);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void multiStunnelSetup(BaseStunnel stunnel, IPMIInterface IPMIInterface2, StunnelParameters parameters) {
        boolean result;
        CAModeInterface caInterface = stunnel.getCaInterface();
        String stunnelDir = parameters.getStunnelFolder();
        String[] CASource = caInterface.getCASource();
        int CAMode = caInterface.CAMode;
        String tempDIR = StunnelUtility.getTmpDir();
        stunnelDir = tempDIR + stunnelDir;
        File tempFile = new File(stunnelDir);
        if (!tempFile.exists() && !(result = tempFile.mkdirs())) {
            MOut.G().println("Unable to create directory at " + stunnelDir);
        }
        String jarPath = StunnelUtility.getJarPath(StunnelUtility.class) + File.separator;
        FileInputStream inputStream = null;
        Object src = null;
        String tempFilePath = stunnelDir + "mail.pem";
        StunnelUtility main = new StunnelUtility();
        Class<?> utility = main.getClass();
        tempFile = new File(tempFilePath);
        String urlPath = "/res/mail.pem";
        if (!tempFile.exists()) {
            try {
                inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + "mail.pem"));
                StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
            }
            catch (Exception e) {
                e.printStackTrace();
                MOut.G().println("Can not find mail.pem under " + SuperBladeTool.softwareName + "(IPMIView) directory");
            }
        }
        if (CAMode == 1) {
            for (int i = 0; i < CASource.length; ++i) {
                tempFilePath = stunnelDir + CASource[i];
                tempFile = new File(tempFilePath);
                if (tempFile.exists()) continue;
                try {
                    inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + CASource[i]));
                    StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
                    continue;
                }
                catch (Exception e) {
                    MOut.G().println("Can not find BMCSecurity" + File.separator + CASource[i] + " under " + SuperBladeTool.softwareName + "(IPMIView) directory");
                }
            }
        } else if (CAMode == 2) {
            try {
                String[] originalfileNames = CAModeOne.getCAfileNames();
                String fileName = "";
                for (int i = 0; i < CASource.length; ++i) {
                    IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(IPMIInterface2);
                    byte optionCode = CAModeTwo.optionCode[i];
                    fileName = CASource[i];
                    boolean result2 = ipmiBMCFileCommand.generalFileDownload(optionCode, fileName, false, false);
                    if (!result2) {
                        MOut.G().println("download " + originalfileNames[i] + " fail");
                        continue;
                    }
                    tempFilePath = stunnelDir + fileName;
                    tempFile = new File(tempFilePath);
                    if (tempFile.exists()) continue;
                    File file = new File(jarPath + fileName);
                    Files.move(Paths.get(file.getAbsolutePath(), new String[0]), Paths.get(tempFilePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    if (tempFile.exists()) continue;
                    MOut.G().println("Move file " + originalfileNames[i] + " fail");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (CAMode == 3) {
            for (int i = 0; i < CASource.length; ++i) {
                tempFilePath = stunnelDir + CASource[i];
                tempFile = new File(tempFilePath);
                if (tempFile.exists()) continue;
                try {
                    if (parameters.getUser() != null) {
                        if (parameters.getUser().getServerCertificate() == null) continue;
                        String serverCrt = parameters.getUser().getServerCertificate();
                        Files.write(Paths.get(tempFilePath, new String[0]), serverCrt.getBytes("UTF-8"), new OpenOption[0]);
                        continue;
                    }
                    MOut.G().println("There is no KVMUser session");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MOut.G().println("Can not set CAfile");
                }
            }
        }
        String[] stunnelSource = stunnel.getNativeSource();
        for (int i = 0; i < stunnelSource.length; ++i) {
            tempFilePath = stunnelDir + stunnelSource[i];
            tempFile = new File(tempFilePath);
            if (tempFile.exists()) continue;
            try {
                inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + stunnel.OSDircetory + File.separator + stunnelSource[i]));
                StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
                continue;
            }
            catch (Exception e) {
                MOut.G().println("Can not find BMCSecurity" + File.separator + stunnel.OSDircetory + File.separator + stunnelSource[i] + " under " + SuperBladeTool.softwareName + "(IPMIView) directory");
                MOut.G().println("This might cause ikvm can not start due to stunnel fail");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CopyStunnelConfigToTemp(BaseStunnel stunnel, IPMIInterface IPMIInterface2, StunnelParameters parameters) {
        boolean result;
        String path = StunnelUtility.getTmpDir() + stunnel.getCaInterface().getStunnelDir();
        int CAMode = stunnel.getCaInterface().getCAMode();
        String OS = StunnelUtility.checkOS();
        File tempFile = new File(path);
        if (!tempFile.exists() && !(result = tempFile.mkdirs())) {
            MOut.G().println("Unable to create directory at " + path);
        }
        String jarPath = StunnelUtility.getJarPath(StunnelUtility.class) + File.separator;
        FileInputStream inputStream = null;
        String tempLockPath = path + "lockKey.txt";
        File lockFile = new File(tempLockPath);
        if (!lockFile.exists()) {
            try {
                inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + "lockKey.txt"));
                StunnelUtility.doCreateTempFile(inputStream, lockFile, tempLockPath);
            }
            catch (Exception e) {
                MOut.G().println("Can not find lockKey.txt under " + SuperBladeTool.softwareName + "(IPMIView) directory");
                e.printStackTrace();
            }
        }
        AbstractInterruptibleChannel channel = null;
        FileLock lock = null;
        try {
            int i;
            String lockFilePath = path + "lockKey.txt";
            channel = new RandomAccessFile(new File(lockFilePath), "rw").getChannel();
            lock = ((FileChannel)channel).lock();
            String tempFilePath = path + "mail.pem";
            tempFile = new File(tempFilePath);
            if (!tempFile.exists()) {
                try {
                    inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + "mail.pem"));
                    StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
                }
                catch (Exception e) {
                    MOut.G().println("Can not find mail.pem under " + SuperBladeTool.softwareName + "(IPMIView) directory");
                    e.printStackTrace();
                }
            }
            String[] CASource = stunnel.getCaInterface().getCASource();
            if (CAMode == 1) {
                for (int i2 = 0; i2 < CASource.length; ++i2) {
                    tempFilePath = path + CASource[i2];
                    tempFile = new File(tempFilePath);
                    if (tempFile.exists()) continue;
                    try {
                        inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + CASource[i2]));
                        StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        MOut.G().println("Can not find BMCSecurity" + File.separator + CASource[i2] + " under " + SuperBladeTool.softwareName + "(IPMIView) directory");
                    }
                }
            } else if (CAMode == 2) {
                String[] originalfileNames = CAModeOne.getCAfileNames();
                String fileName = "";
                for (i = 0; i < CASource.length; ++i) {
                    File file;
                    boolean success;
                    IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(IPMIInterface2);
                    byte optionCode = CAModeTwo.optionCode[i];
                    fileName = CASource[i];
                    boolean result2 = ipmiBMCFileCommand.generalFileDownload(optionCode, fileName, false, false);
                    if (!result2) {
                        MOut.G().println("download " + originalfileNames[i] + " fail");
                        continue;
                    }
                    tempFilePath = path + fileName;
                    tempFile = new File(tempFilePath);
                    if (tempFile.exists() || (success = (file = new File(jarPath + fileName)).renameTo(tempFile))) continue;
                    MOut.G().println("Move " + originalfileNames[i] + " fail");
                }
            } else if (CAMode == 3) {
                for (int i3 = 0; i3 < CASource.length; ++i3) {
                    tempFilePath = path + parameters.getBMCIP() + "_" + CASource[i3];
                    tempFile = new File(tempFilePath);
                    if (tempFile.exists()) continue;
                    try {
                        if (parameters.getUser().getServerCertificate() == null) continue;
                        String serverCrt = parameters.getUser().getServerCertificate();
                        Files.write(Paths.get(tempFilePath, new String[0]), serverCrt.getBytes("UTF-8"), new OpenOption[0]);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        MOut.G().println("Can not set CAfile");
                    }
                }
            }
            boolean neeInstall = false;
            String[] stunnelSource = stunnel.getNativeSource();
            for (i = 0; i < stunnelSource.length; ++i) {
                tempFilePath = path + stunnelSource[i];
                tempFile = new File(tempFilePath);
                if (tempFile.exists()) continue;
                try {
                    inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + stunnel.OSDircetory + File.separator + stunnelSource[i]));
                    StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
                    if (OS.indexOf("Windows") <= -1 || i != 0) continue;
                    neeInstall = true;
                    continue;
                }
                catch (Exception e) {
                    MOut.G().println("Can not find BMCSecurity" + File.separator + stunnel.OSDircetory + File.separator + stunnelSource[i] + " under " + SuperBladeTool.softwareName + "(IPMIView) directory");
                    MOut.G().println("This might cause ikvm can not start via stunnel");
                    e.printStackTrace();
                }
            }
            if (neeInstall) {
                String absolutePath = path + "stunnel.exe -install -quiet";
                File file = new File(absolutePath);
                String cmd = file.toString();
                try {
                    Process p = Runtime.getRuntime().exec(cmd);
                    p.waitFor();
                }
                catch (Exception e) {
                    MOut.G().println("stunnel install failure");
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            MOut.G().println("stunnel install fail");
            e.printStackTrace();
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (IOException e) {
                MOut.G().println("release lock fail");
                e.printStackTrace();
            }
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException e) {
                MOut.G().println("close file fail");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHostTolConfig(StunnelParameters parameters, String path, int CAMode, BaseStunnel stunnel) {
        boolean removeLast = false;
        String str = "";
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(path + "stunnel.conf"));
            StringBuffer stringBuffer = new StringBuffer();
            String OS = StunnelUtility.checkOS();
            boolean isHostInfo = false;
            while ((str = bufferedReader.readLine()) != null) {
                if (str.indexOf("HOST_") > -1) {
                    isHostInfo = true;
                }
                if (!isHostInfo && OS.indexOf("Windows") == -1 && str.indexOf("cert") > -1) {
                    String[] splitCert = str.split("=");
                    str = splitCert[0] + "=" + path + "mail.pem";
                    str = str.trim();
                }
                stringBuffer.append(str);
                stringBuffer.append("\r\n");
            }
            if (!removeLast) {
                stringBuffer.append("\r\n");
            }
            String stunnelPort = parameters.getSturnnlPort();
            boolean firstPort = true;
            int indexOfCommand = 0;
            for (String BMCPort : parameters.getportList()) {
                String[] CAFiles;
                if (!firstPort) {
                    long startTime = System.currentTimeMillis();
                    int port = Integer.parseInt(stunnelPort) + 1;
                    while (StunnelUtility.isPortUsed(port)) {
                        port = (int)(Math.random() * 15536.0 + 50000.0);
                        long endTime = System.currentTimeMillis();
                        if ((endTime - startTime) / 1000L <= 5L) continue;
                        port = 49999;
                        break;
                    }
                    parameters.setPortToSturnnlList(port);
                    stunnelPort = port + "";
                }
                firstPort = false;
                String BMCIP = parameters.getBMCIP();
                String stunnelIP = parameters.getStunnelIP();
                String command = parameters.getCommandList().get(indexOfCommand++);
                CAModeInterface caInterface = stunnel.getCaInterface();
                stringBuffer.append("[HOST_" + command + "]");
                stringBuffer.append("\r\n");
                stringBuffer.append("client = yes");
                stringBuffer.append("\r\n");
                stringBuffer.append("accept = " + stunnelIP + ":" + stunnelPort);
                stringBuffer.append("\r\n");
                stringBuffer.append("connect = " + BMCIP + ":" + BMCPort);
                stringBuffer.append("\r\n");
                if (CAMode == 1) {
                    stringBuffer.append("verify = 3");
                    stringBuffer.append("\r\n");
                    stringBuffer.append("cert = " + path + "client.crt");
                    stringBuffer.append("\r\n");
                    stringBuffer.append("key = " + path + "client.key");
                    stringBuffer.append("\r\n");
                    stringBuffer.append("CAfile = " + path + "server.crt");
                    stringBuffer.append("\r\n");
                } else if (CAMode == 2) {
                    stringBuffer.append("verify = 3");
                    stringBuffer.append("\r\n");
                    CAFiles = caInterface.getCASource();
                    stringBuffer.append("cert = " + path + CAFiles[0]);
                    stringBuffer.append("\r\n");
                    stringBuffer.append("key = " + path + CAFiles[1]);
                    stringBuffer.append("\r\n");
                    stringBuffer.append("CAfile = " + path + CAFiles[2]);
                    stringBuffer.append("\r\n");
                } else if (CAMode == 3) {
                    CAFiles = caInterface.getCASource();
                    stringBuffer.append("verify = 3");
                    stringBuffer.append("\r\n");
                    if (isSingleStunnelInstance) {
                        stringBuffer.append("CAfile = " + path + parameters.getBMCIP() + "_" + CAFiles[0]);
                    } else {
                        stringBuffer.append("CAfile = " + path + CAFiles[0]);
                    }
                    stringBuffer.append("\r\n");
                }
                stringBuffer.append("\r\n");
                bufferedReader.close();
                PrintWriter writer = new PrintWriter(path + "stunnel.conf");
                BufferedWriter bufferedWriter = new BufferedWriter(writer);
                try {
                    bufferedWriter.write(stringBuffer.toString());
                }
                catch (IOException ex) {
                    MOut.G().println("Write buffer fail");
                }
                try {
                    bufferedWriter.close();
                }
                catch (IOException ex) {
                    MOut.G().println("Close buffer fail");
                }
                writer.close();
            }
        }
        catch (FileNotFoundException e) {
            MOut.G().println("Read BaseStunnel.CONFIG Failure");
        }
        catch (IOException e) {
            MOut.G().println(" BufferedReader  Failure");
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                MOut.G().println("BufferedReader close fail");
            }
        }
    }

    public static List<String> removeClosedHostFromConfig(String path, int CAMode) {
        ArrayList<String> list = new ArrayList<String>();
        String OS = StunnelUtility.checkOS();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(path + "stunnel.conf"));
            StringBuffer stringBuffer = new StringBuffer();
            String str = "";
            String lastStr = null;
            StringBuffer tempBuffer = new StringBuffer();
            boolean iskeepInConf = false;
            boolean skipSapce = false;
            boolean isHostInfo = false;
            while ((str = bufferedReader.readLine()) != null) {
                if (str.indexOf("HOST_") > -1) {
                    isHostInfo = true;
                }
                if (!isHostInfo && str.indexOf("CAfile") > -1) continue;
                if (str.indexOf("HOST_") > -1 || str.indexOf("client") > -1 && str.indexOf("=") > -1 || str.indexOf("accept") > -1 || str.indexOf("connect") > -1 || str.indexOf("verify") > -1 || isHostInfo && str.indexOf("cert") > -1 || isHostInfo && str.indexOf("key") > -1 || isHostInfo && str.indexOf("CAfile") > -1) {
                    tempBuffer.append(str);
                    tempBuffer.append("\r\n");
                    if (str.indexOf("accept") > -1) {
                        String[] splitAccept = str.split(":");
                        String stunnelPort = splitAccept[1].trim();
                        if (OS.indexOf("Windows") > -1) {
                            if (StunnelUtility.isHostStillConnectByJPS(stunnelPort)) {
                                iskeepInConf = true;
                            }
                        } else if (StunnelUtility.isHostStillConnectInLinux(path, stunnelPort)) {
                            iskeepInConf = true;
                        }
                        skipSapce = false;
                    }
                    if (str.indexOf("CAfile") > -1) {
                        if (iskeepInConf) {
                            stringBuffer.append(tempBuffer.toString());
                            stringBuffer.append(System.lineSeparator());
                        } else {
                            skipSapce = true;
                        }
                        iskeepInConf = false;
                        tempBuffer.setLength(0);
                        continue;
                    }
                    if (str.indexOf("connect") <= -1 || CAMode != 0) continue;
                    if (iskeepInConf) {
                        stringBuffer.append(tempBuffer.toString());
                        stringBuffer.append(System.lineSeparator());
                    } else {
                        skipSapce = true;
                    }
                    iskeepInConf = false;
                    tempBuffer.setLength(0);
                    continue;
                }
                if (!str.equals(lastStr)) {
                    stringBuffer.append(str);
                } else {
                    skipSapce = true;
                }
                if (!skipSapce) {
                    stringBuffer.append("\r\n");
                }
                lastStr = str;
            }
            PrintWriter writer = new PrintWriter(path + "stunnel.conf");
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            try {
                bufferedWriter.write(stringBuffer.toString());
            }
            catch (IOException ex) {
                MOut.G().println("Unable to write buffer wrtier");
            }
            bufferedWriter.close();
            writer.close();
        }
        catch (Exception e) {
            MOut.G().println("parseStunnelConfig failure ");
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                MOut.G().println("Unable to close buffer reader");
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startStunnel(String path, BaseStunnel stunnel) throws InterruptedException {
        String OS = StunnelUtility.checkOS();
        Process process = null;
        String absolutePath = "";
        String executeSource = stunnel.getNativeSource()[0];
        if (OS.indexOf("Windows") > -1) {
            if (isSingleStunnelInstance) {
                try {
                    absolutePath = path + executeSource + " -start -quiet";
                    File file = new File(absolutePath);
                    String cmd = file.toString();
                    process = Runtime.getRuntime().exec(cmd);
                    process.waitFor();
                    Thread.sleep(1500L);
                    absolutePath = path + executeSource + " -reload -quiet";
                    file = new File(absolutePath);
                    cmd = file.toString();
                    process = Runtime.getRuntime().exec(cmd);
                    process.waitFor();
                }
                catch (Exception e) {
                    MOut.G().println("start stunnel Failed");
                    e.printStackTrace();
                }
            } else {
                try {
                    absolutePath = path + executeSource;
                    absolutePath = absolutePath.concat(" ");
                    absolutePath = absolutePath.concat(path + "stunnel.conf");
                    File file = new File(absolutePath);
                    String cmd = file.toString();
                    process = Runtime.getRuntime().exec(cmd);
                    if (showProgress) {
                        System.out.print(".");
                    }
                    Thread.sleep(4000L);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (isSingleStunnelInstance) {
            int pid = StunnelUtility.getPIDinLinux(path, executeSource);
            if (pid == -1) {
                String filePath = "";
                String configPath = path + "stunnel.conf";
                filePath = path + executeSource;
                File stunnelExeFile = new File(filePath);
                stunnelExeFile.setExecutable(true);
                File file = new File(filePath + " " + configPath);
                String cmd = file.toString();
                try {
                    process = Runtime.getRuntime().exec(cmd);
                    process.waitFor();
                }
                catch (Exception e) {
                    MOut.G().println("start stunnel Failed");
                    e.printStackTrace();
                }
            } else {
                BufferedReader bufferedReader = null;
                try {
                    ProcessBuilder builder = new ProcessBuilder("pkill", "-HUP", executeSource);
                    builder.redirectErrorStream(true);
                    InputStream inputStream = null;
                    process = builder.start();
                    process.waitFor();
                    inputStream = process.getInputStream();
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    String str = "";
                    while ((str = bufferedReader.readLine()) != null) {
                        if (str.indexOf("Operation not permitted") > -1) {
                            MOut.G().println("Please type sudo before operation.");
                            continue;
                        }
                        MOut.G().println(str);
                    }
                }
                catch (Exception e) {
                    MOut.G().println("reload stunnel Failed");
                }
                finally {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        } else {
            try {
                absolutePath = path + executeSource;
                File stunnelExeFile = new File(absolutePath);
                stunnelExeFile.setExecutable(true);
                absolutePath = absolutePath.concat(" ");
                absolutePath = absolutePath.concat(path + "stunnel.conf");
                File file = new File(absolutePath);
                String cmd = file.toString();
                process = Runtime.getRuntime().exec(cmd);
                if (showProgress) {
                    System.out.print(".");
                }
                Thread.sleep(4000L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doCreateTempFile(FileInputStream paramInputStream, File paramFile, String tempFilePath) {
        if (paramInputStream == null) {
            MOut.G().println("Unable to duplicate null stream");
            return;
        }
        FileChannel srcChannel = paramInputStream.getChannel();
        RandomAccessFile destFile = null;
        FileChannel destChannel = null;
        FileLock destLock = null;
        if (!paramFile.exists()) {
            try {
                destFile = new RandomAccessFile(paramFile, "rw");
                destChannel = destFile.getChannel();
                destLock = destChannel.lock();
                File isExit = new File(tempFilePath);
                if (isExit.exists() && isExit.length() > 0L) {
                } else {
                    StunnelUtility.copyFileChannels(srcChannel, destChannel);
                }
            }
            catch (IOException e) {
                MOut.G().println("CreateTempFile Failed " + e);
            }
            finally {
                try {
                    if (destLock != null) {
                        destLock.release();
                    }
                }
                catch (Exception e) {
                    MOut.G().println(e.getMessage());
                }
                try {
                    if (destChannel != null) {
                        destChannel.close();
                    }
                }
                catch (Exception e) {
                    MOut.G().println(e.getMessage());
                }
                try {
                    if (srcChannel != null) {
                        srcChannel.close();
                    }
                }
                catch (Exception e) {
                    MOut.G().println(e.getMessage());
                }
                try {
                    paramInputStream.close();
                }
                catch (Exception e) {
                    MOut.G().println(e.getMessage());
                }
            }
        }
    }

    public static void doCreateTempFile(InputStream src, File TempFile) {
        FileOutputStream out = null;
        byte[] temp = new byte[0x400000];
        try {
            int rc;
            out = new FileOutputStream(TempFile);
            while ((rc = src.read(temp)) > 0) {
                out.write(temp, 0, rc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (src != null) {
                src.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            TempFile.deleteOnExit();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
    }

    protected static void copyFileChannels(FileChannel src, FileChannel dest) throws IOException {
        long count;
        long size = src.size();
        int s_byteBuffer = 10240;
        for (long pos = 0L; pos < size; pos += dest.transferFrom(src, pos, count)) {
            count = size - pos > (long)s_byteBuffer ? (long)s_byteBuffer : size - pos;
        }
    }

    public static int getRandomConnectPort() {
        long startTime = System.currentTimeMillis();
        int port = (int)(Math.random() * 15536.0 + 50000.0);
        while (StunnelUtility.isPortUsed(port)) {
            port = (int)(Math.random() * 15536.0 + 50000.0);
            long endTime = System.currentTimeMillis();
            if ((endTime - startTime) / 1000L <= 5L) continue;
            port = 49999;
            break;
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isPortUsed(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        boolean result = true;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            result = false;
            return result;
        }
        catch (IOException e) {
            result = true;
            return result;
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPIDinLinux(String path, String executeSource) {
        int pid = -1;
        InputStream inputStream = null;
        InputStream inputStreamP2 = null;
        OutputStream outputStream = null;
        try {
            Process p1 = Runtime.getRuntime().exec(new String[]{"ps", "-ef"});
            inputStream = p1.getInputStream();
            Process p2 = Runtime.getRuntime().exec(new String[]{"grep", path + executeSource});
            outputStream = p2.getOutputStream();
            StunnelUtility.copy(inputStream, outputStream);
            inputStreamP2 = p2.getInputStream();
            List<String> result = StunnelUtility.readLines(inputStreamP2);
            String output = "";
            String[] splitOutput = null;
            for (int i = 0; i < result.size(); ++i) {
                if (result.get(i).indexOf("grep") >= 0) continue;
                output = result.get(i);
                output = output.replaceAll("\\s{1,}", " ").trim();
                splitOutput = output.split(" ");
                pid = Integer.parseInt(splitOutput[1]);
            }
        }
        catch (Exception e) {
            MOut.G().println("get PID Failed");
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (inputStreamP2 != null) {
                    inputStreamP2.close();
                }
            }
            catch (IOException iOException) {}
        }
        return pid;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = StunnelUtility.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static List<String> readLines(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        return StunnelUtility.readLines(reader);
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        reader.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isHostStillConnectByJPS(String stunnelPort) {
        File bundleJRe;
        File jre = new File("jre");
        String jps = "jps.exe";
        if (jre.isDirectory() && (bundleJRe = new File(".\\jre\\bin\\jps.exe")).exists()) {
            jps = ".\\jre\\bin\\jps.exe";
        }
        ProcessBuilder builder = new ProcessBuilder(jps, "-lm");
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            Process process = builder.start();
            process.waitFor();
            inputStream = process.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String str = "";
            while ((str = bufferedReader.readLine()) != null) {
                if (str.indexOf(KVMJAR) <= -1 && str.indexOf(SCJAR) <= -1 && str.indexOf(KOJAR) <= -1 && str.indexOf(KVMSSLJAR) <= -1) continue;
                String[] splitStr = str.split(" ");
                if (stunnelPort.equals(splitStr[6])) {
                    bufferedReader.close();
                    boolean bl = true;
                    return bl;
                }
                if (!stunnelPort.equals(splitStr[7])) continue;
                bufferedReader.close();
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            MOut.G().println("Warning: jps not support");
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isHostStillConnectByTaskList(String stunnelPort) {
        InputStream inputStream = null;
        InputStream inputStreamP2 = null;
        OutputStream outputStream = null;
        try {
            Process p1 = Runtime.getRuntime().exec(new String[]{"tasklist", "/v"});
            inputStream = p1.getInputStream();
            Process p2 = Runtime.getRuntime().exec(new String[]{"findstr", "java"});
            outputStream = p2.getOutputStream();
            StunnelUtility.copy(inputStream, outputStream);
            inputStreamP2 = p2.getInputStream();
            List<String> result = StunnelUtility.readLines(inputStreamP2);
            String output = "";
            for (int i = 0; i < result.size(); ++i) {
                output = result.get(i);
                if ((output = output.replaceAll("\\s{1,}", " ").trim()).indexOf(KVM) <= -1 && output.indexOf(SC) <= -1 && output.indexOf(KO) <= -1 || output.indexOf(stunnelPort) <= -1) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            MOut.G().println("Warning: tasklist not support");
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inputStreamP2 != null) {
                    inputStreamP2.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isHostStillConnectInLinux(String path, String stunnelPort) {
        String port = "";
        InputStream inputStream = null;
        InputStream inputStreamP2 = null;
        OutputStream outputStream = null;
        try {
            Process p1 = Runtime.getRuntime().exec(new String[]{"ps", "-ef"});
            inputStream = p1.getInputStream();
            Process p2 = Runtime.getRuntime().exec(new String[]{"grep", "java"});
            outputStream = p2.getOutputStream();
            StunnelUtility.copy(inputStream, outputStream);
            inputStreamP2 = p2.getInputStream();
            List<String> result = StunnelUtility.readLines(inputStreamP2);
            String output = "";
            String[] splitOutput = null;
            int index = 0;
            for (int i = 0; i < result.size(); ++i) {
                index = result.get(i).indexOf(KVMJAR);
                if (index <= -1 && (index = result.get(i).indexOf(SCJAR)) <= -1 && (index = result.get(i).indexOf(KOJAR)) <= -1 && (index = result.get(i).indexOf(KVMSSLJAR)) <= -1) continue;
                output = result.get(i);
                output = output.replaceAll("\\s{1,}", " ").trim();
                splitOutput = (output = output.substring(index).trim()).split(" ");
                port = splitOutput[4];
                if (!stunnelPort.equals(port)) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            MOut.G().println("ps -ef | grep java failure");
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inputStreamP2 != null) {
                    inputStreamP2.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static InetAddress getFirstNonLoopbackAddress(boolean preferIpv4, boolean preferIPv6) throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    return addr;
                }
                if (!(addr instanceof Inet6Address) || preferIpv4) continue;
                return addr;
            }
        }
        return null;
    }

    public static String checkOS() {
        return System.getProperty("os.name") + ":" + System.getProperty("os.arch");
    }

    public static boolean isIPv6(String ip) {
        try {
            InetAddress localInetAddress = InetAddress.getByName(ip);
            if (localInetAddress instanceof Inet6Address) {
                return true;
            }
        }
        catch (Exception e) {
            MOut.G().println("parse ip format fail");
        }
        return false;
    }

    public static String getJarPath(Class myClass) {
        String jarDir = "";
        try {
            CodeSource codeSource = myClass.getProtectionDomain().getCodeSource();
            File jarFile = new File(codeSource.getLocation().toURI().getPath());
            jarDir = jarFile.getParentFile().getPath();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return jarDir;
    }

    public static int getStunnelVerOnPowerBoard(IPMIInterface IPMIInterface2) throws Exception {
        int CAMode = 0;
        IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(null);
        ipmiOEMPortServiceCommand.setIPMIInterface(IPMIInterface2);
        int stunnelVer = ipmiOEMPortServiceCommand.checkStunenelVer();
        switch (stunnelVer) {
            case 7: 
            case 9: {
                CAMode = 2;
                break;
            }
            default: {
                CAMode = 1;
            }
        }
        return CAMode;
    }

    public static String getTmpDir() {
        String tempDIR = System.getProperty("java.io.tmpdir");
        if (!File.separator.equals(tempDIR.substring(tempDIR.length() - 1, tempDIR.length()))) {
            tempDIR = tempDIR + File.separator;
        }
        return tempDIR;
    }

    static void deleteDir(File file) {
        boolean result;
        File[] contents;
        if (showProgress) {
            System.out.print(".");
        }
        if ((contents = file.listFiles()) != null) {
            for (File f : contents) {
                StunnelUtility.deleteDir(f);
            }
        }
        if (!(result = file.delete())) {
            // empty if block
        }
    }

    public static void stopStunnel(String stunnelFolder) {
        block18: {
            if (showProgress) {
                System.out.print(".");
            }
            String tmp = StunnelUtility.getTmpDir();
            String stunnelFolderDir = tmp + stunnelFolder;
            File file = new File(stunnelFolderDir);
            String OS = StunnelUtility.checkOS();
            String stunnel = "stunnel.exe";
            if (OS.indexOf("Windows") > -1) {
                File stunnelFile;
                stunnel = "stunnel.exe";
                if (file.exists() && (stunnelFile = new File(stunnelFolderDir + stunnel)).exists()) {
                    String execCmd = stunnelFolderDir + stunnel + " -exit -quiet";
                    try {
                        if (showProgress) {
                            System.out.print(".");
                        }
                        Process process = Runtime.getRuntime().exec(execCmd);
                        Thread.sleep(1000L);
                        StunnelUtility.deleteDir(file);
                        if (file.exists()) {
                            process = Runtime.getRuntime().exec(execCmd);
                            Thread.sleep(1000L);
                            StunnelUtility.deleteDir(file);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                stunnel = OS.toLowerCase().indexOf("mac") > -1 ? "stunnel" : (OS.indexOf("64") > -1 ? "stunnel64" : "stunnel32");
                try {
                    Process process;
                    ProcessBuilder builder;
                    File stunnelFile;
                    if (!file.exists() || !(stunnelFile = new File(stunnelFolderDir + stunnel)).exists()) break block18;
                    try {
                        builder = new ProcessBuilder("pkill", "-f", stunnelFolderDir + stunnel);
                        builder.redirectErrorStream(true);
                        process = builder.start();
                        process.waitFor();
                        if (showProgress) {
                            System.out.print(".");
                        }
                        Thread.sleep(1000L);
                        StunnelUtility.deleteDir(file);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    try {
                        if (file.exists()) {
                            builder = new ProcessBuilder("killall", stunnelFolderDir + stunnel);
                            builder.redirectErrorStream(true);
                            process = builder.start();
                            process.waitFor();
                            if (showProgress) {
                                System.out.print(".");
                            }
                            Thread.sleep(1000L);
                            StunnelUtility.deleteDir(file);
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    if (file.exists()) {
                        System.out.println("1. Please install 'killall' command for stopping stunnel correctly.");
                        System.out.println("2. Make sure you have the right to kill process and delete files.");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVMStatus(StunnelParameters parameters, IPMIInterfaceConfig config, int stunnelVer, KVMUser user) {
        File jre;
        String ip = "";
        String kvmPort = "5900";
        String stunnleFolder = null;
        List<Integer> portList = null;
        if (parameters != null) {
            ip = parameters.getStunnelIP();
            stunnleFolder = parameters.getStunnelFolder();
            portList = parameters.getSturnnlPortList();
        } else {
            ip = config.getIp();
        }
        String status = "";
        String id = "";
        String pw = "";
        if (user != null) {
            id = user.getUsername();
            pw = user.getPassword();
        } else {
            id = config.getUserName().trim();
            pw = config.getPassword().trim();
        }
        String vmPort = "623";
        int vmType = 0;
        String kvmJar = "iKVM_precheck.jar";
        String execString = "";
        String BMCIP = config.getIp();
        if (portList != null && portList.size() > 0) {
            kvmPort = portList.get(0) + "";
        }
        if (portList != null && portList.size() > 1) {
            vmPort = portList.get(1) + "";
        }
        execString = (jre = new File("jre")).isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar " + kvmJar + " " + ip + " " + id + " " + pw + " null " + kvmPort + " " + vmPort + " " + vmType + " 0 --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer + " --getvmstatus-" : "./jre/bin/java -Djava.library.path=. -jar " + kvmJar + " " + ip + " " + id + " " + pw + " null " + kvmPort + " " + vmPort + " " + vmType + " 0 --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer + " --getvmstatus-") : "java -Djava.library.path=. -jar " + kvmJar + " " + ip + " " + id + " " + pw + " null " + kvmPort + " " + vmPort + " " + vmType + " 0 --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer + " --getvmstatus-";
        BufferedReader br = null;
        InputStreamReader isr = null;
        InputStream stdin = null;
        try {
            Process p = Runtime.getRuntime().exec(execString);
            stdin = p.getInputStream();
            isr = new InputStreamReader(stdin);
            br = new BufferedReader(isr);
            String line = null;
            int wait_timeout = 30;
            long startTime = System.currentTimeMillis();
            while ((line = br.readLine()) != null) {
                int beginIndex = line.indexOf("vmStatus:");
                if (beginIndex > -1) {
                    String string = line.substring(beginIndex + "vmStatus:".length());
                    return string;
                }
                long endTime = System.currentTimeMillis();
                if ((endTime - startTime) / 500L <= (long)wait_timeout) continue;
                String string = "";
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean preCheck(StunnelParameters parameters, IPMIInterfaceConfig config, int stunnelVer) {
        String ip = parameters.getStunnelIP();
        String id = config.getUserName().trim();
        String pw = config.getPassword().trim();
        String stunnleFolder = parameters.getStunnelFolder();
        List<Integer> portList = parameters.getSturnnlPortList();
        String vmPort = "623";
        int vmType = 0;
        String kvmJar = "iKVM_precheck.jar";
        String execString = "";
        String BMCIP = config.getIp();
        File jre = new File("jre");
        execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar " + kvmJar + " " + ip + " " + id + " " + pw + " null " + portList.get(0) + " " + vmPort + " " + vmType + " 0 --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer : "./jre/bin/java -Djava.library.path=. -jar " + kvmJar + " " + ip + " " + id + " " + pw + " null " + portList.get(0) + " " + vmPort + " " + vmType + " 0 --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer) : "java -Djava.library.path=. -jar " + kvmJar + " " + ip + " " + id + " " + pw + " null " + portList.get(0) + " " + vmPort + " " + vmType + " 0 --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer;
        BufferedReader br = null;
        try {
            long endTime;
            Process p = Runtime.getRuntime().exec(execString);
            InputStream stdin = p.getInputStream();
            InputStreamReader isr = new InputStreamReader(stdin);
            br = new BufferedReader(isr);
            String line = null;
            int wait_timeout = 10;
            long startTime = System.currentTimeMillis();
            do {
                if ((line = br.readLine()) == null) return false;
                if (line.indexOf("OK") > -1) {
                    boolean bl = true;
                    return bl;
                }
                if (line.indexOf("Fail") <= -1) continue;
                boolean bl = false;
                return bl;
            } while (((endTime = System.currentTimeMillis()) - startTime) / 1000L <= (long)wait_timeout);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEtcRelease() {
        String[] cmd = new String[]{"/bin/sh", "-c", "cat /etc/*-release"};
        BufferedReader bri = null;
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = bri.readLine()) != null) {
                if (line.contains("PRETTY_NAME")) {
                    String string = line;
                    return string;
                }
                if (line.contains("CentOS") && line.contains("6")) {
                    String string = line;
                    return string;
                }
                if (!line.contains("Red Hat") || !line.contains("6.")) continue;
                String string = line;
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bri != null) {
                    bri.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static int isaIP(String ip) {
        try {
            InetAddress localInetAddress = InetAddress.getByName(ip);
            if (localInetAddress instanceof Inet4Address) {
                return 0;
            }
            if (localInetAddress instanceof Inet6Address) {
                return 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static String testADMIN() {
        return "TEST";
    }

    public static boolean validateSELwithCertifcateTime(String selTime, int stunnelVer) {
        String start = "2016/05/19 09:44:10";
        String end = "2026/05/17 09:44:10";
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        boolean isValidateTime = true;
        switch (stunnelVer) {
            case 5: 
            case 11: 
            case 13: {
                LocalDateTime selDateTime = LocalDateTime.parse(selTime, formatter);
                LocalDateTime startDateTime = LocalDateTime.parse(start, formatter);
                LocalDateTime endDateTime = LocalDateTime.parse(end, formatter);
                if (selDateTime.isAfter(startDateTime) && selDateTime.isBefore(endDateTime)) {
                    isValidateTime = true;
                    break;
                }
                isValidateTime = false;
                System.out.println("The sel time is " + selTime + ", please correct the time or it may cause the KVM connection fail.");
                break;
            }
            case 15: {
                LocalDateTime dateTime1 = LocalDateTime.parse(selTime, formatter);
                LocalDateTime currentDateTime = LocalDateTime.now();
                Duration duration = Duration.between(dateTime1, currentDateTime);
                if (duration.toDays() < 3650L && duration.toDays() > -3650L) break;
                isValidateTime = false;
                System.out.println("The sel time is " + selTime + ", please correct the time or it may cause the KVM connection fail.");
                break;
            }
        }
        return isValidateTime;
    }

    public static void main(String[] args) {
    }
}

