/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task.mbtauto;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.task.BTaskFactory;
import com.supermicro.ipmi.task.BTaskManager;
import com.supermicro.ipmi.task.BTaskVariable;
import com.supermicro.ipmi.task.flow.TaskTarget;
import com.supermicro.ipmi.task.mbtauto.BatchCommand;
import com.supermicro.ipmi.task.mbtauto.ECOInfo;
import com.supermicro.ipmi.task.mbtauto.ECOInfoList;
import com.supermicro.ipmi.task.mbtauto.MBTConfig;
import com.supermicro.ipmi.task.mbtauto.MBTTaskFlow;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.StringTokenizer;

public class InitialTask {
    boolean isDebug = false;
    boolean isBeforeX12 = false;
    TaskTarget target;
    MBTConfig mbtConfig;
    ECOInfoList ecoInfoList;
    String bmcMACAddress;
    byte[] bmcGUID;
    String bmcBoardID;
    String bmcVer;
    String bmcProductKey;
    String bmcIP;
    ISessionController sessionController = null;
    IPMIInterfaceConfig ipmiInterfaceConfig = new IPMIInterfaceConfig();
    IPMILanCommand ipmiLanCommand;
    MOut out;

    public InitialTask(String ip, TaskTarget target, ECOInfoList ecoInfoList, MBTConfig mbtConfig) {
        this.bmcIP = ip;
        this.target = target;
        this.ecoInfoList = ecoInfoList;
        this.mbtConfig = mbtConfig;
    }

    public boolean login(BTaskVariable bTaskVariable) throws Exception {
        for (int i = 0; i < this.mbtConfig.ipmiAccounts.size(); ++i) {
            this.ipmiInterfaceConfig.setIp(this.bmcIP);
            this.ipmiInterfaceConfig.setUserName(this.mbtConfig.ipmiAccounts.get((int)i).username);
            this.ipmiInterfaceConfig.setPassword(this.mbtConfig.ipmiAccounts.get((int)i).password);
            this.ipmiInterfaceConfig.setRetry(0);
            this.ipmiInterfaceConfig.setTimeout(10);
            this.ipmiLanCommand = new IPMILanCommand(null);
            try {
                this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.ipmiInterfaceConfig, this.ipmiLanCommand);
                bTaskVariable.put("$BMC_USERNAME", this.mbtConfig.ipmiAccounts.get((int)i).username);
                bTaskVariable.put("$BMC_PASSWORD", this.mbtConfig.ipmiAccounts.get((int)i).password);
                return true;
            }
            catch (IPMIException iPMIException) {
                continue;
            }
        }
        return false;
    }

    public void logout() throws Exception {
        this.sessionController.closeSession();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doInitialTask() throws Exception {
        BTaskVariable bTaskVariable = new BTaskVariable();
        boolean isConnect = this.login(bTaskVariable);
        if (!isConnect) {
            throw new Exception("IP = " + this.bmcIP + " login failed");
        }
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiLanCommand.getIPMIInterface());
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiLanCommand.getIPMIInterface());
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiLanCommand.getIPMIInterface());
        if (!this.checkIfSupportBIOSUpdate()) {
            this.logout();
            throw new Exception("OOB is not supported");
        }
        this.bmcMACAddress = this.ipmiLanCommand.getMAC2Ex();
        this.bmcGUID = ipmiMessagingCommand.getSystemGUID();
        byte[] b = ipmiOEMCommand.getBoardModelByte();
        this.bmcBoardID = "" + ByteUtility.byteToHex(b[0]) + ByteUtility.byteToHex(b[1]);
        ECOInfo ecoInfo = this.ecoInfoList.getECOInfo(this.bmcBoardID);
        if (ecoInfo == null) {
            this.logout();
            throw new Exception("IP = " + this.bmcIP + " (" + this.bmcMACAddress + ") (" + this.bmcBoardID + ") is not in ECO list");
        }
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        this.bmcVer = deviceInfo.usingAuxiliaryFWVesion ? "" + deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2) + "." + ByteUtility.byteToHex(deviceInfo.auxiliaryFirmwareRevisionInfo[0]) : "" + deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2);
        BatchCommand batchCommand = new BatchCommand();
        try {
            batchCommand.load(ecoInfo.script);
        }
        catch (Exception e) {
            this.logout();
            throw new Exception("IP = " + this.bmcIP + " (boardID = " + this.bmcBoardID + ") load command " + ecoInfo.script + " error");
        }
        this.isBeforeX12 = IPMIMessagingCommand.isBeforeX12(this.bmcGUID);
        if (batchCommand.isContainsActivateKey()) {
            Result result;
            if (this.isBeforeX12) {
                result = this.getProductKey(this.mbtConfig.productKeyServer, this.mbtConfig.productKeyUsername, this.mbtConfig.productKeyPassword, "1", this.bmcMACAddress, this.mbtConfig.productKeyId == null ? "NA" : this.mbtConfig.productKeyId, 1, "MBT Auto");
                if (result.code != 0) {
                    this.logout();
                    throw new Exception("Get Product Key error");
                }
                this.bmcProductKey = result.result;
            } else {
                result = this.getHSMProductKey(this.mbtConfig.productKeyServer, this.mbtConfig.productKeyUsername, this.mbtConfig.productKeyPassword, this.mbtConfig.productKeyId, this.bmcMACAddress, ecoInfo.getLicenseType());
                if (result.code >= 200 && result.code <= 210) {
                    this.bmcProductKey = result.result;
                } else {
                    this.logout();
                    throw new Exception("Get Product Key error: " + result.code + ", " + result.result);
                }
            }
        }
        this.logout();
        this.target.ip = this.bmcIP;
        this.target.mac = this.bmcMACAddress;
        String flashBMCCommand = "";
        String flashBIOSCommand = "";
        if (this.isBeforeX12 && !IPMIMessagingCommand.isB12RoTHW1GUID(this.bmcGUID)) {
            if (IPMIMessagingCommand.isAMIX9GUID(this.bmcGUID)) {
                flashBMCCommand = "flashr";
            } else if (IPMIMessagingCommand.isATENGUID(this.bmcGUID)) {
                flashBMCCommand = "flashh";
            } else if (IPMIMessagingCommand.isATENAspeedGUID(this.bmcGUID) || IPMIMessagingCommand.isMicroBladeCMMGUID(this.bmcGUID) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(this.bmcGUID) || IPMIMessagingCommand.isMicroBladeNodeGUID(this.bmcGUID) || IPMIMessagingCommand.isATENSuperBladeGUID(this.bmcGUID) || IPMIMessagingCommand.isSAS3_946E90GUID(this.bmcGUID) || IPMIMessagingCommand.isAST2400GUID(this.bmcGUID) || IPMIMessagingCommand.isAST2500GUID(this.bmcGUID) || IPMIMessagingCommand.isH11GUID(this.bmcGUID) || IPMIMessagingCommand.isP8DTUGUID(this.bmcGUID) || IPMIMessagingCommand.isPOWER9GUID(this.bmcGUID) || IPMIMessagingCommand.is8USuperBladeGUID(this.bmcGUID) || IPMIMessagingCommand.isAST2500HW1GUID(this.bmcGUID) || IPMIMessagingCommand.isH12GUID(this.bmcGUID) || IPMIMessagingCommand.isNuvotonGUID(this.bmcGUID) || IPMIMessagingCommand.isX11RotGUID(this.bmcGUID) || IPMIMessagingCommand.isJBOF2500GUID(this.bmcGUID) || IPMIMessagingCommand.isJBOD2500GUID(this.bmcGUID)) {
                flashBMCCommand = "flasha";
            }
            flashBIOSCommand = "update";
        } else {
            flashBMCCommand = "flashrf";
            flashBIOSCommand = "rfupdate";
        }
        bTaskVariable.put("$IP_ADDRESS", this.bmcIP);
        bTaskVariable.put("$MAC_ADDRESS", this.bmcMACAddress);
        bTaskVariable.put("$BOARD_ID", this.bmcBoardID);
        bTaskVariable.put("$PRODUCT_KEY", this.bmcProductKey);
        bTaskVariable.put("$BIOS_FILE_NAME", ecoInfo.biosFile);
        bTaskVariable.put("$BMC_FILE_NAME", ecoInfo.bmcFile);
        bTaskVariable.put("$CPLD_FILE_NAME", ecoInfo.cpldFile);
        bTaskVariable.put("$BMC_VER_1", this.bmcVer);
        bTaskVariable.put("$BMC_FLASH_CMD", flashBMCCommand);
        bTaskVariable.put("$BIOS_FLASH_CMD", flashBIOSCommand);
        bTaskVariable.put("$BMC_ECO_NUMBER", ecoInfo.ecoNumber);
        bTaskVariable.put("$BMC_ECO_NOTE", ecoInfo.note);
        MBTTaskFlow taskflow = null;
        taskflow = this.mbtConfig.applyUniquePassword() ? BTaskFactory.createMBTTaskFlow(this.bmcIP, batchCommand.toStringArray(), this.mbtConfig.ipmiAccounts) : BTaskFactory.createMBTTaskFlow(this.bmcIP, this.ipmiInterfaceConfig.getUserName(), this.ipmiInterfaceConfig.getPassword(), batchCommand.toStringArray());
        BTaskManager.getInstance().putBTaskVariable(taskflow.taskID, bTaskVariable);
        BTaskManager.getInstance().execute(taskflow);
        this.target.setTaskID(taskflow.taskID);
    }

    public boolean checkIfSupportBIOSUpdate() {
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiLanCommand.getIPMIInterface());
        try {
            return ipmiX9BIOSOEMCommand.checkIfSupportBIOSUpdate();
        }
        catch (IPMIException ex) {
            return false;
        }
    }

    public Result getProductKey(String host, String username, String password, String productID, String macAddr, String invoice, int requestType, String note) throws Exception {
        Socket s = new Socket(host, 8801);
        InputStreamReader from_server = new InputStreamReader(s.getInputStream());
        PrintWriter to_server = new PrintWriter(s.getOutputStream());
        char[] buffer = new char[1024];
        String command = "100~" + productID + "~" + username + "~" + password + "~" + macAddr + "~" + requestType + "~" + invoice + "~" + note + "~none";
        to_server.print(command + "\n");
        to_server.flush();
        int chars_read = from_server.read(buffer);
        if (chars_read < 0) {
            System.out.println("Server read fail.");
        }
        Result r = new Result();
        r.fromRaw(new String(buffer));
        s.close();
        return r;
    }

    public Result getHSMProductKey(String url, String username, String password, String productKeyId, String macAddr, int licenseType) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setUserName(username);
        config.setPassword(password);
        config.setRetry(0);
        config.setTimeout(10);
        Result result = new Result();
        String newURL = this.getFullServerUrl(url, username, password, macAddr, productKeyId, licenseType);
        BasicAuthClient bc = new BasicAuthClient(config);
        try {
            result.code = bc.send_https_get(newURL);
            result.result = bc.getResponseString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private String getFullServerUrl(String url, String username, String password, String macAddr, String productKeyId, int licenseType) {
        String newURL = url;
        if (!newURL.startsWith("https://")) {
            newURL = "https://" + newURL;
        }
        if (!newURL.contains("/hsm/") && !newURL.contains("/oob/")) {
            if (licenseType >= 0) {
                if (licenseType == 0) {
                    newURL = newURL + "/oob/";
                } else if (licenseType == 1) {
                    newURL = newURL + "/dcms/6/";
                } else if (licenseType == 2) {
                    newURL = newURL + "/hsm/1/";
                } else if (licenseType == 3) {
                    newURL = newURL + "/hsm/2/";
                }
            } else {
                newURL = newURL + "/hsm/1/";
            }
        }
        newURL = newURL + macAddr;
        if (username != null && username.equals("1") && password != null && password.equals("2")) {
            url = url + "?invoice=" + productKeyId;
        }
        return newURL;
    }

    class Result {
        public int code;
        public String result;

        Result() {
        }

        public void fromRaw(String data) throws Exception {
            StringTokenizer st = new StringTokenizer(data, "~");
            this.code = Integer.parseInt(st.nextToken());
            this.result = st.nextToken().trim();
        }
    }
}

