/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task.mbtauto;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.task.BTaskFlow;
import com.supermicro.ipmi.task.BTaskManager;
import com.supermicro.ipmi.task.BTaskVariable;
import com.supermicro.ipmi.task.flow.TaskTarget;
import com.supermicro.ipmi.task.flow.TaskTargetWorkingList;
import com.supermicro.ipmi.task.mbtauto.ECOInfoList;
import com.supermicro.ipmi.task.mbtauto.InitialTask;
import com.supermicro.ipmi.task.mbtauto.MBScanner;
import com.supermicro.ipmi.task.mbtauto.MBTConfig;
import com.supermicro.ipmi.text.MOut;
import java.io.File;
import java.io.FileWriter;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;

public class MBTAutomation
implements Observer {
    boolean isDebug = true;
    TaskTargetWorkingList taskTargetWorkingList = new TaskTargetWorkingList();
    ECOInfoList ecoInfoList;
    MBScanner mbScanner;
    MBTConfig mbtConfig;
    String startIP;
    String endIP;
    boolean isStart = false;
    private static MBTAutomation instance = new MBTAutomation();
    String foundString = "";
    String formatTemplate = "%-34s | %-7s | %-4s | %-14s | %-14s | %-8s | %-7s | %-7s | %-7s | %-7s | %-7s | %-10s | %-15s \n";

    private MBTAutomation() {
    }

    public static MBTAutomation getInstance() {
        return instance;
    }

    public void init(String startIP, String endIP, String mbtConfigFilename) throws Exception {
        this.startIP = startIP;
        this.endIP = endIP;
        this.mbtConfig = new MBTConfig();
        this.mbtConfig.load(mbtConfigFilename);
        this.ecoInfoList = new ECOInfoList();
        this.ecoInfoList.load(this.mbtConfig.ecoPath);
    }

    public void go() {
        if (!this.checkLANValid()) {
            return;
        }
        this.mbScanner = new MBScanner(this.startIP, this.endIP, "255.255.255.0");
        this.mbScanner.addObserver(this);
        this.mbScanner.startScan();
        this.isStart = true;
    }

    public void stop() {
        this.mbScanner.stopScan();
        this.isStart = false;
    }

    public boolean isStarted() {
        return this.isStart;
    }

    public String getFoundString() {
        return this.foundString;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.mbtConfig.applyUniquePassword() && !this.mbtConfig.loadMappingTable()) {
            System.out.println("[WARNING]: Load mapping table failed. Wait for next scanning");
            return;
        }
        this.foundString = "";
        Iterator iterator = this.mbScanner.foundDevice.keySet().iterator();
        while (iterator.hasNext()) {
            this.foundString = this.foundString + (String)iterator.next() + "\n";
        }
        this.foundString = this.foundString + this.mbScanner.foundDevice.keySet().size() + " Devices (" + ByteUtility.getTimeString() + " Updated) (LoopCount: " + this.mbScanner.getCount() + ")";
        for (String ip : this.mbScanner.foundDevice.keySet()) {
            byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(ip, 2, 0);
            if (guid == null) continue;
            if (this.mbtConfig.applyUniquePassword() && !this.mbtConfig.setIPMIAccount(ip)) {
                System.out.println("[WARNING]: Set password failed, so we postpone this device(" + ip + ") until next scanning.");
                continue;
            }
            String mac = "";
            try {
                mac = this.getMACAddress(ip);
            }
            catch (Exception e1) {
                if (!this.isDebug) continue;
                System.out.println(e1.getMessage());
                continue;
            }
            String ipMac = ip + "-" + mac;
            if (this.taskTargetWorkingList.isContain(ipMac)) continue;
            try {
                TaskTarget taskTarget = new TaskTarget(ip);
                InitialTask initialTask = new InitialTask(ip, taskTarget, this.ecoInfoList, this.mbtConfig);
                initialTask.doInitialTask();
                this.taskTargetWorkingList.putTaskTarget(ipMac, taskTarget);
            }
            catch (Exception e) {
                if (!this.isDebug) continue;
                System.out.println(e.getMessage());
            }
        }
        String[] workingListKeys = this.taskTargetWorkingList.getKey();
        for (int i = 0; i < workingListKeys.length; ++i) {
            TaskTarget aTaskTarget = this.taskTargetWorkingList.getTaskTarget(workingListKeys[i]);
            if (!this.mbScanner.foundDevice.containsKey(aTaskTarget.ip)) {
                ++aTaskTarget.removeCount;
                if (System.currentTimeMillis() - aTaskTarget.aliveTimestamp <= 1200000L) continue;
                BTaskManager.getInstance().removeBTask(aTaskTarget.taskID);
                this.taskTargetWorkingList.removeTaskTarget(workingListKeys[i]);
                System.out.println(aTaskTarget.ip + "(" + aTaskTarget.mac + ") removed in the taskList (Automatically removed by checking process)");
                continue;
            }
            aTaskTarget.removeCount = 0;
            aTaskTarget.aliveTimestamp = System.currentTimeMillis();
        }
    }

    public TaskTargetWorkingList getTaskTargetWorkingList() {
        return this.taskTargetWorkingList;
    }

    public MBScanner getMBScanner() {
        return this.mbScanner;
    }

    public void writeWorkingListLog(String key) throws Exception {
        FileWriter fw;
        String logFilename = this.mbtConfig.ecoPath + ByteUtility.getDateShortString() + File.separator + ByteUtility.getDateShortString() + ".txt";
        File file = new File(logFilename);
        File path = file.getParentFile();
        if (!path.exists()) {
            path.mkdirs();
        }
        if (file.exists()) {
            fw = new FileWriter(logFilename, true);
        } else {
            fw = new FileWriter(logFilename, false);
            fw.append(this.getWorkingListHeaderString());
        }
        fw.append(this.getWorkingListContentString(key));
        fw.close();
    }

    public String getWorkingListHeaderString() {
        StringBuffer formatedString = new StringBuffer();
        formatedString.append(String.format(this.formatTemplate, "IP-MAC", "BoardID", "T-ID", "Start", "End", "Elapsed", "Status", "BMC_1", "BMC_2", "BIOS_1", "BIOS_2", "ECO#", "Progress"));
        formatedString.append(String.format(this.formatTemplate, "------", "-------", "----", "-----", "---", "-------", "------", "-----", "-----", "------", "------", "----", "--------"));
        return formatedString.toString();
    }

    public String getWorkingListContentString(String key) {
        StringBuffer formatedString = new StringBuffer();
        TaskTarget taskTarget = this.taskTargetWorkingList.getTaskTarget(key);
        BTaskFlow taskFlow = (BTaskFlow)BTaskManager.getInstance().getBTask(taskTarget.taskID);
        BTaskVariable taskVariable = BTaskManager.getInstance().getBTaskVariable(taskTarget.taskID);
        SimpleDateFormat f = new SimpleDateFormat("MM/dd HH:mm:ss");
        String startTime = taskFlow.startTime != 0L ? f.format(new Date(taskFlow.startTime)) : "";
        String endTime = taskFlow.endTime != 0L ? f.format(new Date(taskFlow.endTime)) : "";
        String elapse = "";
        if (taskFlow.endTime != 0L) {
            elapse = MBTAutomation.printTimeString(taskFlow.endTime - taskFlow.startTime);
        } else if (taskFlow.startTime != 0L) {
            elapse = MBTAutomation.printTimeString(Calendar.getInstance().getTime().getTime() - taskFlow.startTime);
        }
        formatedString.append(String.format(this.formatTemplate, key + "(" + taskTarget.removeCount + ")", taskVariable.get("$BOARD_ID"), taskFlow.taskID, startTime, endTime, elapse, taskFlow.getStateString(), taskVariable.get("$BMC_VER_1") == null ? "" : taskVariable.get("$BMC_VER_1"), taskVariable.get("$BMC_VER_2") == null ? "" : taskVariable.get("$BMC_VER_2"), taskVariable.get("$BIOS_VER_1") == null ? "" : taskVariable.get("$BIOS_VER_1"), taskVariable.get("$BIOS_VER_2") == null ? "" : taskVariable.get("$BIOS_VER_2"), taskVariable.get("$BMC_ECO_NUMBER") == null ? "" : taskVariable.get("$BMC_ECO_NUMBER"), taskFlow.getShortCommandString()));
        return formatedString.toString();
    }

    public static String printTimeString(long diffMillis) {
        long diffDays = diffMillis / 86400000L;
        long leftHours = diffMillis % 86400000L / 3600000L;
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        return "" + (leftHours >= 10L ? Long.valueOf(leftHours) : "0" + leftHours) + ":" + (leftMins >= 10L ? Long.valueOf(leftMins) : "0" + leftMins) + ":" + (leftSecs >= 10L ? Long.valueOf(leftSecs) : "0" + leftSecs);
    }

    public String getWorkingListStatusDisplay() {
        String[] ipList = this.taskTargetWorkingList.getKey();
        if (ipList.length == 0) {
            return "Empty";
        }
        StringBuffer formatedString = new StringBuffer();
        if (this.isStart) {
            formatedString.append("Status: started\n");
        } else {
            formatedString.append("Status: stop\n");
        }
        formatedString.append(this.getWorkingListHeaderString());
        for (int i = 0; i < ipList.length; ++i) {
            formatedString.append(this.getWorkingListContentString(ipList[i]));
        }
        return formatedString.toString();
    }

    public boolean checkLANValid() {
        try {
            ArrayList<String> list = this.allAddress(this.startIP, this.endIP, "255.255.255.0");
            if (list.size() == 0) {
                MOut.G().println("No IP found");
                return false;
            }
        }
        catch (Exception e) {
            MOut.G().println(e.getMessage());
            return false;
        }
        return true;
    }

    public String getMACAddress(String ip) throws Exception {
        ISessionController sessionController = null;
        String bmcMACAddress = "";
        IPMIInterfaceConfig ipmiInterfaceConfig = new IPMIInterfaceConfig();
        for (int i = 0; i < this.mbtConfig.ipmiAccounts.size(); ++i) {
            ipmiInterfaceConfig.setIp(ip);
            ipmiInterfaceConfig.setUserName(this.mbtConfig.ipmiAccounts.get((int)i).username);
            ipmiInterfaceConfig.setPassword(this.mbtConfig.ipmiAccounts.get((int)i).password);
            ipmiInterfaceConfig.setRetry(0);
            ipmiInterfaceConfig.setTimeout(3);
            IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
            try {
                sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(ipmiInterfaceConfig, ipmiLanCommand);
                bmcMACAddress = ipmiLanCommand.getMAC2Ex();
                break;
            }
            catch (IPMIException ex) {
                continue;
            }
        }
        if (sessionController != null) {
            sessionController.closeSession();
            return bmcMACAddress;
        }
        throw new Exception("Cannot login to " + ip);
    }

    public ArrayList<String> allAddress(String startIP, String endIP, String netmask) throws Exception {
        if (!IPMILanCommand.isIPAddress(startIP)) {
            throw new Exception("Start IP format error!");
        }
        if (!IPMILanCommand.isIPAddress(endIP)) {
            throw new Exception("End IP format error!");
        }
        if (!IPMILanCommand.isIPAddress(netmask)) {
            throw new Exception("NetMask format error!");
        }
        ArrayList<String> list = new ArrayList<String>();
        InetAddress startInet = InetAddress.getByName(startIP);
        InetAddress endInet = InetAddress.getByName(endIP);
        InetAddress maskInet = InetAddress.getByName(netmask);
        if ((startInet.hashCode() & maskInet.hashCode()) != (endInet.hashCode() & maskInet.hashCode())) {
            throw new Exception("Start IP and End IP must locate within same network segment");
        }
        for (int i = startInet.hashCode(); i <= endInet.hashCode(); ++i) {
            list.add((String)((Object)Integer.valueOf(i)));
        }
        return list;
    }

    public static void main(String[] args) {
    }
}

