/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task.mbtauto;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Stream;

public class MBTConfig {
    public String ecoPath;
    public String macMappingFile;
    public String productKeyServer;
    public String productKeyUsername;
    public String productKeyPassword;
    public String productKeyId;
    public ArrayList<IPMIAccount> ipmiDefaultAccounts = new ArrayList();
    public ArrayList<IPMIAccount> ipmiAccounts = new ArrayList();
    private boolean isUniquePassword = false;
    private boolean isUniquePasswordFromFile = false;
    private Map<String, String> macTableMap = new HashMap<String, String>();
    private Map<String, String> pwdTableMap = new HashMap<String, String>();
    private String pwdMappingFile;
    private String pwd3rdServer;
    private String pwdServerURL;
    public static final int MAPPING_TABLE_MAC = 0;
    public static final int MAPPING_TABLE_PWD = 1;
    private final String PASSWORD_TOKEN_NAME = "DefPasswd";
    private final String PASSWORD_QUERY_URL = "https://wcfds.supermicro.com:33330/prnstd006/IpmiMacVerif.svc/IpmiMacInfo/TrgtMac=";
    private final String REQUEST_SUCCESS = "The request has been successfully processed.";

    public void load(String filename) throws Exception {
        String propertyFileContents = "";
        String line = "";
        BufferedReader in = new BufferedReader(new FileReader(filename));
        while ((line = in.readLine()) != null) {
            propertyFileContents = propertyFileContents + line + "\n";
        }
        Properties p = new Properties();
        StringReader stReader = new StringReader(propertyFileContents.replace("\\", "\\\\"));
        p.load(stReader);
        stReader.close();
        this.ecoPath = p.getProperty("ecoPath");
        this.macMappingFile = p.getProperty("macFile");
        this.productKeyServer = p.getProperty("productKeyServer");
        this.productKeyUsername = p.getProperty("productKeyUsername");
        this.productKeyPassword = p.getProperty("productKeyPassword");
        this.productKeyId = p.getProperty("productKeyId");
        this.pwdMappingFile = p.getProperty("uniquePasswordFile");
        this.pwd3rdServer = p.getProperty("uniquePasswordServer");
        String account = p.getProperty("ipmiAccount");
        if (null == this.macMappingFile || this.macMappingFile.isEmpty()) {
            this.isUniquePassword = false;
            this.loadDefaultPassword(account, true);
        } else {
            this.isUniquePassword = true;
            this.checkPasswordSource();
            this.loadDefaultPassword(account, false);
        }
        in.close();
        if (this.isUniquePassword && !this.checkFileExists(this.macMappingFile)) {
            throw new Exception(this.macMappingFile + " is not exist !");
        }
        if (this.isUniquePasswordFromFile && !this.checkFileExists(this.pwdMappingFile)) {
            throw new Exception(this.pwdMappingFile + " is not exist !");
        }
        File eFile = new File(this.ecoPath);
        if (!eFile.isDirectory()) {
            throw new Exception(this.ecoPath + " is not exist !");
        }
    }

    public boolean applyUniquePassword() {
        return this.isUniquePassword;
    }

    public boolean setIPMIAccount(String ip) {
        try {
            String password = null;
            String mac = this.macTableMap.get(ip);
            if (mac == null) {
                System.out.println("[WARNING]: Cannot find the MAC which IP is " + ip);
                return false;
            }
            if (this.isUniquePasswordFromFile) {
                Set<String> keySet = this.pwdTableMap.keySet();
                for (String key : keySet) {
                    if (!mac.equalsIgnoreCase(key)) continue;
                    password = this.pwdTableMap.get(key);
                    break;
                }
            } else {
                String xmlBody = this.queryXML(mac);
                if (xmlBody == null || !xmlBody.contains("The request has been successfully processed.")) {
                    System.out.println("[ERROR]: The XML is invalid. XML: " + xmlBody + ", MAC: " + mac);
                    return false;
                }
                password = this.getTokenValue(xmlBody, "DefPasswd");
            }
            if (password == null || password.isEmpty()) {
                System.out.println("[ERROR]: The password is invalid. Password: " + password + ", MAC: " + mac);
                System.out.println("IP: " + ip);
                if (this.pwdTableMap != null && this.pwdTableMap.size() > 0) {
                    this.pwdTableMap.forEach((k, v) -> System.out.println(k + "," + v));
                } else if (this.pwdTableMap == null) {
                    System.out.println("pwdTableMap == null");
                } else {
                    System.out.println("pwdTableMap size: " + this.pwdTableMap.size());
                }
                return false;
            }
            this.setIPMIPassword(password);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadMappingTable() {
        try {
            if (this.isUniquePassword) {
                this.loadMappingTable(0);
            }
            if (this.isUniquePasswordFromFile) {
                this.loadMappingTable(1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void loadDefaultPassword(String passwordSet, boolean onlyDefaultPwd) {
        StringTokenizer st = new StringTokenizer(passwordSet, ";");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            String t1 = t.substring(0, t.indexOf("/"));
            String t2 = t.substring(t.indexOf("/") + 1, t.length());
            IPMIAccount ipmiAccount = new IPMIAccount(t1.trim(), t2.trim());
            this.ipmiDefaultAccounts.add(ipmiAccount);
        }
        if (onlyDefaultPwd) {
            this.ipmiAccounts.addAll(this.ipmiDefaultAccounts);
        }
    }

    private void loadMappingTable(int type) throws IOException {
        String keySuffix;
        String keyPrefix;
        Map<String, String> mTable;
        String file;
        if (type == 0) {
            file = this.macMappingFile;
            mTable = this.macTableMap;
            keyPrefix = "IP=";
            keySuffix = "mac=";
        } else if (type == 1) {
            file = this.pwdMappingFile;
            mTable = this.pwdTableMap;
            keyPrefix = "mac=";
            keySuffix = "PWD=";
        } else {
            throw new IOException("[ERROR]: Not related mapping table: " + type + "\n");
        }
        if (null == file) {
            throw new IOException("[ERROR]: Not config the path of file.\n");
        }
        File mFile = new File(file);
        if (!mFile.exists()) {
            throw new IOException("[ERROR]: The following file does not exist.\n" + file + "\n");
        }
        mTable.clear();
        Path path = Paths.get(file, new String[0]);
        try (Stream<String> linesStream = Files.lines(path);){
            linesStream.forEach(line -> {
                String regex = ",";
                String[] strSet = line.split(",");
                if (strSet.length > 1) {
                    String key = strSet[0].substring(keyPrefix.length());
                    String value = strSet[1].substring(keySuffix.length()).trim();
                    mTable.put(key, value);
                }
            });
        }
    }

    private void checkPasswordSource() {
        this.isUniquePasswordFromFile = false;
        if (this.pwd3rdServer != null && !this.pwd3rdServer.isEmpty()) {
            this.pwdServerURL = this.pwd3rdServer;
        } else if (this.pwdMappingFile != null && !this.pwdMappingFile.isEmpty()) {
            this.isUniquePasswordFromFile = true;
        } else {
            this.pwdServerURL = "https://wcfds.supermicro.com:33330/prnstd006/IpmiMacVerif.svc/IpmiMacInfo/TrgtMac=";
        }
    }

    private String queryXML(String mac) throws IOException {
        HttpURLConnection httpClient = (HttpURLConnection)new URL(this.pwdServerURL + mac).openConnection();
        httpClient.setRequestMethod("GET");
        httpClient.setRequestProperty("User-Agent", "Mozilla/5.0");
        if (httpClient.getResponseCode() == 200) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(httpClient.getInputStream()));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                String string = response.toString();
                return string;
            }
        }
        throw new IOException("[ERROR]: Connection failed, response code: " + httpClient.getResponseCode() + "\n");
    }

    private String getTokenValue(String xmlBody, String tokenName) {
        String tokenBegin = "<" + tokenName + ">";
        String tokenEnd = "</" + tokenName + ">";
        int valueBeginIdx = xmlBody.lastIndexOf(tokenBegin) + tokenBegin.length();
        int valueEndIdx = xmlBody.lastIndexOf(tokenEnd);
        return xmlBody.substring(valueBeginIdx, valueEndIdx);
    }

    private boolean checkFileExists(String filename) {
        File file = new File(filename);
        return file.exists();
    }

    private void setIPMIPassword(String password) {
        this.ipmiAccounts.clear();
        this.ipmiAccounts.add(new IPMIAccount("ADMIN", password));
        this.ipmiAccounts.addAll(this.ipmiDefaultAccounts);
    }

    public String toString() {
        String result = "";
        result = result + "ecoPath             = " + this.macMappingFile + "\n";
        result = result + "macFile             = " + this.ecoPath + "\n";
        result = result + "productKeyServer    = " + this.productKeyServer + "\n";
        result = result + "productKeyUsername  = " + this.productKeyUsername + "\n";
        result = result + "productKeyPassword  = " + this.productKeyPassword + "\n";
        result = result + "ipmiAccount         = " + this.ipmiAccounts.toString() + "\n";
        return result;
    }

    public static void main(String[] args) throws Exception {
        MBTConfig mbtConfig = new MBTConfig();
        mbtConfig.load("c:\\mbt.ini");
        System.out.println(mbtConfig.toString());
    }

    public class IPMIAccount {
        String username;
        String password;
        static final String DEFAULT_USERNAME = "ADMIN";

        public IPMIAccount(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public String toString() {
            return this.username + "/" + this.password + " ";
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

