/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;

public class AMIX9KVMCommand
extends SuperBladeCommand {
    public AMIX9KVMCommand() {
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isAMIX9Supported()) {
            this.printUnavailableMessage();
            this.statusCode = 153;
            return;
        }
        boolean result = GraphicsEnvironment.isHeadless();
        if (result) {
            MOut.G(this).print("No graphic environment here !");
            this.statusCode = 149;
            return;
        }
        File f = new File("JViewerX9.jar");
        if (!f.exists()) {
            MOut.G(this).println("Cannot find JViewerX9.jar");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).print("Starting JViewer (X9) Process...");
        File jre = new File("jre");
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar JViewerX9.jar " + this.config.getIp() + " " + this.config.getUserName() + " " + this.config.getPassword() : "./jre/bin/java -Djava.library.path=. -jar JViewerX9.jar " + this.config.getIp() + " " + this.config.getUserName() + " " + this.config.getPassword()) : "java -Djava.library.path=. -jar JViewerX9.jar " + this.config.getIp() + " " + this.config.getUserName() + " " + this.config.getPassword();
        try {
            Process process = Runtime.getRuntime().exec(execString);
        }
        catch (IOException ex) {
            this.statusCode = 149;
            MOut.G(this).println(" Failed");
            return;
        }
        this.statusCode = 0;
        MOut.G(this).println("Done");
        MOut.G(this).println("Please wait for JViewer (X9) window");
    }

    public void printUnavailableMessage() {
        MOut.G(this).println("This function is unavailable for this device.");
    }

    public boolean isAMIX9Supported() {
        boolean result = false;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            result = false;
        } else if (IPMIMessagingCommand.isAMIX9GUID(guid) || IPMIMessagingCommand.isAMIAspeedGUID(guid)) {
            result = true;
        }
        return result;
    }
}

