/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.stunnel.StunnelParameterBuilder;
import com.supermicro.ipmi.stunnel.StunnelParameters;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.ipmi.text.SuperBladeTool;
import dyorgio.runtime.out.process.RunnableSerializable;
import dyorgio.runtime.run.as.root.RootExecutor;
import dyorgio.runtime.run.as.root.UserCanceledException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import tw.com.aten.bean.InfoRepository;
import tw.com.aten.vstorage.VirtualStorage;

public class ATENKVMCommand
extends SuperBladeCommand {
    boolean isSkipElevate = false;

    public ATENKVMCommand() {
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        boolean isForceStunnelVer11 = false;
        if (this.parameters != null && this.parameters.length > 0 && "-skipElevate".equalsIgnoreCase(this.parameters[0].trim())) {
            this.isSkipElevate = true;
        }
        int vmType = 0;
        String ip = this.config.getIp();
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isATENGUID(guid) || IPMIMessagingCommand.isMicroBladeNodeGUID(guid) || IPMIMessagingCommand.isATENSuperBladeGUID(guid) || IPMIMessagingCommand.isCMMGUID(guid) || IPMIMessagingCommand.isSIMBL(guid) || IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) || IPMIMessagingCommand.isOSAGUID(guid) || IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid) || IPMIMessagingCommand.isAMIAspeedGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || IPMIMessagingCommand.isCB3GUID(guid) || IPMIMessagingCommand.isRenesasATENGUID(guid)) {
            vmType = 2;
        }
        if (!this.isATENKVMSupported()) {
            this.printUnavailableMessage();
            this.statusCode = 156;
            return;
        }
        boolean result = GraphicsEnvironment.isHeadless();
        if (result) {
            MOut.G(this).println("No graphic environment here !");
            this.statusCode = 149;
            return;
        }
        IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(null);
        ipmiOEMPortServiceCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        int stunnelVer = 0;
        try {
            stunnelVer = ipmiOEMPortServiceCommand.getPort((byte)15);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isForceStunnelVer11 || stunnelVer > 0) {
            IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
            ipmiSELCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            String selTime = ipmiSELCommand.getSELTimeWithFormat();
            StunnelUtility.validateSELwithCertifcateTime(selTime, stunnelVer);
            StunnelParameters parameters = null;
            if (isForceStunnelVer11) {
                stunnelVer = 11;
            }
            if (stunnelVer == 13) {
                stunnelVer = 11;
            }
            MOut.G(this).println("This device support stunnel.");
            try {
                parameters = StunnelParameterBuilder.run(stunnelVer, ip, ipmiOEMPortServiceCommand, guid, this.config.getUserName(), this.config.getPassword());
                if (parameters == null) {
                    this.statusCode = 149;
                    return;
                }
                if (parameters.getUser() != null && parameters.getUser().isKVMSessionConnected()) {
                    this.statusCode = 149;
                    return;
                }
            }
            catch (Exception e) {
                MOut.G(this).println(e.getMessage());
                this.statusCode = 149;
                return;
            }
            try {
                if (stunnelVer == 5) {
                    StunnelUtility.configAndStartStunnel(parameters, this.ipmiCMMOEMCommand.getIPMIInterface(), parameters.getCAMode());
                    InfoRepository infoRepository = InfoRepository.createInfoRepository(parameters.getStunnelIP(), this.config.getUserName(), this.config.getPassword(), parameters.getSturnnlPortList().get(0), 623);
                    if (!VirtualStorage.loadLibraryAndValidateUser(stunnelVer, infoRepository)) {
                        StunnelUtility.stopStunnel(parameters.getStunnelFolder());
                        stunnelVer = 11;
                        parameters = StunnelParameterBuilder.run(stunnelVer, ip, ipmiOEMPortServiceCommand, guid, this.config.getUserName(), this.config.getPassword());
                        StunnelUtility.configAndStartStunnel(parameters, this.ipmiCMMOEMCommand.getIPMIInterface(), parameters.getCAMode());
                    }
                } else {
                    StunnelUtility.configAndStartStunnel(parameters, this.ipmiCMMOEMCommand.getIPMIInterface(), parameters.getCAMode());
                }
            }
            catch (Exception e) {
                MOut.G(this).println("Config stunnel or start stunnel fail ");
                this.statusCode = 149;
                return;
            }
            try {
                String userName = this.config.getUserName();
                String password = this.config.getPassword();
                if (parameters.getUser() != null) {
                    userName = parameters.getUser().getUsername();
                    password = parameters.getUser().getPassword();
                }
                this.startKVM(vmType, parameters.getSturnnlPortList(), parameters.getStunnelIP(), userName, password, parameters.getBMCIP(), parameters.getStunnelFolder(), stunnelVer);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.statusCode = 149;
                return;
            }
        }
        String port = "5900";
        try {
            port = String.valueOf(ipmiOEMPortServiceCommand.getPort((byte)2));
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
        ip = this.config.getIp();
        this.startKVM(vmType, port, ip, this.config.getUserName(), this.config.getPassword());
    }

    public void printUnavailableMessage() {
        MOut.G(this).println("This function is unavailable for this device.");
    }

    public boolean isATENKVMSupported() {
        boolean result = true;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            result = false;
        } else if (IPMIMessagingCommand.isCMMGUID(guid) || IPMIMessagingCommand.isSIMBL(guid) || IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) || IPMIMessagingCommand.isOSAGUID(guid) || IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid) || IPMIMessagingCommand.isAMIX9GUID(guid) || IPMIMessagingCommand.isAMIAspeedGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || IPMIMessagingCommand.isCB3GUID(guid) || IPMIMessagingCommand.isRenesasATENGUID(guid)) {
            result = false;
        }
        return result;
    }

    public void startKVM(int vmType, String port, String ip, String id, String pw) {
        MOut.G(this).print("Starting iKVM Process...");
        File jre = new File("jre");
        try {
            String tmpPath = StunnelUtility.getTmpDir();
            FileWriter fw = new FileWriter(tmpPath + ip + ".temp");
            fw.write("ID: " + id + "\n");
            fw.write("Password: " + pw + "\n");
            fw.write("Port: " + port + "\n");
            fw.write("Vm: " + vmType + "\n");
            fw.close();
        }
        catch (IOException tmpPath) {
            // empty catch block
        }
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar iKVM.jar " + ip + " " + id + " " + pw + " null " + port + " 623 " + vmType + " 0" : "./jre/bin/java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR") : (System.getProperty("os.name").indexOf("Windows") >= 0 ? "java -Djava.library.path=. -jar iKVM.jar " + ip + " " + id + " " + pw + " null " + port + " 623 " + vmType + " 0" : "java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR");
        try {
            Runtime.getRuntime().exec(execString);
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed " + ex);
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        MOut.G(this).println("Please wait for iKVM window");
        this.statusCode = 0;
    }

    public void startKVM(int vmType, List<Integer> portList, String ip, String id, String pw, String BMCIP, String stunnleFolder, int stunnelVer) {
        File f;
        String kvmJar = "iKVM.jar";
        if (stunnelVer >= 9) {
            kvmJar = "iKVM_ssl.jar";
        }
        if (!(f = new File(kvmJar)).exists()) {
            MOut.G(this).println("Cannot find " + kvmJar);
            this.statusCode = 149;
            return;
        }
        MOut.G(this).print("Starting iKVM Process...");
        File jre = new File("jre");
        String execString = "";
        int vmPort = 623;
        if (portList.size() > 1) {
            vmPort = portList.get(1);
        }
        try {
            String tmpPath = StunnelUtility.getTmpDir();
            FileWriter fw = new FileWriter(tmpPath + BMCIP + ".temp");
            fw.write("ID: " + id + "\n");
            fw.write("Password: " + pw + "\n");
            fw.write("Port: " + portList.get(0) + "\n");
            fw.write("Vm: " + vmType + "\n");
            fw.write("Vm_port: " + vmPort + "\n");
            fw.write("Version: " + stunnelVer + "\n");
            fw.close();
        }
        catch (IOException e) {
            this.statusCode = 149;
        }
        execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar " + kvmJar + " " + ip + " " + id + " " + pw + " null " + portList.get(0) + " " + vmPort + " " + vmType + " 0 --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer : "./jre/bin/java -Djava.library.path=. -jar " + kvmJar + " " + ip + " 0 0 --FR --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder) : (System.getProperty("os.name").indexOf("Windows") >= 0 ? "java -Djava.library.path=. -jar " + kvmJar + " " + ip + " " + id + " " + pw + " null " + portList.get(0) + " " + vmPort + " " + vmType + " 0 --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder + " --stunnelVer-" + stunnelVer : "java -Djava.library.path=. -jar " + kvmJar + " " + ip + " 0 0 --FR --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder);
        try {
            if (System.getProperty("os.name").indexOf("Windows") >= 0 && !this.isSkipElevate) {
                String executeString = execString;
                RootExecutor rootExecutor = new RootExecutor(new String[0]);
                rootExecutor.run((RunnableSerializable & Serializable)() -> {
                    try {
                        Runtime.getRuntime().exec(executeString);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            } else {
                Runtime.getRuntime().exec(execString);
            }
        }
        catch (UserCanceledException e) {
            MOut.G(this).println("Please accept the UAC of java or run as administrator to launch " + SuperBladeTool.softwareName + ".");
            this.statusCode = 149;
            return;
        }
        catch (Exception e) {
            this.statusCode = 149;
            MOut.G(this).println(e.getMessage());
            return;
        }
        MOut.G(this).println("Done");
        MOut.G(this).println("Please wait for iKVM window");
        this.statusCode = 0;
    }
}

