/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class AllBladeStatusCommand
extends SuperBladeCommand {
    public AllBladeStatusCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid)) {
            IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
            ipmiMicroBladeOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            StringBuffer sb = new StringBuffer();
            int bladePresentCount = 0;
            for (int i = 0; i < 28; ++i) {
                BladeRemoteInfo bladeRemoteInfo = ipmiMicroBladeOEMCommand.getBladeRemoteInfo((byte)i);
                NodeStatusInfo nodeStatusInfo = ipmiMicroBladeOEMCommand.getNodeStatus((byte)i, (byte)0);
                if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) continue;
                ++bladePresentCount;
                NodeSensorInfo nodeSensorInfo = ipmiMicroBladeOEMCommand.getNodeSensor((byte)i, (byte)0);
                sb.append(nodeSensorInfo.to7UStatusFormatedString());
            }
            if (bladePresentCount > 0) {
                MOut.G(this).print("Blade Module (" + bladePresentCount + "/" + 20 + ")\n");
                MOut.G(this).print("--------------------\n");
                NodeSensorInfo nodeSensorInfo = ipmiMicroBladeOEMCommand.getNodeSensor((byte)0, (byte)0);
                MOut.G(this).print(nodeSensorInfo.to7UStatusFormatedHeader());
                MOut.G(this).print(sb.toString());
            }
            this.statusCode = 0;
            return;
        }
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.setIsQueryBladeMiscEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        MOut.G(this).println(bladeSystem.toBladeFormatedString());
        this.statusCode = 0;
    }
}

