/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.text.BIOSAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.io.File;

public class BIOSImageVerCommand
extends BIOSAbstractCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("BIOS filename is needed");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        String filename = this.parameters[0];
        this.ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        File biosFile = new File(filename);
        if (!biosFile.isFile()) {
            MOut.G(this).println("BIOS filename is not exist");
            return;
        }
        try {
            this.biosFileInfo = this.ipmiX9BIOSOEMCommand.checkBIOSImage(filename, this.ipmiX9BIOSOEMCommand.isX9Q());
            if (this.biosFileInfo != null) {
                MOut.G(this).println(this.biosFileInfo.toStringFromBIOSImage());
                byte[] boardIDfromBMC = ipmiOEMCommand.getProductID();
                if (boardIDfromBMC[0] != this.biosFileInfo.boardID[0] || boardIDfromBMC[1] != this.biosFileInfo.boardID[1]) {
                    String fileBIOSID = ByteUtility.bytesToHex(this.biosFileInfo.boardID);
                    String bmcBIOSID = ByteUtility.bytesToHex(boardIDfromBMC);
                    System.out.println("Board ID mismatch (" + fileBIOSID + ")(" + bmcBIOSID + ")");
                }
                this.statusCode = 0;
            } else {
                MOut.G(this).println(filename + " is not a valid BIOS file");
                this.statusCode = 147;
            }
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
        }
    }
}

