/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.text.BIOSAbstractCommand;
import com.supermicro.ipmi.text.LicenseManager;
import com.supermicro.ipmi.text.MOut;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class BIOSSetKeyCommand
extends BIOSAbstractCommand {
    private String inputKey = null;

    private void resetInputKey() {
        this.inputKey = null;
    }

    public void usage() {
        MOut.G(this).println("Node Product Key file:    Standard JSON");
        MOut.G(this).println("");
        MOut.G(this).println("Node Product Key format:  ****-****-****-****-****-****");
        MOut.G(this).println("Example:                  4F15-1F39-BEB3-0EA5-2C14-41CF");
    }

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("Node product key or key file is required");
            MOut.G(this).println("");
            this.usage();
            return false;
        }
        if (this.checkFileExists(this.parameters[0])) {
            try {
                this.inputKey = String.join((CharSequence)"", Files.readAllLines(Paths.get(this.parameters[0], new String[0])));
            }
            catch (IOException e) {
                MOut.G(this).println("Read Node Product Key file failed.");
                return false;
            }
        } else {
            this.inputKey = this.parameters[0];
        }
        if (this.inputKey.contains("\\\"")) {
            this.inputKey = this.inputKey.replaceAll("\\\\\"", "\"");
        }
        if (!ByteUtility.validateKeyFormat(this.inputKey) && !ByteUtility.validateHSMKeyFormat(this.inputKey)) {
            MOut.G(this).println("Invalid Node product key format");
            MOut.G(this).println("");
            this.usage();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runCommand() throws Exception {
        if (this.checkIfSystemLockdown()) {
            return;
        }
        boolean result = false;
        LicenseManager manager = new LicenseManager(this.ipmiCMMOEMCommand.getIPMIInterface(), this.config);
        try {
            result = manager.activateLicense(this.inputKey);
        }
        catch (Exception ex) {
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL != 0) {
                ex.printStackTrace();
            }
        }
        finally {
            this.resetInputKey();
        }
        if (result) {
            MOut.G(this).println("Node product key activated");
            this.statusCode = 0;
        } else {
            MOut.G(this).println("Invalid Node product key");
            this.statusCode = 149;
        }
    }

    private boolean checkFileExists(String filePath) {
        File tempFile = new File(filePath);
        return tempFile != null && tempFile.exists();
    }
}

