/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeBMCIPMBCommand
extends SuperBladeCommand {
    boolean isMicroBlade = false;

    public BladeBMCIPMBCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public boolean preValidate() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid) || IPMIMessagingCommand.isMicroBladeCMMAST2600GUID(guid)) {
            this.isMicroBlade = true;
            int maxBladeSize = this.getBladeMaxSize();
            return true;
        }
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.G(this).println("blade Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] data;
        byte cmd;
        byte netfn;
        if (this.isMicroBlade) {
            byte[] data2;
            byte cmd2;
            byte netfn2;
            int bIndex_int;
            IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
            ipmiMicroBladeOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            String bladeIndex = (String)this.preParameters.get(1);
            byte bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndex);
            try {
                bIndex_int = Integer.parseInt(bladeIndex, 16);
                netfn2 = (byte)Integer.parseInt(this.parameters[0], 16);
                cmd2 = (byte)Integer.parseInt(this.parameters[1], 16);
                int dataSize = this.parameters.length - 2;
                data2 = new byte[dataSize];
                for (int i = 0; i < dataSize; ++i) {
                    data2[i] = (byte)Integer.parseInt(this.parameters[2 + i], 16);
                }
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println(ex.getMessage());
                this.statusCode = 147;
                return;
            }
            BladeRemoteInfo bladeRemoteInfo = ipmiMicroBladeOEMCommand.getBladeRemoteInfo(bIndex);
            NodeStatusInfo nodeStatusInfo = ipmiMicroBladeOEMCommand.getNodeStatus(bIndex, (byte)0);
            if (nodeStatusInfo.initialized() && bladeRemoteInfo.isPresent()) {
                byte[] result = ipmiMicroBladeOEMCommand.sendNodeIPMB((byte)bIndex_int, (byte)1, netfn2, cmd2, data2);
                if (result != null) {
                    for (int i = 0; i < result.length; ++i) {
                        MOut.G(this).print(ByteUtility.byteToHex(result[i]) + " ");
                    }
                }
            } else {
                MOut.G(this).println("Blade " + bladeIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
            MOut.G(this).println("");
            this.statusCode = 0;
            return;
        }
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.G(this).println("Blade " + bladeIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        if (!bladeEntity.isSimCardDetectPin()) {
            MOut.G(this).println("BMC Not Installed");
            this.statusCode = 149;
            return;
        }
        if (this.parameters == null || this.parameters.length < 2) {
            MOut.G(this).println("<netFn> <cmd> [data] parameters required");
            this.statusCode = 147;
            return;
        }
        IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        this.ipmiCMMOEMCommand.setIPMIInterface(ipmb);
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        ipmb.setChannel(index);
        try {
            netfn = (byte)Integer.parseInt(this.parameters[0], 16);
            cmd = (byte)Integer.parseInt(this.parameters[1], 16);
            int dataSize = this.parameters.length - 2;
            data = new byte[dataSize];
            for (int i = 0; i < dataSize; ++i) {
                data[i] = (byte)Integer.parseInt(this.parameters[2 + i], 16);
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        IPMIMessage ipmiMessage = new IPMIMessage();
        netfn = (byte)(netfn << 2);
        ipmiMessage.setCommandAndData(netfn, cmd, data);
        IPMIMessage resMessage = this.ipmiCMMOEMCommand.getIPMIInterface().send(ipmiMessage);
        if (resMessage != null) {
            MOut.G(this).println("Completion code = " + ByteUtility.byteToHex(resMessage.completionCode) + "h");
            if (resMessage.completionCode != 0) {
                MOut.G(this).println("(" + GlobalDefine.getCompletionCodeString(resMessage.completionCode) + ")");
                this.statusCode = 149;
            }
            if (resMessage.data != null) {
                if (resMessage.data.length != 0) {
                    MOut.G(this).println("Return data = " + ByteUtility.bytesToHex(resMessage.data));
                }
                this.statusCode = 0;
            } else {
                this.statusCode = 149;
            }
        } else {
            this.statusCode = 149;
        }
    }
}

