/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class FailureCommand
extends SuperBladeCommand {
    public FailureCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        ArrayList failures = bladeSystem.getFailures();
        if (failures.size() == 0) {
            MOut.G(this).println("no failure");
        }
        for (int i = 0; i < failures.size(); ++i) {
            FailureEntity f = (FailureEntity)failures.get(i);
            String desc = f.getSource() + ", " + f.getFailureItem() + ":" + f.getFailureDetail();
            MOut.G(this).println(desc);
        }
        this.statusCode = 0;
    }
}

