/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class GBRestartCommand
extends SuperBladeCommand {
    public GBRestartCommand() {
        super.setMasterCheckingRequired(true);
    }

    @Override
    public boolean preValidate() {
        byte gbIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (gbIndex < 1 || gbIndex > 4) {
            MOut.G(this).println("Gigabit switch Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        byte gbIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isGigabitPresent(gbIndex)) {
            MOut.G(this).println("Gigabit Switch " + gbIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        try {
            boolean result = this.ipmiCMMOEMCommand.setGBRestart(gbIndex);
            if (result) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        }
        catch (IPMIException ex) {
            MOut.G(this).println("Set GB restart failed");
            this.statusCode = 149;
        }
    }
}

