/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIDeleteSDRCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        ipmiSDRCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters != null && this.parameters.length == 1) {
            int recordID;
            if (this.checkIfSystemLockdown()) {
                return;
            }
            boolean result = false;
            try {
                recordID = Integer.parseInt(this.parameters[0], 10);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println(ex.getMessage());
                this.statusCode = 147;
                return;
            }
            byte[] recordIDBytes = new byte[2];
            ByteUtility.intTo2Bytes(recordIDBytes, 0, recordID);
            byte[] reservationID = ipmiSDRCommand.getSDRReservationID();
            if (reservationID == null) {
                MOut.G(this).println("Get reservation ID error");
                this.statusCode = 149;
                return;
            }
            IPMIMessage resMessage = ipmiSDRCommand.deleteSDRCommand(reservationID, recordIDBytes);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    result = true;
                } else {
                    MOut.G(this).println(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                    result = false;
                }
            }
            if (result) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        } else {
            MOut.G(this).println("<SDR recordID> parameters required.");
            MOut.G(this).println("Command \"ipmi sensor\" shows recordID");
            this.statusCode = 147;
            return;
        }
    }
}

