/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishHttpUtils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class IPMIOEMADServerCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private byte authentication;
    private byte ssl;
    private byte[] port;
    private byte[] timeout;
    private byte[] userDomainName;
    private ServerAddress address1 = new ServerAddress(1);
    private ServerAddress address2 = new ServerAddress(2);
    private ServerAddress address3 = new ServerAddress(3);
    private List<ServerAddress> addressList = new ArrayList<ServerAddress>();

    @Override
    public boolean preValidate() {
        int tempTimeout;
        int tempPort;
        String usage = "Usage: ipmi oem x10cfg ad server <authentication> <SSL> <port> <time out> <user domain name> <domain controller server address1> <domain controller server address2> <domain controller server address3> \n\nFor authentication:\nOn  : 1\nOff : 0\nFor SSL:\nOn  : 1\nOff : 0\n* When SSL is on, port number should be 636 or 3269; Off, port number should be 389 or 3268";
        if (this.parameters == null || this.parameters.length != 8) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.authentication = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("authentication should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if (this.authentication < 0 || this.authentication > 1) {
            MOut.G(this).println("authentication should be 0 or 1");
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.ssl = Byte.parseByte(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("ssl should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if (this.ssl < 0 || this.ssl > 1) {
            MOut.G(this).println("ssl should be 0 or 1");
            MOut.G(this).println(usage);
            return false;
        }
        try {
            tempPort = Integer.parseInt(this.parameters[2]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("port should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if (this.ssl == 1) {
            if (tempPort != 636 && tempPort != 3269) {
                MOut.G(this).println("port should be 636 or 3269");
                MOut.G(this).println(usage);
                return false;
            }
        } else if (tempPort != 389 && tempPort != 3268) {
            MOut.G(this).println("port should be 389 or 3268");
            MOut.G(this).println(usage);
            return false;
        }
        this.port = new byte[2];
        ByteUtility.intTo2Bytes(this.port, 0, tempPort);
        try {
            tempTimeout = Integer.parseInt(this.parameters[3]);
            if (tempTimeout < 0 || tempTimeout > 65535) {
                MOut.G(this).println("Time out is out of range");
                MOut.G(this).println(usage);
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("time out should be number");
            MOut.G(this).println(usage);
            return false;
        }
        this.timeout = new byte[2];
        ByteUtility.intTo2Bytes(this.timeout, 0, tempTimeout);
        this.userDomainName = this.parameters[4].getBytes();
        Pattern special = Pattern.compile("[,;&'\"<>\\\\=$|^?*~`()\\[\\]\\{\\}#%!]");
        if (special.matcher(this.parameters[4]).matches()) {
            MOut.G(this).println("Invalid domain name");
            return false;
        }
        Pattern pattern = Pattern.compile("^([a-zA-Z0-9]([a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,24}$");
        if (!pattern.matcher(this.parameters[4]).matches()) {
            MOut.G(this).println("Invalid domain name");
            return false;
        }
        if (this.userDomainName.length > 63) {
            MOut.G(this).println("user domain name should less then 63 characters");
            MOut.G(this).println(usage);
            return false;
        }
        this.addressList.clear();
        this.addressList.add(this.address1);
        this.addressList.add(this.address2);
        this.addressList.add(this.address3);
        for (ServerAddress addr : this.addressList) {
            if (addr.setAddress(this.parameters[5 + addr.getIndex()])) continue;
            MOut.G(this).println(addr.getErrorMsg());
            MOut.G(this).println(usage);
            this.statusCode = 147;
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte auth2;
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported ");
            this.statusCode = 153;
            return;
        }
        if (!this.isBeforeX12()) {
            MOut.G(this).println("AD command is not supported on this device, you may try redfish accountService ad command instead.");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            this.statusCode = 149;
            return;
        }
        if (this.checkIfSystemLockdown()) {
            this.statusCode = 149;
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte auth = ipmiOEMWebSettingCommand.getLdap((byte)0)[0];
        if (auth == 1) {
            MOut.G(this).println("LDAP has been enabled, please disable LDAP before enabling Active Directory");
            this.statusCode = 149;
            return;
        }
        byte[] radius = ipmiOEMWebSettingCommand.getRadius((byte)0);
        byte by = auth2 = radius != null ? radius[0] : (byte)0;
        if (radius == null) {
            MOut.G(this).println("Get Radius fail");
            this.statusCode = 149;
            return;
        }
        if (auth2 == 1) {
            MOut.G(this).println("Radius has been enabled, please disable Radius before enabling Active Directory");
            this.statusCode = 149;
            return;
        }
        ByteBuffer target = ByteBuffer.allocate(6);
        target.put(this.authentication);
        target.put(this.ssl);
        target.put(this.port);
        target.put(this.timeout);
        if (!ipmiOEMWebSettingCommand.setActiveDirectory((byte)0, target.array())) {
            MOut.G(this).println("Set AD server parameters failed");
            this.statusCode = 149;
            return;
        }
        target = ByteBuffer.allocate(this.userDomainName.length + 1);
        target.put(this.userDomainName);
        target.put((byte)0);
        if (!ipmiOEMWebSettingCommand.setActiveDirectory((byte)1, target.array())) {
            this.statusCode = 149;
            return;
        }
        if (!(this.setActiveDirectoryWithOEMCommand7(ipmiOEMWebSettingCommand) || this.setActiveDirectoryWithRedifhCommand() || this.setActiveDirectoryWithOEMCommand2(ipmiOEMWebSettingCommand))) {
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }

    private boolean setActiveDirectoryWithOEMCommand2(IPMIOEMWebSettingCommand command) throws IPMIException {
        if (this.address1.isIPv4() && this.address2.isIPv4() && this.address3.isIPv4()) {
            ByteBuffer target = ByteBuffer.allocate(this.address1.getAddressBytes().length + this.address2.getAddressBytes().length + this.address3.getAddressBytes().length);
            target.put(this.address1.getAddressBytes());
            target.put(this.address2.getAddressBytes());
            target.put(this.address3.getAddressBytes());
            if (!command.setActiveDirectory((byte)2, target.array())) {
                MOut.G(this).println("Set AD server 3 ip failed");
                return false;
            }
            return true;
        }
        MOut.G(this).println("AD command is not supported with IPv6 or domain name format on this device.");
        return false;
    }

    private boolean setActiveDirectoryWithOEMCommand7(IPMIOEMWebSettingCommand command) throws IPMIException {
        for (ServerAddress addr : this.addressList) {
            if (command.setActiveDirectory((byte)7, addr.getAddressBytesWithIndex())) continue;
            return false;
        }
        return true;
    }

    private boolean setActiveDirectoryWithRedifhCommand() throws Exception {
        String bodyString;
        BasicAuthClient bc = new BasicAuthClient(this.config);
        String url = "https://" + this.config.getIp() + "/redfish/v1/Managers/1/" + "ActiveDirectory";
        int result = bc.send_https_patch(url, bodyString = "{\"DCSAddress1\": \"" + this.address1.getAddressStr() + "\",\"DCSAddress2\": \"" + this.address2.getAddressStr() + "\",\"DCSAddress3\": \"" + this.address3.getAddressStr() + "\",\"UserDomainName\": \"" + this.parameters[4] + "\" }");
        return result >= 200 && result <= 210 || result == 302;
    }

    private class ServerAddress {
        private boolean isIPv4Type;
        private byte[] addressBytes;
        private String addressStr;
        private int index;

        public ServerAddress(int idx) {
            this.index = idx - 1;
        }

        public int getIndex() {
            return this.index;
        }

        public String getAddressStr() {
            return this.addressStr;
        }

        public byte[] getAddressBytes() {
            return this.addressBytes;
        }

        public byte[] getAddressBytesWithIndex() {
            byte[] addrBytes = this.addressStr.getBytes(StandardCharsets.UTF_8);
            ByteBuffer target = ByteBuffer.allocate(addrBytes.length + 1 + 1);
            target.put((byte)this.index);
            target.put(addrBytes);
            target.put((byte)0);
            return target.array();
        }

        public boolean setAddress(String addr) {
            block3: {
                block5: {
                    block6: {
                        block4: {
                            if (!IPMILanCommand.isIPAddress(addr)) break block4;
                            this.isIPv4Type = true;
                            break block5;
                        }
                        if (!RedfishHttpUtils.isIPv6(addr)) break block6;
                        this.isIPv4Type = false;
                        break block5;
                    }
                    if (!IPMILanCommand.isValidateDomain(addr)) break block3;
                    this.isIPv4Type = false;
                }
                try {
                    this.addressBytes = this.isIPv4Type ? ByteUtility.ipToBytes(addr) : addr.getBytes(StandardCharsets.UTF_8);
                }
                catch (NumberFormatException e) {
                    break block3;
                }
                this.addressStr = addr;
                return true;
            }
            return false;
        }

        public boolean isIPv4() {
            return this.isIPv4Type;
        }

        public String getErrorMsg() {
            return "domain controller server " + (this.index + 1) + " is a illegal IP address or domain name";
        }
    }
}

