/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.text.NetworkInterfaceHelper;
import java.util.HashMap;

public class IPMIOEMDNSModeCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private static final int UNDEFINED = -1;
    private int protocol;
    private int mode;

    @Override
    public boolean preValidate() {
        this.mode = -1;
        this.protocol = -1;
        String[] params = super.getParameters();
        if (params != null) {
            if (params.length < 2) {
                MOut.G(this).println("Insufficient parameters");
                this.usage();
                return false;
            }
            this.protocol = this.convertStrToInt(params[0]);
            this.mode = this.convertStrToInt(params[1]);
            if (this.protocol == -1 || this.mode == -1) {
                MOut.G(this).println("Invalid parameters");
                this.usage();
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        NetworkInterfaceHelper helper = new NetworkInterfaceHelper(super.getConfig());
        if (super.getParameters() == null) {
            int modeIPv4 = -1;
            int modeIPv6 = -1;
            HashMap<String, String> infoMap = null;
            try {
                infoMap = helper.fetchNetworkInterfaceInfo();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (infoMap == null) {
                MOut.G(this).println("This device is not supported");
                this.statusCode = 153;
                return;
            }
            StringBuilder builder = new StringBuilder();
            try {
                modeIPv4 = helper.isUseAutoDNS(infoMap, true) ? 0 : 1;
                MOut.G(this).println("IPv4 DNS mode: " + this.convertEnumToString(modeIPv4));
            }
            catch (Exception ex) {
                builder.append(ex.getLocalizedMessage() + System.lineSeparator());
            }
            try {
                modeIPv6 = helper.isUseAutoDNS(infoMap, false) ? 0 : 1;
                MOut.G(this).println("IPv6 DNS mode: " + this.convertEnumToString(modeIPv6));
            }
            catch (Exception ex) {
                builder.append(ex.getLocalizedMessage() + System.lineSeparator());
            }
            if (modeIPv4 >= 0 && modeIPv6 >= 0) {
                this.usage();
                this.statusCode = 0;
            } else if (modeIPv4 >= 0 || modeIPv6 >= 0) {
                MOut.G(this).println(builder.toString());
                this.statusCode = 149;
            } else {
                MOut.G(this).println("This device is not supported");
                this.statusCode = 153;
            }
        } else {
            boolean result = false;
            try {
                result = this.protocol == 0 ? helper.enableIPv4AutoDNS(this.mode == 0) : helper.enableIPv6AutoDNS(this.mode == 0);
            }
            catch (Exception ex) {
                MOut.G(this).println(ex.getLocalizedMessage());
                this.statusCode = 149;
                return;
            }
            if (result) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("This device is not supported");
                this.statusCode = 153;
            }
        }
    }

    private int convertStrToInt(String value) {
        int result = -1;
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    private String convertEnumToString(int value) {
        return 0 == value ? "Auto" : "Manually";
    }

    private void usage() {
        MOut.G(this).println("\nUsage: ipmi oem x10cfg dnsMode [<protocol> <mode>]\nProtocol:\n IPv4 : 0\n IPv6 : 1\nMode:\n auto     : 0\n manually : 1");
    }
}

