/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.DNSRedfishService;

public class IPMIOEMDNSStateCommand
extends IPMIX10OEMWebSettingAbstractCommand
implements DNSRedfishService {
    public static final byte DNS_IPV4 = 0;
    public static final byte DNS_IPV6 = 1;
    public static final byte DNS_INDEX1 = 1;
    public static final byte DNS_INDEX2 = 2;
    private byte dnsProtocol;
    private byte dnsIndex;

    @Override
    public boolean preValidate() {
        if (this.getParameters() != null) {
            if (IPMILanCommand.isIPAddress(this.getParameters()[0])) {
                this.dnsProtocol = 0;
            } else if (RedfishHttpUtils.isIPv6(this.getParameters()[0])) {
                this.dnsProtocol = 1;
            } else {
                MOut.G(this).println("Invalid IP format");
                this.printUsage();
                return false;
            }
            this.dnsIndex = 1;
            if (this.getParameters().length > 1) {
                try {
                    this.dnsIndex = Integer.valueOf(this.getParameters()[1]).byteValue();
                }
                catch (NumberFormatException e) {
                    this.dnsIndex = 0;
                }
            }
            if (this.dnsIndex < 1 || 2 < this.dnsIndex) {
                MOut.G(this).println("Invalid DNS index");
                this.printUsage();
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        block2: {
            boolean result;
            block4: {
                IPMIOEMWebSettingCommand command;
                block3: {
                    if (this.checkIfX10CFGNotSupported()) break block2;
                    command = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
                    if (this.getParameters() != null) break block3;
                    result = this.getDNSAction(command);
                    break block4;
                }
                if (this.checkIfSystemLockdown()) break block2;
                result = this.setDNSAction(command);
            }
            this.statusCode = result ? 0 : 149;
        }
    }

    private void printUsage() {
        MOut.G(this).println("Usage: ipmi oem x10cfg dns [<ip> [number]] ");
        MOut.G(this).println("IP: ");
        MOut.G(this).println(" IPv4/IPv6");
        MOut.G(this).println("Number: ");
        MOut.G(this).println(" DNS1 : 1");
        MOut.G(this).println(" DNS2 : 2");
    }

    private boolean checkIfX10CFGNotSupported() {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return true;
        }
        return false;
    }

    private String getDNS(IPMIOEMWebSettingCommand command, byte protocol, byte index) {
        String address;
        block2: {
            address = null;
            try {
                address = command.getDNS(protocol, index);
            }
            catch (IPMIException e) {
                if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL != 1) break block2;
                MOut.G(this).println(e.getMessage());
            }
        }
        return address;
    }

    private boolean getDNSAction(IPMIOEMWebSettingCommand command) {
        String dns1IPv4 = null;
        String dns1IPv6 = null;
        String dns2IPv4 = null;
        String dns2IPv6 = null;
        dns1IPv4 = this.getDNS(command, (byte)0, (byte)1);
        dns1IPv6 = this.getDNS(command, (byte)1, (byte)1);
        dns2IPv4 = this.getDNS(command, (byte)0, (byte)2);
        dns2IPv6 = this.getDNS(command, (byte)1, (byte)2);
        if (dns1IPv4 != null || dns1IPv6 != null) {
            StringBuffer output = new StringBuffer();
            String formatTemplate = " %10s: %-20s \n";
            output.append("--------------------------------------------------\n");
            output.append(String.format(formatTemplate, "IPv4 DNS1", dns1IPv4));
            if (dns2IPv4 != null) {
                output.append(String.format(formatTemplate, "DNS2", dns2IPv4));
            }
            output.append("--------------------------------------------------\n");
            output.append(String.format(formatTemplate, "IPv6 DNS1", dns1IPv6));
            if (dns2IPv6 != null) {
                output.append(String.format(formatTemplate, "DNS2", dns2IPv6));
            }
            MOut.G(this).print(output.toString());
            return true;
        }
        MOut.G(this).println("Get DNS failed");
        return false;
    }

    private boolean setDNSAction(IPMIOEMWebSettingCommand command) throws IPMIException {
        String ipAddress;
        if (this.dnsProtocol == 0) {
            if (this.isRedfishDNSIPv4AutoMode(super.getConfig())) {
                MOut.G(this).println("Unable to set DNS in IPv4 auto mode");
                return false;
            }
        } else if (this.dnsProtocol == 1) {
            if (this.isRedfishDNSIPv6AutoMode(super.getConfig())) {
                MOut.G(this).println("Unable to set DNS in IPv6 auto mode");
                return false;
            }
        } else {
            MOut.G(this).println("Undefine protocol");
            return false;
        }
        if (command.setDNS(ipAddress = this.getParameters()[0], this.dnsProtocol, this.dnsIndex)) {
            MOut.G(this).println("Done");
            return true;
        }
        MOut.G(this).println("Set DNS failed");
        return false;
    }
}

