/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.text.NTPRedfishService;

public class IPMIOEMNTPListCommand
extends IPMIX10OEMWebSettingAbstractCommand
implements NTPRedfishService {
    private static final byte NTPSetting = 0;
    private static final byte PrimaryNTP = 1;
    private static final byte SecondaryNTP = 2;

    @Override
    public void runCommand() throws Exception {
        boolean isRedfishAutoDSTSupported;
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        IPMIOEMWebSettingCommand command = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] ntpData = command.getNTPDateTime((byte)0);
        byte[] primaryData = command.getNTPDateTime((byte)1);
        byte[] secondaryData = command.getNTPDateTime((byte)2);
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        boolean isBeforeX12 = IPMIMessagingCommand.isBeforeX12(guid);
        boolean isRedfishTimeZoneNameSupported = isBeforeX12 ? false : this.isNTPRedfishTimezoneSupported(super.getConfig());
        boolean isAutoDSTSupported = isRedfishAutoDSTSupported = isBeforeX12 ? false : this.isNTPRedfishAutoDSTSupported(super.getConfig());
        boolean isAutoDSTEnabled = false;
        boolean isDSTEnabled = false;
        String timeZone = null;
        String ntpState = ntpData[0] == 0 ? "Disable" : "Enable";
        String primaryNTPServer = new String(primaryData);
        String secondaryNTPServer = new String(secondaryData);
        timeZone = isRedfishTimeZoneNameSupported ? this.getNTPRedfishTimezone(super.getConfig()) : (ntpData.length >= 7 ? "UTC " + new String(ntpData).substring(1, 6) : (ntpData.length >= 4 ? IPMIOEMWebSettingCommand.getNTPTimeZoneNameArrayList().get((ntpData[1] & 0xFF) - 1) : null));
        if (isRedfishAutoDSTSupported) {
            isAutoDSTSupported = true;
            isAutoDSTEnabled = this.isNTPRedfishAutoDSTEnabled(super.getConfig());
        } else if (ntpData.length >= 7) {
            isDSTEnabled = ntpData[6] == 1;
        } else if (ntpData.length >= 4) {
            isAutoDSTSupported = true;
            isDSTEnabled = ntpData[3] == 1;
        } else {
            isDSTEnabled = false;
        }
        StringBuilder builder = new StringBuilder();
        String formatPattern = "%-" + (isAutoDSTSupported ? "25s" : "20s") + " : %-60s" + System.lineSeparator();
        builder.append(String.format(formatPattern, "NTP State", ntpState));
        builder.append(String.format(formatPattern, "Time Zone", timeZone));
        builder.append(String.format(formatPattern, "Primary NTP Server", primaryNTPServer));
        builder.append(String.format(formatPattern, "Secondary NTP Server", secondaryNTPServer));
        builder.append(String.format(formatPattern, (isAutoDSTSupported ? "Auto " : "") + "Daylight Saving Time", isAutoDSTEnabled || isDSTEnabled ? "Yes" : "No"));
        MOut.G(this).print(builder.toString());
        this.statusCode = 0;
    }
}

