/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIOEMSetPortServiceCommand
extends SuperBladeCommand {
    public byte service;
    public int port;

    public IPMIOEMSetPortServiceCommand(int portService) {
        this.service = (byte)portService;
    }

    @Override
    public boolean preValidate() {
        block5: {
            if (this.parameters != null && this.parameters.length == 1) {
                try {
                    this.port = Integer.parseInt(this.parameters[0]);
                    if (this.port < 1 || this.port > 65535) {
                        MOut.G(this).println("port out of range");
                        return false;
                    }
                    break block5;
                }
                catch (NumberFormatException ex) {
                    MOut.G(this).println("port should be a number");
                    return false;
                }
            }
            if (this.parameters != null && this.parameters.length > 1) {
                MOut.G(this).println("Invalid parameter");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(null);
        ipmiOEMPortServiceCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters == null) {
            int port = ipmiOEMPortServiceCommand.getPort(this.service);
            MOut.G(this).println("current port: " + port);
            this.statusCode = 0;
            return;
        }
        if (this.parameters.length == 1) {
            if (this.checkIfSystemLockdown()) {
                return;
            }
            boolean result = ipmiOEMPortServiceCommand.setPort(this.service, this.port);
            if (result) {
                MOut.G(this).println("Set port service done");
                this.statusCode = 0;
            }
        }
    }
}

