/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class IPMIOEMSummary
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        byte[] bytes;
        byte ipmode;
        IPMIOEMCommand ipmiOEMCommand;
        block47: {
            ipmiOEMCommand = new IPMIOEMCommand(null);
            IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
            IPMIInterface ipmiInterface = this.ipmiCMMOEMCommand.getIPMIInterface();
            IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(ipmiInterface);
            byte[] guid = ipmiMessagingCommand.getSystemGUID();
            if (!IPMIMessagingCommand.isSupportedIPMISummary(guid)) {
                MOut.G(this).println("Not supported device for this command");
                this.statusCode = 153;
                return;
            }
            ipmiOEMCommand.setIPMIInterface(ipmiInterface);
            IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(ipmiInterface);
            ipmiLanCommand.setIPMIInterface(ipmiInterface);
            IPMII2CPMBusCommand ipmii2cPMBusCommand = new IPMII2CPMBusCommand(null);
            ipmii2cPMBusCommand.setIPMIInterface(ipmiInterface);
            ipmode = 0;
            try {
                ipmode = ipmiLanCommand.getIPProtocol();
            }
            catch (Exception exception) {
                // empty catch block
            }
            DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
            MOut.G(this).println("Summary");
            MOut.G(this).println("-------------------------------------------");
            if (ipmode == 0 || ipmode == 2) {
                MOut.G(this).println("IPv4                   : " + ipmiLanCommand.getIP());
            }
            MOut.G(this).println("BMC MAC Address        : " + ipmiLanCommand.getMAC());
            if (deviceInfo.usingAuxiliaryFWVesion) {
                StringBuilder builder = new StringBuilder();
                builder.append("Firmware Revision      : ");
                builder.append(String.format("%02d", deviceInfo.firmwareRevision1));
                builder.append(".");
                builder.append(ByteUtility.byteToHex(deviceInfo.firmwareRevision2));
                builder.append(".");
                builder.append(ByteUtility.byteToHex(deviceInfo.auxiliaryFirmwareRevisionInfo[0]));
                if (IPMIMessagingCommand.isR12OpenBMCGUID(guid) || IPMIMessagingCommand.isR12OpenBMCRoTGUID(guid) || IPMIMessagingCommand.isR13OpenBMCGUID(guid)) {
                    byte fourthNum = deviceInfo.auxiliaryFirmwareRevisionInfo[2];
                    builder.append(".");
                    builder.append(ByteUtility.byteToHex(fourthNum));
                }
                if (deviceInfo.deviceRevision == 2) {
                    builder.append(".");
                    builder.append(ByteUtility.byteToHex(deviceInfo.auxiliaryFirmwareRevisionInfo[3]));
                }
                MOut.G(this).println(builder.toString());
            } else {
                MOut.G(this).println("Firmware Revision      : " + String.format("%02d", deviceInfo.firmwareRevision1) + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2));
            }
            bytes = null;
            String s = "";
            char c = '\u0000';
            try {
                bytes = ipmiOEMCommand.getFirmwareBuild();
                if (bytes != null) {
                    s = new String(bytes);
                    c = s.toCharArray()[0];
                    if (bytes != null && c != '\u0000') {
                        MOut.G(this).println("Firmware Build Time    : " + ByteUtility.transferDateFormat(s));
                        bytes = null;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid) || IPMIMessagingCommand.isHGIMEZZGUID(guid))) {
                try {
                    bytes = ipmiOEMCommand.getBiosVer();
                    if (bytes != null) {
                        s = new String(bytes);
                        c = s.toCharArray()[0];
                    }
                    if (bytes != null && c != '\u0000') {
                        s = s.trim();
                        MOut.G(this).println("BIOS Version           : " + s);
                    }
                    if ((bytes = ipmiOEMCommand.getBiosDate()) != null) {
                        s = new String(bytes);
                        c = s.toCharArray()[0];
                    }
                    if (bytes != null && c != '\u0000') {
                        MOut.G(this).println("BIOS Build Time        : " + ByteUtility.transferDateFormatFromBiosFormat(s));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String cpld = null;
            cpld = IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.isAST2500HW1GUID(guid) || IPMIMessagingCommand.is8USuperBladeGUID(guid) || IPMIMessagingCommand.isH11GUID(guid) || IPMIMessagingCommand.isH12GUID(guid) || IPMIMessagingCommand.isNuvotonGUID(guid) || IPMIMessagingCommand.isX12GUID(guid) || IPMIMessagingCommand.isJBOF2500GUID(guid) || IPMIMessagingCommand.isJBOD2500GUID(guid) || IPMIMessagingCommand.isB3ST1GUID(guid) ? ipmii2cPMBusCommand.getPLLDversion2500() : (IPMIMessagingCommand.isX11RotGUID(guid) || IPMIMessagingCommand.isH12RoTGUID(guid) || IPMIMessagingCommand.isX12RoTGUID(guid) || IPMIMessagingCommand.isX12RoTHW1GUID(guid) || IPMIMessagingCommand.isX12RoTHW2GUID(guid) || IPMIMessagingCommand.isAST2600GUID(guid) || IPMIMessagingCommand.isAST2600HW1GUID(guid) || IPMIMessagingCommand.isB12RoTHW1GUID(guid) || IPMIMessagingCommand.isB12AST2600GUID(guid) || IPMIMessagingCommand.isX12DGOGUID(guid) || IPMIMessagingCommand.isH12SSFFGUID(guid) || IPMIMessagingCommand.isH12SSFRGUID(guid) || IPMIMessagingCommand.isB12AST2600MAC1GUID(guid) || IPMIMessagingCommand.isAST2600HW1ROT20GUID(guid) || IPMIMessagingCommand.isX12DSCGUID(guid) || IPMIMessagingCommand.isH12SSGGUID(guid) || IPMIMessagingCommand.isX12DGQGUID(guid) || IPMIMessagingCommand.isH12DSGGUID(guid) || IPMIMessagingCommand.isX13ROTGUID(guid) || IPMIMessagingCommand.isX13ROTHW1GUID(guid) || IPMIMessagingCommand.isX13ROTMAC1GUID(guid) || IPMIMessagingCommand.isX13ROT8WAYSGUID(guid) || IPMIMessagingCommand.isX12SPTGUID(guid) || IPMIMessagingCommand.isB13AST2600RoTGUID(guid) || IPMIMessagingCommand.isB14AST2600RoT20GUID(guid) || IPMIMessagingCommand.isH13ROTMAC12GUID(guid) || IPMIMessagingCommand.isH13ROTMAC34GUID(guid) || IPMIMessagingCommand.isR12OpenBMCGUID(guid) || IPMIMessagingCommand.isR12OpenBMCRoTGUID(guid) || IPMIMessagingCommand.isR13OpenBMCGUID(guid) || IPMIMessagingCommand.isX13OpenBMCHW2GUID(guid) || IPMIMessagingCommand.isH13OpenBMCHW2GUID(guid) || IPMIMessagingCommand.isAOMSCMOpenBMCLegoGUID(guid) || IPMIMessagingCommand.isX12DGUGUID(guid) || IPMIMessagingCommand.isB3SD1GUID(guid) || IPMIMessagingCommand.isB4SA1GUID(guid) || IPMIMessagingCommand.isX13DeltaNextGUID(guid) || IPMIMessagingCommand.isH13DeltaNextGUID(guid) || IPMIMessagingCommand.isH13DeltaNextHW1GUID(guid) || IPMIMessagingCommand.isH13AST2600HW1Rot20GUID(guid) || IPMIMessagingCommand.isH14AST2600ROT20HW2GUID(guid) || IPMIMessagingCommand.isX13AST2600ROT20LegoGUID(guid) || IPMIMessagingCommand.isX13AST2600RoTSBBGUID(guid) || IPMIMessagingCommand.isG1AST2600ROT20LegoGUID(guid) || IPMIMessagingCommand.isX14AST2600ROT20HW1GUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20HW2GUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20GD3GUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20DCMHSGUID(guid) || IPMIMessagingCommand.isX14AST2600RoT20MAC1GUID(guid) || IPMIMessagingCommand.isJBOF2600GUID(guid) ? ipmiOEMCommand.getRotCPLDversion() : (IPMIMessagingCommand.isX12AST2600NonRoT(guid) || IPMIMessagingCommand.isH13GUID(guid) ? ipmii2cPMBusCommand.getTatlowCPLDVersion() : (IPMIMessagingCommand.isHGIMEZZGUID(guid) ? ipmii2cPMBusCommand.getHGICarrierBoardCPLDVersion() : ipmii2cPMBusCommand.getCPLDversion())));
            if (cpld != null) {
                MOut.G(this).println("CPLD Version           : " + cpld);
            }
            if (IPMIMessagingCommand.isR12OpenBMCGUID(guid) || IPMIMessagingCommand.isR12OpenBMCRoTGUID(guid) || IPMIMessagingCommand.isR13OpenBMCGUID(guid) || IPMIMessagingCommand.isX13OpenBMCHW2GUID(guid) || IPMIMessagingCommand.isH13OpenBMCHW2GUID(guid) || IPMIMessagingCommand.isAOMSCMOpenBMCLegoGUID(guid)) {
                String version;
                block46: {
                    version = null;
                    try {
                        version = ipmiOEMCommand.getSCPVer();
                    }
                    catch (IPMIException e) {
                        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL <= 0) break block46;
                        e.printStackTrace();
                    }
                }
                if (version == null || version.equals("0.00")) {
                    RedfishHttpUtils utils = new RedfishHttpUtils();
                    String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Systems/1/";
                    try {
                        int result = utils.sendRedfishGet(this.config, url);
                        if (200 <= result && result <= 210) {
                            HashMap<String, String> map = utils.getEntry();
                            for (Map.Entry<String, String> set : map.entrySet()) {
                                if (!set.getKey().toLowerCase().contains("scpversion")) continue;
                                MOut.G(this).println("SCP Version            : " + set.getValue());
                                break block47;
                            }
                            break block47;
                        }
                        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                            RedfishHttpUtils.printFailMessage(result, utils.getRedfishResponse());
                        }
                        break block47;
                    }
                    catch (Exception e) {
                        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                            e.printStackTrace();
                        }
                        break block47;
                    }
                }
                MOut.G(this).println("SCP Version            : " + version.toLowerCase());
            }
        }
        if (ipmode == 2 || ipmode == 1) {
            try {
                LinkedList<String> ipv6List = ipmiOEMCommand.getIPv6Address();
                for (int i = 0; i < ipv6List.size(); ++i) {
                    MOut.G(this).println("IPv6                   : " + ipv6List.get(i));
                }
            }
            catch (Exception ipv6List) {
                // empty catch block
            }
        }
        byte numberFrom3021 = 0;
        try {
            numberFrom3021 = ipmiOEMCommand.getNumberOfMacBy3021();
            if (numberFrom3021 != 0) {
                bytes = ipmiOEMCommand.getSystemMACAddress();
                if (bytes != null && bytes.length > 5) {
                    MOut.G(this).println("System LAN1 MAC Address: " + ByteUtility.byteToHex(bytes[0]) + ":" + ByteUtility.byteToHex(bytes[1]) + ":" + ByteUtility.byteToHex(bytes[2]) + ":" + ByteUtility.byteToHex(bytes[3]) + ":" + ByteUtility.byteToHex(bytes[4]) + ":" + ByteUtility.byteToHex(bytes[5]));
                }
                if (numberFrom3021 > 1 && numberFrom3021 <= 4) {
                    if (bytes != null && bytes.length > 5) {
                        for (int i = 0; i < numberFrom3021 - 1; ++i) {
                            MOut.G(this).println("System LAN" + (i + 2) + " MAC Address: " + ByteUtility.byteToHex(bytes[0]) + ":" + ByteUtility.byteToHex(bytes[1]) + ":" + ByteUtility.byteToHex(bytes[2]) + ":" + ByteUtility.byteToHex(bytes[3]) + ":" + ByteUtility.byteToHex(bytes[4]) + ":" + ByteUtility.byteToHex((byte)(bytes[5] + i + 1)));
                        }
                    }
                    this.statusCode = 0;
                    return;
                }
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        try {
            int number = ipmiOEMCommand.getOtherSystemMacNumber();
            if (number > 0) {
                bytes = ipmiOEMCommand.getOtherSystemMacAddress();
            }
            if (bytes != null) {
                for (int i = 0; i < number; ++i) {
                    if (bytes.length <= i * 6 + 5) continue;
                    MOut.G(this).println("System LAN" + (numberFrom3021 + 1 + i) + " MAC Address: " + ByteUtility.byteToHex(bytes[i * 6 + 0]) + ":" + ByteUtility.byteToHex(bytes[i * 6 + 1]) + ":" + ByteUtility.byteToHex(bytes[i * 6 + 2]) + ":" + ByteUtility.byteToHex(bytes[i * 6 + 3]) + ":" + ByteUtility.byteToHex(bytes[i * 6 + 4]) + ":" + ByteUtility.byteToHex(bytes[i * 6 + 5]));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.statusCode = 0;
    }

    public String parseIPv6IP(byte[] data) {
        if ((data[2] & 0xFFFFFF80) != -128) {
            return "Disabled";
        }
        String ip = "";
        ip = ByteUtility.byteToHex(data[3]) + ByteUtility.byteToHex(data[4]) + ":" + ByteUtility.byteToHex(data[5]) + ByteUtility.byteToHex(data[6]) + ":" + ByteUtility.byteToHex(data[7]) + ByteUtility.byteToHex(data[8]) + ":" + ByteUtility.byteToHex(data[9]) + ByteUtility.byteToHex(data[10]) + ":" + ByteUtility.byteToHex(data[11]) + ByteUtility.byteToHex(data[12]) + ":" + ByteUtility.byteToHex(data[13]) + ByteUtility.byteToHex(data[14]) + ":" + ByteUtility.byteToHex(data[15]) + ByteUtility.byteToHex(data[16]) + ":" + ByteUtility.byteToHex(data[17]) + ByteUtility.byteToHex(data[18]);
        return ip;
    }

    public String parseIPv6Dynamic(byte[] data) {
        if (data[20] != 0) {
            return "Disabled";
        }
        String ip = "";
        ip = ByteUtility.byteToHex(data[3]) + ByteUtility.byteToHex(data[4]) + ":" + ByteUtility.byteToHex(data[5]) + ByteUtility.byteToHex(data[6]) + ":" + ByteUtility.byteToHex(data[7]) + ByteUtility.byteToHex(data[8]) + ":" + ByteUtility.byteToHex(data[9]) + ByteUtility.byteToHex(data[10]) + ":" + ByteUtility.byteToHex(data[11]) + ByteUtility.byteToHex(data[12]) + ":" + ByteUtility.byteToHex(data[13]) + ByteUtility.byteToHex(data[14]) + ":" + ByteUtility.byteToHex(data[15]) + ByteUtility.byteToHex(data[16]) + ":" + ByteUtility.byteToHex(data[17]) + ByteUtility.byteToHex(data[18]);
        return ip;
    }

    public int parsePrefix(byte[] data) {
        return data[19] & 0xFF;
    }
}

