/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.SystemLockdownCommand;
import com.supermicro.ipmi.text.LicenseManager;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIOEMSystemlockdownCommand
extends SuperBladeCommand {
    byte status;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("on")) {
                this.status = 1;
            } else if (this.parameters[0].equalsIgnoreCase("off")) {
                this.status = 0;
            } else {
                this.printUsage();
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        SystemLockdownCommand systemLockdownCommand = new SystemLockdownCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters == null) {
            try {
                if (systemLockdownCommand.isSystemLocked()) {
                    MOut.G(this).println("System lockdown status: On");
                } else {
                    MOut.G(this).println("System lockdown status: Off");
                }
                this.statusCode = 0;
            }
            catch (Exception e) {
                MOut.G(this).println("This device is not supported");
                this.statusCode = 153;
            }
        } else {
            LicenseManager lm = new LicenseManager(this.ipmiCMMOEMCommand.getIPMIInterface(), this.config);
            if (!lm.checkIfDCMSLicenseExist()) {
                MOut.G(this).println("The node product key needs to be activated for this device");
                this.statusCode = 155;
                return;
            }
            if (systemLockdownCommand.setSystemLocked(this.status)) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Fail");
                this.statusCode = 149;
            }
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: ipmi oem systemlockdown <on|off>");
    }
}

