/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIPowerCommand
extends SuperBladeCommand {
    private SubCommand subCommand = SubCommand.NO_COMMAND;
    private GlobalDefine.BootDevice bootDevice = GlobalDefine.BootDevice.BIOS;
    private byte cycleInterval = 0;

    @Override
    public String[] getSubCommandsForTabCompletion() {
        return new String[]{"status", "up", "down", "softshutdown", "reset", "bootoption", "cycle", "diag"};
    }

    @Override
    public boolean preValidate() {
        boolean passValidate = false;
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("status")) {
                this.subCommand = SubCommand.STATUS;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("up")) {
                this.subCommand = SubCommand.ON;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("down")) {
                this.subCommand = SubCommand.OFF;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("softshutdown")) {
                this.subCommand = SubCommand.GRACEFULSHUTDOWN;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("reset")) {
                this.subCommand = SubCommand.RESET;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("bootoption")) {
                this.subCommand = SubCommand.BOOTOPTION;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("cycle")) {
                this.subCommand = SubCommand.CYCLE;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("diag")) {
                this.subCommand = SubCommand.DIAG;
                passValidate = true;
            }
        } else {
            this.subCommand = SubCommand.NO_COMMAND;
            passValidate = true;
        }
        block1 : switch (this.subCommand) {
            case OFF: 
            case GRACEFULSHUTDOWN: 
            case RESET: {
                if (this.parameters == null) break;
                switch (this.parameters.length) {
                    case 1: {
                        break block1;
                    }
                }
                passValidate = false;
                break;
            }
            case BOOTOPTION: {
                if (this.parameters == null) break;
                switch (this.parameters.length) {
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (this.parameters[1].equalsIgnoreCase("1")) {
                            this.bootDevice = GlobalDefine.BootDevice.PXE;
                        } else if (this.parameters[1].equalsIgnoreCase("2")) {
                            this.bootDevice = GlobalDefine.BootDevice.HD_DEFAULT;
                        } else if (this.parameters[1].equalsIgnoreCase("3")) {
                            this.bootDevice = GlobalDefine.BootDevice.CD_DVD;
                        } else if (this.parameters[1].equalsIgnoreCase("4")) {
                            this.bootDevice = GlobalDefine.BootDevice.BIOS;
                        } else if (this.parameters[1].equalsIgnoreCase("5")) {
                            this.bootDevice = GlobalDefine.BootDevice.USB_KEY;
                        } else if (this.parameters[1].equalsIgnoreCase("6")) {
                            this.bootDevice = GlobalDefine.BootDevice.USB_HDD;
                        } else if (this.parameters[1].equalsIgnoreCase("7")) {
                            this.bootDevice = GlobalDefine.BootDevice.USB_FLOPPY;
                        } else if (this.parameters[1].equalsIgnoreCase("8")) {
                            this.bootDevice = GlobalDefine.BootDevice.USB_CD_DVD;
                        } else if (this.parameters[1].equalsIgnoreCase("9")) {
                            this.bootDevice = GlobalDefine.BootDevice.UEFI_HD;
                        } else if (this.parameters[1].equalsIgnoreCase("10")) {
                            this.bootDevice = GlobalDefine.BootDevice.UEFI_CD_DVD;
                        } else if (this.parameters[1].equalsIgnoreCase("11")) {
                            this.bootDevice = GlobalDefine.BootDevice.UEFI_USB_KEY;
                        } else if (this.parameters[1].equalsIgnoreCase("12")) {
                            this.bootDevice = GlobalDefine.BootDevice.UEFI_USB_HDD;
                        } else if (this.parameters[1].equalsIgnoreCase("13")) {
                            this.bootDevice = GlobalDefine.BootDevice.UEFI_USB_CDDVD;
                        } else if (this.parameters[1].equalsIgnoreCase("14")) {
                            this.bootDevice = GlobalDefine.BootDevice.UEFI_PXE;
                        } else if (this.parameters[1].equalsIgnoreCase("0")) {
                            this.bootDevice = GlobalDefine.BootDevice.NONE;
                        } else {
                            passValidate = false;
                        }
                        if (this.parameters.length != 3) break;
                        try {
                            int value = Integer.valueOf(this.parameters[2]);
                            if (value >= 0 && 1 >= value) break block1;
                            passValidate = false;
                        }
                        catch (NumberFormatException ex) {
                            passValidate = false;
                        }
                        break;
                    }
                    default: {
                        passValidate = false;
                        break;
                    }
                }
                break;
            }
        }
        if (this.parameters != null) {
            block12 : switch (this.subCommand) {
                case CYCLE: {
                    switch (this.parameters.length) {
                        case 1: {
                            this.cycleInterval = 0;
                            break block12;
                        }
                        case 2: {
                            if (ByteUtility.isNumeric(this.parameters[1])) {
                                this.cycleInterval = Byte.valueOf(this.parameters[1]);
                                break block12;
                            }
                            if (this.parameters[1].equalsIgnoreCase("PXE")) {
                                this.bootDevice = GlobalDefine.BootDevice.PXE;
                                break block12;
                            }
                            passValidate = false;
                            break block12;
                        }
                        case 3: {
                            if (!this.parameters[1].equalsIgnoreCase("PXE")) {
                                passValidate = false;
                                break block12;
                            }
                            this.bootDevice = GlobalDefine.BootDevice.PXE;
                            if (ByteUtility.isNumeric(this.parameters[2])) {
                                this.cycleInterval = Byte.valueOf(this.parameters[2]);
                                break block12;
                            }
                            passValidate = false;
                            break block12;
                        }
                    }
                    passValidate = false;
                    break;
                }
            }
        }
        if (!passValidate) {
            this.printUsage();
            return false;
        }
        return true;
    }

    public void printUsage() {
        MOut.G(this).println("Available commands:");
        MOut.G(this).println("status                           power status");
        MOut.G(this).println("up                               power up system");
        MOut.G(this).println("down                             power down system");
        MOut.G(this).println("softshutdown                     power soft shutdown");
        MOut.G(this).println("reset                            power reset");
        MOut.G(this).println("bootoption [Index][Persistent]   Force a boot device in next boot only");
        MOut.G(this).println("cycle [interval]                 power cycle");
        MOut.G(this).println("diag                             pulse diagnostic interrupt");
        MOut.G(this).println("");
        MOut.G(this).println("");
        MOut.G(this).println("Ex: set power cycle interval as 10 seconds and execute power cycle");
        MOut.G(this).println("IPMI>ipmi power cycle 10");
        MOut.G(this).println("");
        this.printBootOptionIndex();
    }

    public void printBootOptionIndex() {
        MOut.G(this).println("For bootoption index :");
        MOut.G(this).println("1: PXE              2:  Hard-drive");
        MOut.G(this).println("3: CD/DVD           4:  Bios");
        MOut.G(this).println("5: USB KEY          6:  USB HDD");
        MOut.G(this).println("7: USB Floppy       8:  USB CD/DVD");
        MOut.G(this).println("9: UEFI Hard-drive  10: UEFI CD/DVD");
        MOut.G(this).println("11: UEFI USB KEY    12: UEFI USB HDD");
        MOut.G(this).println("13: UEFI USB CD/DVD 14: UEFI PXE");
        MOut.G(this).println("0: NONE");
        MOut.G(this).println("Options requested to be persistent :");
        MOut.G(this).println("0: Disable. Options apply to next boot only [Default]");
        MOut.G(this).println("1: Enable. Options requested to be persistent for all future boots");
    }

    @Override
    public void runCommand() throws Exception {
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        switch (this.subCommand) {
            case STATUS: {
                boolean boolResult = ipmiChassisCommand.isPowerOn();
                if (boolResult) {
                    MOut.G(this).println("Power is currently on.");
                } else {
                    MOut.G(this).println("Power is currently off.");
                }
                this.statusCode = 0;
                break;
            }
            case ON: {
                boolean boolResult = ipmiChassisCommand.powerUp();
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case OFF: {
                boolean boolResult = ipmiChassisCommand.powerDown();
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case GRACEFULSHUTDOWN: {
                boolean boolResult = ipmiChassisCommand.softShutdown();
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case RESET: {
                boolean boolResult = ipmiChassisCommand.reset();
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case BOOTOPTION: {
                boolean boolResult;
                IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
                boolean isOlderBootOrder = ipmiOEMCommand.isOlderBootOptionDevice();
                if (this.parameters != null && this.parameters.length == 1) {
                    byte[] bootOptionParam = ipmiChassisCommand.getBootOptionsParameter();
                    GlobalDefine.BootDevice bootDevice = ipmiChassisCommand.getBootDeviceOption(bootOptionParam, isOlderBootOrder);
                    boolean isBootFlagValid = ipmiChassisCommand.isBootDeviceOptionFlagValid(bootOptionParam);
                    boolean isBootOptionPersisten = ipmiChassisCommand.isBootDeviceOptionPersistent(bootOptionParam);
                    String formatTemplate = " %-15s | %15s %n";
                    StringBuffer output = new StringBuffer();
                    output.append(String.format(formatTemplate, "Option", "Value"));
                    output.append(String.format(formatTemplate, "------", "-----"));
                    output.append(String.format(formatTemplate, new Object[]{"Next boot", bootDevice}));
                    output.append(String.format(formatTemplate, "Boot flag", isBootFlagValid ? "Valid" : "Invalid"));
                    output.append(String.format(formatTemplate, "Persistent", isBootOptionPersisten ? "True" : "False"));
                    MOut.G(this).println(output.toString());
                    MOut.G(this).println("");
                    this.printBootOptionIndex();
                    this.statusCode = 0;
                    break;
                }
                if (this.checkIfSystemLockdown()) break;
                boolean isPersistent = false;
                if (this.parameters != null && this.parameters.length > 2) {
                    boolean bl = isPersistent = Integer.valueOf(this.parameters[2]) == 1;
                }
                if (!(boolResult = ipmiChassisCommand.setBootDeviceOption(this.bootDevice, isOlderBootOrder, isPersistent))) {
                    MOut.G(this).println("Set boot device failed");
                    this.statusCode = 149;
                    break;
                }
                boolResult = ipmiChassisCommand.keepBootFlagValidBit();
                if (!boolResult) {
                    MOut.G(this).println("Can't keep boot flag valid bit");
                    this.statusCode = 149;
                    break;
                }
                MOut.G(this).println("Set boot device done");
                this.statusCode = 0;
                break;
            }
            case CYCLE: {
                boolean boolResult;
                if (this.cycleInterval > 0 && !(boolResult = ipmiChassisCommand.setPowerCycleInterval(this.cycleInterval))) {
                    MOut.G(this).println("Set power cycle interval fail");
                    break;
                }
                boolResult = ipmiChassisCommand.powerCycle();
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case DIAG: {
                boolean boolResult = ipmiChassisCommand.injectNMI();
                if (boolResult) {
                    MOut.G(this).println("Done");
                    this.statusCode = 0;
                    break;
                }
                MOut.G(this).println("Failed");
                this.statusCode = 149;
                break;
            }
            case NO_COMMAND: {
                ACPIInfo acpi = ipmiGlobalCommand.getACPI();
                MOut.G(this).println("ACPI Power Status: " + acpi.getSystemStateInfo() + " (" + acpi.getSystemStateDescription() + ")");
                this.printUsage();
                this.statusCode = 0;
            }
        }
    }

    static enum SubCommand {
        STATUS,
        ON,
        OFF,
        GRACEFULSHUTDOWN,
        RESET,
        BOOTOPTION,
        CYCLE,
        NO_COMMAND,
        DIAG;

    }
}

