/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.CommandIncompleteException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.Parser;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;

public class IPMIUFlashCommand
extends SuperBladeCommand {
    Parser parser;
    String[] subArgs;
    Command command;
    boolean isPreserve = true;
    boolean backup = false;

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("firmware filename is needed");
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + this.parameters[0] + ") not found");
            return false;
        }
        if (this.parameters.length >= 2) {
            this.isPreserve = !this.parameters[1].equals("0");
            for (int i = 1; i < this.parameters.length; ++i) {
                if (this.parameters[i].toLowerCase().indexOf("-backup") == -1) continue;
                this.backup = true;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            guid = IPMIMessagingCommand.getSystemGUIDbyConfig(this.config, 3, 0);
        }
        if (IPMIMessagingCommand.isBeforeX12(guid) && !IPMIMessagingCommand.isB12RoTHW1GUID(guid) && !IPMIMessagingCommand.isB3ST1GUID(guid) && !IPMIMessagingCommand.isHGIMEZZGUID(guid)) {
            this.runIPMIFlasha();
        } else if (IPMIMessagingCommand.isR12OpenBMCGUID(guid) || IPMIMessagingCommand.isR12OpenBMCRoTGUID(guid) || IPMIMessagingCommand.isR13OpenBMCGUID(guid)) {
            this.runIPMIFlasharm();
        } else {
            this.runIPMIFlashrf();
        }
    }

    public void runIPMIFlasha() {
        this.subArgs = this.isPreserve ? new String[]{"ipmi", "flasha", this.parameters[0]} : new String[]{"ipmi", "flasha", this.parameters[0], "0"};
        this.flash();
    }

    public void runIPMIFlasharm() {
        this.subArgs = new String[]{"ipmi", "flasharm", this.parameters[0]};
        this.flash();
        this.ignoreSessionClose(true);
    }

    public void runIPMIFlashrf() {
        this.subArgs = !this.isPreserve ? (this.backup ? new String[]{"ipmi", "flashrf", this.parameters[0], "-backup"} : new String[]{"ipmi", "flashrf", this.parameters[0]}) : (this.backup ? new String[]{"ipmi", "flashrf", this.parameters[0], "-sdr", "-cfg", "-ssl", "-backup"} : new String[]{"ipmi", "flashrf", this.parameters[0], "-sdr", "-cfg", "-ssl"});
        this.flash();
        this.ignoreSessionClose(true);
    }

    public void flash() {
        this.parser = new Parser();
        try {
            this.command = this.parser.parse(this.parser.argumentRoot, this.subArgs);
        }
        catch (CommandIncompleteException commandIncompleteException) {
            // empty catch block
        }
        if (this.command != null) {
            this.command.setConfig(this.config);
            try {
                this.command.execute();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.statusCode = this.command.getStatusCode();
        } else {
            this.statusCode = 144;
        }
    }

    public void printUsage() {
        MOut.G(this).println("ipmi uflash <filename> [Preserve_opt]");
        MOut.G(this).println("0: Do not preserve options");
        MOut.G(this).println("1: Preserve options");
    }
}

