/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMRoTCommand;
import com.supermicro.ipmi.text.MBTLinkService;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class MBTROTCopyCommand
extends SuperBladeCommand {
    private boolean isCopyBMC;
    private boolean isCopyBIOS;
    private boolean isBackupRegion;
    private boolean isGoldenRegion;
    private boolean isNeedReboot;

    @Override
    public boolean preValidate() {
        this.isCopyBMC = false;
        this.isCopyBIOS = false;
        this.isBackupRegion = false;
        this.isGoldenRegion = false;
        this.isNeedReboot = false;
        for (int index = 0; null != this.parameters && index < this.parameters.length; ++index) {
            String param = this.parameters[index];
            if (param.equalsIgnoreCase("-bmc")) {
                this.isCopyBMC = true;
            }
            if (param.equalsIgnoreCase("-bios")) {
                this.isCopyBIOS = true;
            }
            if (param.equalsIgnoreCase("-backup")) {
                this.isBackupRegion = true;
            }
            if (param.equalsIgnoreCase("-golden")) {
                this.isGoldenRegion = true;
            }
            if (!param.equalsIgnoreCase("-reboot")) continue;
            this.isNeedReboot = true;
        }
        if (!(this.isCopyBMC ^ this.isCopyBIOS) || !(this.isBackupRegion ^ this.isGoldenRegion)) {
            MOut.G(this).println("Parameters failed");
            MOut.G(this).println("");
            this.usage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        boolean result = false;
        IPMIOEMRoTCommand rotCommand = new IPMIOEMRoTCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.isCopyBMC && this.isBackupRegion) {
            result = rotCommand.copyBMCBackupImage();
        } else if (this.isCopyBMC && this.isGoldenRegion) {
            result = rotCommand.copyBMCGoldenImage();
        } else if (this.isCopyBIOS && this.isBackupRegion) {
            result = rotCommand.copyBIOSBackupImage();
        } else if (this.isCopyBIOS && this.isGoldenRegion) {
            result = rotCommand.copyBIOSGoldenImage();
        }
        MOut.G(this).println(result ? "Done. BMC will run the requested operations in next cold reset." : "Copy failed");
        int n = this.statusCode = result ? 0 : 149;
        if (this.isNeedReboot) {
            result = MBTLinkService.setColdReset(this);
            if (result) {
                result = MBTLinkService.isLinkRecovery(this);
            }
            this.statusCode = result ? 0 : 149;
        }
    }

    private void usage() {
        MOut.G(this).println("Flash:");
        MOut.G(this).println("-bmc             Copy from active BMC");
        MOut.G(this).println("-bios            Copy from active BIOS");
        MOut.G(this).println("Region:");
        MOut.G(this).println("-backup          To backup region");
        MOut.G(this).println("-golden          To golden region");
        MOut.G(this).println("Preserve_opt:");
        MOut.G(this).println("-reboot          Cold reset and wait for connection recovery");
    }
}

