/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMELCommand;
import com.supermicro.redfish.text.EventListCommand;
import java.util.ArrayList;

public class MELListCommand
extends IPMICommand {
    private static final String[] DATA_FIELD = new String[]{"Event:", "Time:", "Interface:", "User:", "Source:", "Desc:"};
    private static final String SPLIT_LINE = "--------------------------------------------------------------------\n";
    private static final String SPLIT_SPACE = " ";
    private static final String LINE_FEED = "\n";
    private static final int SPLIT_LINE_POS = 3;
    private static final int UNDEFINE_INDEX = -1;

    public MELListCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public int runCommand(int left, int right) throws Exception {
        return this.runCommand(left, right, -1);
    }

    public int runCommand(int last) throws Exception {
        return this.runCommand(-1, -1, last);
    }

    public int runCommand(int left, int right, int last) throws Exception {
        IPMIMELCommand command = new IPMIMELCommand(super.getIPMIInterface());
        System.out.println("Getting MEL records ...");
        try {
            if (!command.update()) {
                System.out.println("MEL parser get errors");
                return 149;
            }
            this.outputList(this.getEventArrayList(command, left, right, last));
            return 0;
        }
        catch (IllegalArgumentException e) {
            System.out.println("There are no event in the input index range. (Exist event 1 to " + command.getEntrySize() + ")");
            return 147;
        }
        catch (Exception e) {
            System.out.println("MEL is not supported on this device.");
            return 153;
        }
    }

    public int runCommand(EventListCommand utils) {
        IPMIMELCommand command = new IPMIMELCommand(super.getIPMIInterface());
        System.out.println("Getting MEL records ...");
        try {
            if (!command.update()) {
                System.out.println("MEL parser get errors");
                return 149;
            }
            this.outputList(command.getEntryArrayList(), utils);
            return 0;
        }
        catch (Exception e) {
            System.out.println("MEL is not supported on this device.");
            return 153;
        }
    }

    private ArrayList<Object[]> getEventArrayList(IPMIMELCommand command, int left, int right, int last) {
        if (left == -1 && right == -1 && last != -1) {
            return command.getEntryArrayList(last);
        }
        if (left != -1 && right != -1 && last == -1) {
            return command.getEntryArrayList(left, right);
        }
        return command.getEntryArrayList();
    }

    private void outputList(ArrayList<Object[]> entryArrayList) {
        StringBuilder strBuilder = new StringBuilder();
        if (entryArrayList.size() > 0) {
            for (int arrayIdx = 0; arrayIdx < entryArrayList.size(); ++arrayIdx) {
                strBuilder.setLength(0);
                strBuilder.append(SPLIT_LINE);
                for (int objIdx = 0; objIdx < entryArrayList.get(arrayIdx).length; ++objIdx) {
                    strBuilder.append(objIdx < DATA_FIELD.length ? DATA_FIELD[objIdx] : "Data" + objIdx + ":");
                    strBuilder.append(entryArrayList.get(arrayIdx)[objIdx]);
                    strBuilder.append(objIdx == 3 ? LINE_FEED : SPLIT_SPACE);
                }
                System.out.println(strBuilder.toString());
            }
        } else {
            System.out.println("MEL empty");
        }
    }

    private void outputList(ArrayList<Object[]> entryArrayList, EventListCommand utils) {
        StringBuilder strBuilder = new StringBuilder();
        boolean isFilterOn = utils.isEventFilter();
        if (entryArrayList.size() > 0) {
            for (int arrayIdx = 0; arrayIdx < entryArrayList.size(); ++arrayIdx) {
                String datetime;
                if (isFilterOn && utils.isDateOutOfRange(datetime = (String)entryArrayList.get(arrayIdx)[1], "/")) continue;
                strBuilder.setLength(0);
                strBuilder.append(SPLIT_LINE);
                for (int objIdx = 0; objIdx < entryArrayList.get(arrayIdx).length; ++objIdx) {
                    strBuilder.append(objIdx < DATA_FIELD.length ? DATA_FIELD[objIdx] : "Data" + objIdx + ":");
                    strBuilder.append(entryArrayList.get(arrayIdx)[objIdx]);
                    strBuilder.append(objIdx == 3 ? LINE_FEED : SPLIT_SPACE);
                }
                System.out.println(strBuilder.toString());
            }
            if (isFilterOn && strBuilder.length() <= 0) {
                System.out.println("There are no event in last " + utils.getDateUnit());
            }
        } else {
            System.out.println("MEL empty");
        }
    }
}

