/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeOverheatShutdownCommand
extends MicroBladeCommand {
    byte enabled;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            try {
                this.enabled = Byte.parseByte(this.parameters[0]);
                if (this.enabled != 0 && this.enabled != 1) {
                    this.printUsage();
                    return false;
                }
            }
            catch (Exception e) {
                this.printUsage();
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.parameters == null) {
            byte status = this.ipmiMicroBladeOEMCommand.getOverHeatShutdownStatus();
            MOut.G(this).println("Current overheat shutdown status: " + (status == 0 ? "disabled" : "enabled"));
            this.statusCode = 0;
        } else {
            boolean result = this.ipmiMicroBladeOEMCommand.setOverHeatShutdownStatus(this.enabled);
            if (result) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Failed");
                this.statusCode = 149;
            }
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: microblade overheatShutdown [0 | 1]");
        MOut.G(this).println("enabled  : 1");
        MOut.G(this).println("disabled : 0");
    }
}

