/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.microblade.PowerSupplyInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladePSUCommand
extends MicroBladeCommand {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void runCommand() throws Exception {
        if (this.getParameters() != null) {
            if (this.getParameters().length != 1) {
                MOut.G(this).println("[psu index] is required");
                this.statusCode = 147;
                return;
            }
            String psuIndex = this.getParameters()[0];
            byte pIndex = (byte)PowerSupplyInfo.getIndex(psuIndex);
            if (pIndex < 0 && (pIndex = (byte)PowerSupplyInfo.getFanIndex(psuIndex)) >= 0) {
                PowerSupplyInfo fanInfo = this.ipmiMicroBladeOEMCommand.getFan(pIndex, (byte)1);
                if (fanInfo.isPresent()) {
                    MOut.G(this).print(fanInfo.toFormatedHeader());
                    MOut.G(this).println(fanInfo.toFanFormatedString());
                    this.statusCode = 0;
                    return;
                }
                MOut.G(this).println("Fan " + psuIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
            if (pIndex < 0) {
                MOut.G(this).println("The PSU index must be A1-A4 or B1-B4");
                this.statusCode = 147;
                return;
            }
            PowerSupplyInfo powerSupplyInfo = this.ipmiMicroBladeOEMCommand.getPowerSupply(pIndex, (byte)1);
            if (!powerSupplyInfo.isPresent()) {
                MOut.G(this).println("PSU " + psuIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
            MOut.G(this).print(powerSupplyInfo.toFormatedHeader());
            MOut.G(this).println(powerSupplyInfo.toFormatedString());
        } else {
            int i;
            for (i = 0; i < 8; ++i) {
                PowerSupplyInfo powerSupplyInfo = this.ipmiMicroBladeOEMCommand.getPowerSupply((byte)i, (byte)1);
                if (powerSupplyInfo.isPresent()) {
                    MOut.G(this).print(powerSupplyInfo.toFormatedHeader());
                    MOut.G(this).println(powerSupplyInfo.toFormatedString());
                    continue;
                }
                MOut.G(this).println("PSU " + PowerSupplyInfo.getIndex(i) + " is not presented");
            }
            MOut.G(this).println("\n");
            for (i = 0; i < 3; ++i) {
                PowerSupplyInfo fanInfo = this.ipmiMicroBladeOEMCommand.getFan((byte)i, (byte)1);
                if (fanInfo.isPresent()) {
                    MOut.G(this).print(fanInfo.toFormatedHeader());
                    MOut.G(this).println(fanInfo.toFanFormatedString());
                    continue;
                }
                MOut.G(this).println("Fan " + PowerSupplyInfo.getFanIndex(i) + " is not presented");
            }
        }
        this.statusCode = 0;
    }
}

