/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.microblade.PowerSupplyInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;
import java.util.Stack;

public class MicroBladePSUPowerCommand
extends MicroBladeCommand {
    byte pIndex;
    boolean isOn = false;

    @Override
    public boolean preValidate() {
        if (this.parameters != null && this.parameters.length == 1) {
            this.pIndex = (byte)PowerSupplyInfo.getIndex(this.parameters[0]);
            if (this.pIndex < 0) {
                MOut.G(this).println("The PSU index must be A1-A4 or B1-B4");
                return false;
            }
        }
        if (this.parameters != null && this.parameters.length >= 2) {
            if (this.parameters[1].equalsIgnoreCase("on")) {
                this.isOn = true;
            } else if (this.parameters[1].equalsIgnoreCase("off")) {
                this.isOn = false;
            } else {
                MOut.G(this).println("The command must be either On or Off.");
                return false;
            }
        }
        return true;
    }

    public static String reverse(String s) {
        Stack<Character> stk = new Stack<Character>();
        for (int i = 0; i < s.length(); ++i) {
            stk.push(Character.valueOf(s.charAt(i)));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            sb.append(stk.pop());
        }
        return sb.toString();
    }

    @Override
    public void runCommand() throws Exception {
        if (this.getParameters() == null || this.getParameters().length != 2) {
            String s1 = this.ipmiMicroBladeOEMCommand.getALLPowerPresent();
            String s2 = this.ipmiMicroBladeOEMCommand.getALLPowerStatus();
            s1 = s1.substring(0, 8);
            s1 = MicroBladePSUPowerCommand.reverse(s1);
            s2 = s2.substring(0, 8);
            s2 = MicroBladePSUPowerCommand.reverse(s2);
            char[] ch = s2.toCharArray();
            char[] ch_present = s1.toCharArray();
            for (int i = 0; i < ch.length; ++i) {
                String isOn;
                if (ch_present[i] == '0') continue;
                String string = isOn = ch[i] == '1' ? "On" : "Off";
                if (i < 4) {
                    MOut.G(this).println("A" + (i + 1) + ": " + isOn);
                    continue;
                }
                MOut.G(this).println("B" + (i - 3) + ": " + isOn);
            }
            MOut.G(this).println("\nUsage: microbBlade psu <index> [on|off]");
        } else {
            this.pIndex = (byte)(this.pIndex + 1);
            this.ipmiMicroBladeOEMCommand.setPowerStatus(this.pIndex, this.isOn);
        }
        this.statusCode = 0;
    }
}

