/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeSwitchLANDHCPCommand
extends MicroBladeCommand {
    byte sIndex = (byte)-1;
    int mode;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            if (this.parameters.length >= 2) {
                try {
                    this.mode = Integer.parseInt(this.getParameters()[1]);
                }
                catch (Exception e) {
                    MOut.G(this).println(" [static:1 |dhcp:2]");
                    return false;
                }
                if (this.mode != 1 && this.mode != 2) {
                    MOut.G(this).println(" [static:1 |dhcp:2]");
                    return false;
                }
            }
            if (this.parameters.length >= 1) {
                String switchIndex = this.getParameters()[0];
                this.sIndex = (byte)SwitchInfo.getIndex(switchIndex);
                if (this.sIndex < 0) {
                    MOut.G(this).println("The switch index must be A1-A2 or B1-B2");
                    return false;
                }
            }
        } else {
            MOut.G(this).println("Usage: microBlade switch lan dhcp <switch index> [static:1 |dhcp:2]");
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void runCommand() throws Exception {
        if (this.getParameters().length == 1) {
            SwitchInfo switchInfo = this.ipmiMicroBladeOEMCommand.getSwitch(this.sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.getParameters()[0] + " is not presented");
                this.statusCode = 151;
                return;
            }
            MOut.G(this).println("Usage: microBlade switch lan dhcp <switch index> [static:1 |dhcp:2]");
            String result = this.ipmiMicroBladeOEMCommand.getSwitchDHCPStatus(this.sIndex + 1);
            MOut.G(this).println(this.getParameters()[0].toUpperCase() + " IP Mode: " + result);
        } else if (this.getParameters().length == 2) {
            SwitchInfo switchInfo = this.ipmiMicroBladeOEMCommand.getSwitch(this.sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.getParameters()[0] + " is not presented");
                this.statusCode = 151;
                return;
            }
            boolean b = this.ipmiMicroBladeOEMCommand.setSwitchDHCPStatus(this.sIndex + 1, this.mode);
            if (!b) {
                MOut.G(this).println("Update IP Mode Fail");
                this.statusCode = 149;
                return;
            }
            MOut.G(this).println("Update IP Mode Successfully");
        } else {
            MOut.G(this).println("Usage: microBlade switch lan dhcp <switch index> [static:1 |dhcp:2]");
        }
        this.statusCode = 0;
    }
}

