/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeSwitchPowerCommand
extends MicroBladeCommand {
    byte sIndex = (byte)-1;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            if (this.parameters.length >= 1) {
                String switchIndex = this.getParameters()[0];
                this.sIndex = (byte)SwitchInfo.getIndex(switchIndex);
                if (this.sIndex < 0) {
                    MOut.G(this).println("The switch index must be A1-A2 or B1-B2");
                    return false;
                }
            }
        } else {
            this.printUsage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.getParameters().length == 1) {
            SwitchInfo switchInfo = this.ipmiMicroBladeOEMCommand.getSwitch(this.sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.getParameters()[0] + " is not presented");
                this.statusCode = 151;
                return;
            }
            byte result = this.ipmiMicroBladeOEMCommand.getSwitchPowerStatus(this.sIndex + 1);
            String s = "Unknown";
            if (result == 0) {
                s = "Off";
            } else if (result == 1) {
                s = "On";
            }
            this.printUsage();
            MOut.G(this).println(this.getParameters()[0] + " power is " + s);
            this.statusCode = 0;
        } else if (this.getParameters().length == 2) {
            SwitchInfo switchInfo = this.ipmiMicroBladeOEMCommand.getSwitch(this.sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.getParameters()[0] + " is not presented");
                this.statusCode = 151;
                return;
            }
            this.sIndex = (byte)(this.sIndex + 1);
            boolean result = false;
            if (this.getParameters()[1].equalsIgnoreCase("on")) {
                result = this.ipmiMicroBladeOEMCommand.setSwitchPowerStatus(this.sIndex, (byte)1);
            } else if (this.getParameters()[1].equalsIgnoreCase("off")) {
                result = this.ipmiMicroBladeOEMCommand.setSwitchPowerStatus(this.sIndex, (byte)0);
            } else if (this.getParameters()[1].equalsIgnoreCase("reset")) {
                result = this.ipmiMicroBladeOEMCommand.setSwitchPowerReset(this.sIndex);
            } else {
                this.printUsage();
            }
            if (result) {
                this.statusCode = 0;
                MOut.G(this).println("Done");
            } else {
                this.statusCode = 149;
            }
        } else {
            this.printUsage();
            this.statusCode = 0;
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage: microBlade switch power <switch index> [option]");
        MOut.G(this).println("       For options: Reset\n");
    }
}

