/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeSwitchTimeCommand
extends MicroBladeCommand {
    byte sIndex = (byte)-1;

    @Override
    public boolean preValidate() {
        if (this.parameters != null) {
            if (this.parameters.length >= 1) {
                String switchIndex = this.getParameters()[0];
                this.sIndex = (byte)SwitchInfo.getIndex(switchIndex);
                if (this.sIndex < 0) {
                    MOut.G(this).println("The switch index must be A1-A2 or B1-B2");
                    return false;
                }
            }
        } else {
            MOut.G(this).println("Usage: microBlade switch getTime <switch index>");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.getParameters().length == 1) {
            SwitchInfo switchInfo = this.ipmiMicroBladeOEMCommand.getSwitch(this.sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.getParameters()[0] + " is not presented");
                this.statusCode = 151;
                return;
            }
            String result = this.ipmiMicroBladeOEMCommand.getSwitchTime(this.sIndex + 1);
            MOut.G(this).println("Time: " + result);
        } else {
            MOut.G(this).println("Usage: microBlade switch getTime <switch index>");
        }
        this.statusCode = 0;
    }
}

