/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NMPStateCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIDCMOEMCommand ipmiDCMOEMCommand = null;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            this.statusCode = 153;
            return;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(ipmb);
        } else {
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        }
        if (this.parameters != null && this.parameters.length == 1) {
            byte pState = 0;
            String para1 = this.parameters[0];
            try {
                pState = (byte)Integer.parseInt(para1);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).print(ex.getMessage());
                this.statusCode = 147;
                return;
            }
            try {
                byte tState = -1;
                ipmiDCMOEMCommand.setMaxAllowedCPU_P_T_State((byte)0, pState, tState);
                MOut.G(this).print("Done");
            }
            catch (Exception ex1) {
                MOut.G(this).println(ex1.getMessage());
                MOut.G(this).println("(Node manager should be disabled for setting P-State)");
                this.statusCode = 148;
                return;
            }
            this.statusCode = 0;
            return;
        }
        try {
            byte[] state = ipmiDCMOEMCommand.getMaxAllowedCPU_P_T_State((byte)0);
            byte[] nOfState = ipmiDCMOEMCommand.getNumberOf_P_T_StateRequest((byte)0);
            MOut.G(this).println("Current P-State   = " + state[0]);
            MOut.G(this).println("Number of P-State = " + nOfState[0]);
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        this.statusCode = 0;
    }
}

