/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NMVerCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIDCMOEMCommand ipmiDCMOEMCommand = null;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            this.statusCode = 153;
            return;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(ipmb);
        } else {
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        }
        IPMIDCMOEMCommand.NodeManagerVersion ver = null;
        try {
            ver = ipmiDCMOEMCommand.getNodeManagerVersion();
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("C1h")) {
                MOut.G(this).println(ex.getMessage());
                this.statusCode = 153;
                return;
            }
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        if (ver == null) {
            MOut.G(this).println("Call getNodeManagerVersion failed");
        }
        if (ver.nodeManagerVersion == 1) {
            MOut.G(this).println("Node Manager Version = 1.0");
        } else if (ver.nodeManagerVersion == 2) {
            MOut.G(this).println("Node Manager Version = 1.5");
        } else if (ver.nodeManagerVersion == 3) {
            MOut.G(this).println("Node Manager Version = 2.0");
        } else if (ver.nodeManagerVersion == 4) {
            MOut.G(this).println("Node Manager Version = 2.5");
        } else if (ver.nodeManagerVersion == 5) {
            MOut.G(this).println("Node Manager Version = 3.0");
        } else if (ver.nodeManagerVersion == 6) {
            MOut.G(this).println("Node Manager Version = 4.0");
        } else if (ver.nodeManagerVersion == 7) {
            MOut.G(this).println("Node Manager Version = 5.0");
        } else if (ver.nodeManagerVersion == 8) {
            MOut.G(this).println("Node Manager Version = 6.0");
        } else {
            MOut.G(this).println("Node Manager Version = unknown");
        }
        MOut.G(this).println("Firmware Version     = " + ver.majorFirmwareRevision + "." + ByteUtility.byteToHex(ver.minorFirmwareRevision));
        this.statusCode = 0;
    }
}

