/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMINVMECommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMITASCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;
import java.util.Collections;

public class NVMEIBListCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMITASCommand ipmiTasCommand = new IPMITASCommand(null);
        IPMINVMECommand ipmiNVMECommand = new IPMINVMECommand(null);
        ipmiNVMECommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmiTasCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (!ipmiTasCommand.checkTASAlive()) {
            this.statusCode = 0;
            return;
        }
        int deviceCount = ipmiTasCommand.getNVMEDeviceCount();
        if (deviceCount == 0) {
            MOut.G().println("No NVME devices.");
            this.statusCode = 0;
            return;
        }
        ArrayList<IPMITASCommand.SmartInfo> list = new ArrayList<IPMITASCommand.SmartInfo>();
        String result = new String();
        ArrayList<IPMINVMECommand.NVMEAOCInfo> nvmeAOCInfos = ipmiNVMECommand.getAll();
        for (int i = 0; i < deviceCount; ++i) {
            int offset = 0;
            int lengthCount = 0;
            byte currentLength = 0;
            int TotalLength = ipmiTasCommand.getSmartTotalDataLength(i);
            do {
                byte[] data = ipmiTasCommand.getSmartRetunInfo(i, offset);
                currentLength = data[6];
                byte[] smartInfo = new byte[currentLength];
                System.arraycopy(data, 7, smartInfo, 0, currentLength);
                offset += 32;
                result = result + new String(smartInfo);
            } while ((lengthCount += currentLength) < TotalLength);
            if (result.indexOf(";18:") == -1) {
                MOut.G().println("Command abort due to TAS update, please try again");
                this.statusCode = 0;
                return;
            }
            list.add(ipmiTasCommand.createSmartStructure(result));
            result = "";
            IPMINVMECommand.VPD VPD2 = null;
            for (int j = 0; nvmeAOCInfos != null && j < nvmeAOCInfos.size(); ++j) {
                for (int k = 0; k < nvmeAOCInfos.get((int)j).aocGroups.size() && (VPD2 = nvmeAOCInfos.get((int)j).aocGroups.get(k).getMatchVPD(((IPMITASCommand.SmartInfo)list.get((int)i)).serialNumber)) == null; ++k) {
                }
                if (VPD2 != null) break;
            }
            ((IPMITASCommand.SmartInfo)list.get((int)i)).vpd = VPD2;
        }
        boolean nongroup = false;
        byte[] dropGroupStatus = null;
        try {
            dropGroupStatus = ipmiNVMECommand.getDropGroupStatus();
            if (dropGroupStatus[0] == 1) {
                nongroup = true;
            }
        }
        catch (Exception lengthCount) {
            // empty catch block
        }
        MOut.G(this).print(this.toFormatedHeader());
        Collections.sort(list);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ipmiOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] productID = ipmiOEMCommand.getProductID();
        boolean isOP = IPMIOEMCommand.getBoardModel(productID).contains("X11OP");
        if (nongroup) {
            isOP = true;
        }
        for (int i = 0; i < list.size(); ++i) {
            MOut.G(this).print(this.toFormatedString((IPMITASCommand.SmartInfo)list.get(i), isOP));
        }
        this.statusCode = 0;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-10s | %20s | %15s | %10s | %8s | %7s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Name", "Vendor", "Capacity", "IB Temp.", "Locate", "slot"));
        header.append(String.format(formatTemplate, "----", "------", "--------", "--------", "------", "----"));
        return header.toString();
    }

    public String toFormatedString(IPMITASCommand.SmartInfo smartInfo, boolean isOP) {
        String formatTemplate = " %-10s | %20s | %15s | %10s | %8s | %7s\n";
        StringBuffer fStr = new StringBuffer();
        String isLocate = new String();
        isLocate = smartInfo.vpd == null ? "unknown" : (smartInfo.vpd.isLocated() ? "Yes" : "No");
        if (isOP) {
            fStr.append(String.format(formatTemplate, smartInfo.name, this.parseVendor(smartInfo.vendor), ByteUtility.readableFileSize(smartInfo.capacity * 1024L), smartInfo.temperature, isLocate, smartInfo.vpd == null ? "unknown" : Byte.valueOf(smartInfo.vpd.getSlot())));
        } else {
            fStr.append(String.format(formatTemplate, smartInfo.name, this.parseVendor(smartInfo.vendor), ByteUtility.readableFileSize(smartInfo.capacity * 1024L), smartInfo.temperature, isLocate, smartInfo.vpd == null ? "unknown" : Integer.valueOf(smartInfo.vpd.getRealSlot())));
        }
        return fStr.toString();
    }

    public String parseVendor(String modelName) {
        if (modelName.contains("INTEL")) {
            return "INTEL";
        }
        if (modelName.contains("SAMSUNG")) {
            return "SAMSUNG";
        }
        return modelName;
    }
}

