/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.RedfishTokenCommand;

public class SBBInfoCommand
extends RedfishTokenCommand {
    @Override
    public void runCommand() throws Exception {
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/redfish/v1/Chassis/1/" + "Oem/" + "Supermicro/" + "MultiNodes/";
        int result = this.sessionLoginClient.send_https_get(url);
        if (result == 404) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        if (result >= 200 && result <= 210) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(this.sessionLoginClient.getResponseString());
            JsonNode member = node.path("Members");
            if (member.isArray()) {
                for (JsonNode l : member) {
                    url = "https://" + ip + l.path("@odata.id").asText();
                    int result2 = this.sessionLoginClient.send_https_get(url);
                    if (result2 < 200 || result2 > 210) continue;
                    try {
                        JsonNode system = mapper.readTree(this.sessionLoginClient.getResponseString());
                        JsonNode name = system.path("Name");
                        JsonNode ipv4 = system.path("IPv4Address");
                        JsonNode uid = system.path("UID");
                        JsonNode power = system.path("PowerStatus");
                        JsonNode dc = system.path("DCOutputPower");
                        JsonNode current = system.path("OutputCurrent");
                        JsonNode biosver = system.path("BIOSVersion");
                        JsonNode bmcver = system.path("BMCVersion");
                        JsonNode cpldver = system.path("CPLDVersion");
                        JsonNode mac = system.path("BMCMAC");
                        MOut.G(this).println("---------------------------------------------------------------------------");
                        String formatTemplate = " %-25s | %-45s |\n";
                        StringBuffer fStr = new StringBuffer();
                        fStr.append(String.format(formatTemplate, "Name", name.asText()));
                        fStr.append(String.format(formatTemplate, "IPv4", ipv4.asText()));
                        fStr.append(String.format(formatTemplate, "UID", uid.asText()));
                        fStr.append(String.format(formatTemplate, "PowerStatus", power.asText()));
                        fStr.append(String.format(formatTemplate, "BIOS Version", biosver.asText()));
                        fStr.append(String.format(formatTemplate, "BMC Version", bmcver.asText()));
                        fStr.append(String.format(formatTemplate, "CPLD Version", cpldver.asText()));
                        fStr.append(String.format(formatTemplate, "MAC", mac.asText()));
                        fStr.append(String.format(formatTemplate, "DC Output Power", dc.asText()));
                        fStr.append(String.format(formatTemplate, "Output Current", current.asText()));
                        MOut.G(this).print(fStr.toString());
                        MOut.G(this).println("---------------------------------------------------------------------------");
                    }
                    catch (JsonParseException ex) {
                        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL == 0) continue;
                        ex.printStackTrace();
                    }
                }
                this.statusCode = 0;
            }
        } else {
            this.printFailMessage(result, this.sessionLoginClient.getResponseString());
            MOut.G(this).println("Failed");
            this.statusCode = 149;
        }
    }
}

